﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Music" Object="Music" InnerID="Request.QueryString['ID']" Validate="True" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>编辑音乐</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript">
var _page = "music_edit";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _id = "<%=Request.QueryString["ID"]%>";
var _guid = "<%=Music[ID]%>";
var _playerID = "<%=Music[PlayerID]%>";
var _tagAddList = new Array();
var _tagDeleteList = new Array();
var _tagAddIndex = 0;
var _tagDeleteIndex = 0;
var _albumAddList = new Array();
var _albumDeleteList = new Array();
var _albumAddIndex = 0;
var _albumDeleteIndex = 0;
var _personAddList = new Array();
var _personDeleteList = new Array();
var _personAddIndex = 0;
var _personDeleteIndex = 0;
var _uploadForPlay;
var _uploadForDownload;
var _isLocked = <%=Convert.ToString(User["IsLocked"]).ToLower()%>;
var _lang_locked = "你被锁定，不能操作！";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_name_empty = "名称不能空！";
var _lang_start_upload_play = "开始上传播放文件...";
var _lang_uploading_play = "正在上传播放文件...";
var _lang_start_upload_download = "开始上传下载文件...";
var _lang_uploading_download = "正在上传下载文件...";
var _lang_modifying_tag = "正在修改标签...";
var _lang_modifying_album = "正在修改专辑...";
var _lang_modifying_person = "正在修改人物...";

var _tags = new Array();
<ilghar:List Object="Music.Tag" Condition="MusicID=Music[ID]">
	<ilghar:Record>
		_tags[_tags.length] = {ID:"<%=TagID%>",Name:"<%=TagName%>",PageGenerate:"<%=TagPageGenerate%>",PageTemplate:"<%=TagPageTemplate%>",PageID:"<%=TagPageID%>",PageExtension:"<%=TagPageExtension%>"};
	</ilghar:Record>
</ilghar:List>

var _albums = new Array();
<ilghar:List Object="Music.Album" Condition="MusicID=Music[ID]">
	<ilghar:Record>
		_albums[_albums.length] = {ID:"<%=AlbumID%>",Name:"<%=AlbumName%>",PageGenerate:"<%=AlbumPageGenerate%>",PageTemplate:"<%=AlbumPageTemplate%>",PageID:"<%=AlbumPageID%>",PageExtension:"<%=AlbumPageExtension%>"};
	</ilghar:Record>
</ilghar:List>

var _persons = new Array();
<ilghar:List Object="Music.Person" Condition="MusicID=Music[ID]">
	<ilghar:Record>
		_persons[_persons.length] = {ID:"<%=PersonID%>",Name:"<%=PersonName%>",PageGenerate:"<%=PersonPageGenerate%>",PageTemplate:"<%=PersonPageTemplate%>",PageID:"<%=PersonPageID%>",PageExtension:"<%=PersonPageExtension%>"};
	</ilghar:Record>
</ilghar:List>
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame_flipCHS.gif" alt="关闭侧栏导航" /></div>
	<div class="Title"><a href="list.aspx">音乐列表</a> → <%=Music[Name]%></div>
</div>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">编辑</li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			<tfoot>
				<tr><td colspan="2"><input type="submit" value="编辑" /></td></tr>
			</tfoot>
			<tbody>
				<tr>
					<th width="120">名称：</th>
					<td><input type="text" name="Name" value="<%=Music[Name]%>" size="60" maxlength="255" class="Text <%=PageLang%>Font" /></td>
				</tr>
				<tr>
					<th>类别：</th>
					<td>
						<select name="CategoryID" class="<%=PageLang%>Font">
							<option value="" Name="" PageGenerate="" PageTemplate="" PageID="" PageExtension="">未指定</option>
							<ilghar:Tree Object="MusicCategory">
								<ilghar:Control>
									<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
									<ilghar:Line>│</ilghar:Line>
									<ilghar:TopOpen>┌</ilghar:TopOpen>
									<ilghar:Top>┌</ilghar:Top>
									<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
									<ilghar:Middle>├</ilghar:Middle>
									<ilghar:BottomOpen>└</ilghar:BottomOpen>
									<ilghar:Bottom>└</ilghar:Bottom>
								</ilghar:Control>
								<ilghar:Record>
									<%If Guid.Equals(ID, Music[CategoryID])%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" selected="selected"><%=Control%><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>"><%=Control%><%=Name%></option>
									<%EndIf%>
									<%=ChildRecords%>
								</ilghar:Record>
							</ilghar:Tree>
						</select>
					</td>
				</tr>
				<tr>
					<th>地区：</th>
					<td>
						<select name="RegionID" class="<%=PageLang%>Font">
							<option value="" Name="" PageGenerate="" PageTemplate="" PageID="" PageExtension="">未指定</option>
							<ilghar:Tree Object="Region">
								<ilghar:Control>
									<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
									<ilghar:Line>│</ilghar:Line>
									<ilghar:TopOpen>┌</ilghar:TopOpen>
									<ilghar:Top>┌</ilghar:Top>
									<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
									<ilghar:Middle>├</ilghar:Middle>
									<ilghar:BottomOpen>└</ilghar:BottomOpen>
									<ilghar:Bottom>└</ilghar:Bottom>
								</ilghar:Control>
								<ilghar:Record>
									<%If Guid.Equals(ID, Music[RegionID])%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" selected="selected"><%=Control%><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>"><%=Control%><%=Name%></option>
									<%EndIf%>
									<%=ChildRecords%>
								</ilghar:Record>
							</ilghar:Tree>
						</select>
					</td>
				</tr>
				<tr>
					<th>语言：</th>
					<td>
						<select name="LanguageID" class="<%=PageLang%>Font">
							<option value="" Name="" PageGenerate="" PageTemplate="" PageID="" PageExtension="">未指定</option>
							<ilghar:List Object="Language">
								<ilghar:Record>
									<%If Guid.Equals(ID, Music[LanguageID])%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>"><%=Name%></option>
									<%EndIf%>
								</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>播放器：</th>
					<td>
						<select name="PlayerID" class="<%=PageLang%>Font">
							<option value="52757e5b-ce5f-4240-b168-908cc2a84676">MediaPlayer</option>
							<option value="b568b1fe-c41c-432b-8276-8c8c4fcb7918">RealPlayer</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>播放文件：</th>
					<td>
						<input id="URLTextbox" type="text" name="URL" value="<%=Music[URL]%>" size="80" class="Text CHSFont" />
						<input id="URLBrowse" type="button" value="浏览..." />
					</td>
				</tr>
				<tr>
					<th>下载文件：</th>
					<td>
						<input id="DownloadTextbox" type="text" name="Download" value="<%=Music[Download]%>" size="80" class="Text CHSFont" />
						<input id="DownloadBrowse" type="button" value="浏览..." />
					</td>
				</tr>
				<tr>
					<th>专辑：</th>
					<td>
						<input id="AlbumSelect" type="button" value="选择..." />
						<div id="AlbumDiv"></div>
					</td>
				</tr>
				<tr>
					<th>人物：</th>
					<td>
						<input id="PersonSelect" type="button" value="选择..." />
						<div id="PersonDiv"></div>
					</td>
				</tr>
				<tr>
					<th>标签：</th>
					<td>
						<input id="TagSelect" type="button" value="选择..." />
						<div id="TagDiv"></div>
					</td>
				</tr>
				<tr>
					<th>歌词：</th>
					<td>
						<textarea cols="70" rows="7" name="Lyric" class="Text <%=PageLang%>Font" wrap="off"><%=Music[Lyric]%></textarea>
					</td>
				</tr>
				<tr>
					<th>字幕：</th>
					<td>
						<textarea cols="70" rows="7" name="Title" class="Text <%=PageLang%>Font" wrap="off"><%=Music[Title]%></textarea>
					</td>
				</tr>
			</tbody>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>uploader.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>music.js"></script>
</body>
</html>