﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>下载列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Download.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Download.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Download.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Download.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Download.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Download.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 平台
	string platformID = Request.QueryString["PlatformID"];
	if (!String.IsNullOrEmpty(platformID))
	{
		if (platformID == "0")
			condition.Append(and + Alias.Download.PlatformPageIDs + " IS NULL");
		else
			condition.Append(and + Alias.Download.PlatformPageIDs + " LIKE '%" + platformID + "%'");
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 授权
	string licenseID = Request.QueryString["LicenseID"];
	if (!String.IsNullOrEmpty(licenseID))
	{
		if (licenseID == "0")
			condition.Append(and + Alias.Download.LicenseID + " IS NULL");
		else
			condition.Append(and + Alias.Download.LicenseID + "=" + licenseID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类型
	string typeID = Request.QueryString["TypeID"];
	if (!String.IsNullOrEmpty(typeID))
	{
		if (typeID == "0")
			condition.Append(and + Alias.Download.TypeID + " IS NULL");
		else
			condition.Append(and + Alias.Download.TypeID + "=" + typeID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 语言
	string languageID = Request.QueryString["LanguageID"];
	if (!String.IsNullOrEmpty(languageID))
	{
		if (languageID == "0")
			condition.Append(and + Alias.Download.LanguageID + " IS NULL");
		else
			condition.Append(and + Alias.Download.LanguageID + "=" + languageID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Download.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Download.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Download.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Download.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Download.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Download.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Download.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Download.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Download.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Download.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Download.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Download.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Download.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Download.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Download.Up + " DESC";
			break;
		case "12":
			sort = Alias.Download.Up + " ASC";
			break;
		case "13":
			sort = Alias.Download.Down + " DESC";
			break;
		case "14":
			sort = Alias.Download.Down + " ASC";
			break;
		case "15":
			sort = Alias.Download.Error + " DESC";
			break;
		case "16":
			sort = Alias.Download.Error + " ASC";
			break;
		case "17":
			sort = Alias.Download.DownCount + " DESC";
			break;
		case "18":
			sort = Alias.Download.DownCount + " ASC";
			break;
		default:
			sort = Alias.Download.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "download_list";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _isLocked = <%=Convert.ToString(User["IsLocked"]).ToLower()%>;
var _lang_locked = "你被锁定，不能操作！";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_recycle = "回收";
var _lang_delete = "删除";
var _lang_recover = "还原";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame_flipCHS.gif" alt="关闭侧栏导航" /></div>
	<div class="Title">下载列表</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">下载列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx">添加下载</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsRecycled">
			<option value="">是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select id="IsChecked">
			<option value="">是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="IsRecommended">
			<option value="">是否推荐</option>
			<option value="false">未推荐</option>
			<option value="true">已推荐</option>
		</select>
		<select id="IsHeld">
			<option value="">是否置顶</option>
			<option value="false">未置顶</option>
			<option value="true">已置顶</option>
		</select>
		<select id="PlatformID" class="<%=PageLang%>Font">
			<option value="">所有平台</option>
			<option value="0">未指定平台</option>
			<ilghar:List Object="Platform">
				<ilghar:Record>
					<option value="<%=PageID%>"><%=Name%></option>
				</ilghar:Record>
			</ilghar:List>
		</select>
		<select id="LicenseID" class="<%=PageLang%>Font">
			<option value="">所有授权</option>
			<option value="0">未指定授权</option>
			<ilghar:List Object="License">
				<ilghar:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ilghar:Record>
			</ilghar:List>
		</select>
		<select id="TypeID" class="<%=PageLang%>Font">
			<option value="">所有类型</option>
			<option value="0">未指定类型</option>
			<ilghar:List Object="Type">
				<ilghar:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ilghar:Record>
			</ilghar:List>
		</select>
		<select id="LanguageID" class="<%=PageLang%>Font">
			<option value="">所有语言</option>
			<option value="0">未指定语言</option>
			<ilghar:List Object="Language">
				<ilghar:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ilghar:Record>
			</ilghar:List>
		</select>
	</div>
	<div class="ToolBar">
		<select id="CategoryID" class="<%=PageLang%>Font">
			<option value="">所有类别</option>
			<option value="0">未指定类别</option>
			<ilghar:Tree Object="Category">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<%If Convert.ToString(ID) == Request.QueryString["CategoryID"]%>
						<option value="<%=ID%>" selected="selected"><%=Control%><%=Name%></option>
					<%Else%>
						<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%EndIf%>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<input type="checkbox" id="IncludeSubCategory" /><label for="IncludeSubCategory">子类</label>
		<select id="Sort">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
			<option value="3">人气↓</option>
			<option value="4">人气↑</option>
			<option value="5">推荐↓</option>
			<option value="6">推荐↑</option>
			<option value="7">置顶↓</option>
			<option value="8">置顶↑</option>
			<option value="9">编号↓</option>
			<option value="10">编号↑</option>
			<option value="11">顶↓</option>
			<option value="12">顶↑</option>
			<option value="13">踩↓</option>
			<option value="14">踩↑</option>
			<option value="15">错误↓</option>
			<option value="16">错误↑</option>
			<option value="17">下载↓</option>
			<option value="18">下载↑</option>
		</select>
		<input id="Keyword" value="<%=Request.QueryString["Keyword"]%>" class="Text <%=PageLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
		</select>
		<input id="Search" type="button" value="搜索" class="Button" />
		<input id="SelectAll" type="button" value="全选" class="Button" />
		<input id="ReverseSelect" type="button" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th>名称</th>
					<th width="115">更新日期</th>
					<th width="40">下载</th>
					<th width="40">人气</th>
					<th width="40">顶</th>
					<th width="40">踩</th>
					<th width="40">错误</th>
					<th width="60">地址列表</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Download" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr id="Row<%=InnerID%>">
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td class="<%=PageLang%>Font"><a href="edit.aspx?ID=<%=InnerID%>"><%=Name%></a></td>
							<td><%=UpdateTime%></td>
							<td><%=DownCount%></td>
							<td><%=HitCount%></td>
							<td><%=Up%></td>
							<td><%=Down%></td>
							<td><%=Error%></td>
							<td><a href="url/list.aspx?DownloadID=<%=InnerID%>">地址列表</a></td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>down.js"></script>
</body>
</html>