﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Article.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Article.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Article.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Article.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Article.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Article.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Article.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Article.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Article.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类型
	string type = Request.QueryString["Type"];
	if (!String.IsNullOrEmpty(type))
		condition.Append(and + Alias.Article.Type + "='" + type + "'");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Title")
			condition.Append(and + Alias.Article.Title + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Content")
			condition.Append(and + Alias.Article.Content + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Article.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Article.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Article.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Article.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Article.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Article.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Article.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Article.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Article.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Article.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Article.Up + " DESC";
			break;
		case "12":
			sort = Alias.Article.Up + " ASC";
			break;
		case "13":
			sort = Alias.Article.Down + " DESC";
			break;
		case "14":
			sort = Alias.Article.Down + " ASC";
			break;
		default:
			sort = Alias.Article.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>标题</th>
			<th width="115">更新时间</th>
			<th width="40">点击</th>
			<th width="40">顶</th>
			<th width="40">踩</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Article" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td><a href="edit.aspx?ID=<%=InnerID%>"><%=Title%></a></td>
					<td><%=UpdateTime%></td>
					<td><%=HitCount%></td>
					<td><%=Up%></td>
					<td><%=Down%></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif" alt="首页" />
					<img src="<%=ImagePath%>pagination/previous_page_off.gif" alt="上一页" />
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif" alt="首页" /></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif" alt="上一页" /></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif" alt="下一页" />
					<img src="<%=ImagePath%>pagination/last_page_off.gif" alt="尾页" />
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif" alt="下一页" /></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif" alt="尾页" /></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
