﻿function AjaxUploader()
{
	var _adoStream = null;
	var _xmlDom = null;
	var _len = 1024 * 50;//50k
	var _url;
	var _status = "";//Initialized，Sending，Checking，Completed
	var _renamed = false;
	
	this.UploadCallBack = function(xmlHttp)
	{
		if (!_renamed)
		{
			var file = _xmlDom.selectSingleNode("//file");
			file.setAttribute("fileName", xmlHttp.responseText);
			_renamed = true;
		}
		
		XmlHttpCallBack(xmlHttp);
	}

	this.Init = function(filePath, url)
	{
		_status = "";
		_url = url;

		var fileName;
		if (arguments.length == 3 && arguments[2])
		{//用户决定文件名
			fileName = filePath.substr(filePath.lastIndexOf("\\") + 1);
		}
		else
		{//系统决定文件名
			fileName = filePath.substr(filePath.lastIndexOf("."));
		}
		
		if (arguments.length == 4)
			_len = arguments[3];
		
		try
		{
			if (_adoStream == null)
			{
				_adoStream = new ActiveXObject("ADODB.Stream");
			}
			else
			{
				if (_adoStream.State != 0)
					_adoStream.Close();
			}
			
			_adoStream.Type = 1;
			_adoStream.Open();
			_adoStream.LoadFromFile(filePath);
			
			if (_xmlDom == null)
				_xmlDom = new ActiveXObject("MSXML2.DOMDocument");
			_xmlDom.loadXML('<?xml version="1.0"  encoding="utf-8" ?><root><file isLast="false" fileName="' + fileName + '" position=""></file></root>');
			_xmlDom.documentElement.setAttribute("xmlns:dt", "urn:schemas-microsoft-com:datatypes");
			_xmlDom.selectSingleNode("//file").dataType = "bin.base64";
			
			_status = "Initialized";
		}
		catch(e)
		{
			_adoStream = null;
			_xmlDom = null;
			alert(e.message);
		}
	}
	
	this.IsComplete = function()
	{
		if (_status == "Completed")
			return true;
		else
			return false;
	}
	
	this.IsSending = function()
	{
		if (_status == "Sending")
			return true;
		else
			return false;
	}
	
	this.GetSize = function()
	{
		if (_adoStream == null)
			return 0;
		
		return _adoStream.Size;
	}
	
	this.GetPosition = function()
	{
		if (_adoStream == null)
			return 0;
		
		return _adoStream.Position;
	}
	
	this.Send = function()
	{
		if (_status == "" || _status == "Completed")
			return;
			
		var file = _xmlDom.selectSingleNode("//file");
		file.setAttribute("position", _adoStream.Position);
		file.nodeTypedValue = _adoStream.Read(_len);
		if (_adoStream.EOS)
		{
			file.setAttribute("isLast", "true");
			_status = "Completed";
		}
		else
		{
			_status = "Sending";
		}

		_ajax.Post(_url, _xmlDom, _ajaxUploader.UploadCallBack);
	}
	
	this.Close = function()
	{
		if (_adoStream == null)
			return;
		
		_status = "";
		_adoStream.Close();
	}
}
var _ajaxUploader = new AjaxUploader();
