﻿function ChangeLang(ob, lang)
{
	if (typeof(ob.OldLang) == "undefined")
	    ob.OldLang = "CHS";
    
	ob.className = ob.className.replace(lang, ob.OldLang);
	ob.OldLang = lang;
	
	if ((ob.tagName == "INPUT" && ob.type == "text") || (ob.tagName == "TEXTAREA" ))
	{
		ob.value = "";
		ob.blur();
		ob.focus();
	}
}

function SetupIme()
{
	var allTag = document.getElementsByTagName("*");
	for(var i=0; i < allTag.length; i++)
	{
		var tag = allTag[i];
		if((tag.tagName == "INPUT" && tag.type == "text") || tag.tagName == "TEXTAREA")
		{
			if (tag.className.indexOf("UYGFont") == -1 && tag.className.indexOf("KZAFont") == -1 && tag.className.indexOf("KGAFont") == -1)
				continue;
		
			if(window.addEventListener)
			{ 
				tag.addEventListener("keydown", OnEdit, false); 
				tag.addEventListener("keypress", OnEdit, false); 
			} 
			else
			{
				tag.attachEvent("onkeydown", OnEdit); 
				tag.attachEvent("onkeypress", OnEdit);
			} 
		}
	}
}

function OnEdit()
{
    var lang = "CHS";
    var e = window.event || arguments[0].event || arguments[0];       
    var ob = e.srcElement || e.target;
    if (ob.tagName == "BODY" || ob.tagName == "HTML")//HtmlEditor
    {
        lang = ob.lang;
    }
	else
	{
	    if (ob.className.indexOf("UYG") != -1)
	        lang = "UYG";
	    else if (ob.className.indexOf("KZA") != -1)
	        lang = "KZA";
	    else if (ob.className.indexOf("KGA") != -1)
	        lang = "KGA";
	}
	
	var browser = "IE";
	if (navigator.userAgent.indexOf("Gecko") != -1)
	{
		if (arguments.callee.caller != null)//判断是否是dispatchEvent调的
			return;

		browser = "FF";
	}
	
	if (e.type == "keydown")
	{
		var code = e.keyCode | e.which;
		if (code == 113)
		{
			if (e.ctrlKey)
			{//CTRL+F2
			    ChangeLang(ob, lang);
			    ob.English = false;
			}
			else
			{//F2
			    ob.English = !ob.English;
			}
		}
		else if (e.ctrlKey && code == 75)//ctrl + k
		{
			ob.English = !ob.English;
			if (browser == "IE")
				e.returnValue = false;
			else
				e.preventDefault();
		}
	}
	else if (lang != "CHS" && !ob.English)
	{
		var code = browser == "IE" ? e.keyCode : e.charCode;
		if (code == 0 || e.ctrlKey)
			return true;

		code = Map(lang, code);
		if (browser == "IE")
		{
			e.keyCode = code;
		}
		else
		{
			var keyEvent = document.createEvent("KeyEvents");
			keyEvent.initKeyEvent("keypress", true, true, document.defaultView, false, false, false, false, 0, code);
			e.preventDefault();
			ob.dispatchEvent(keyEvent);
		}
	}
	return true;
}

function Map(lang, code)
{
	switch(code)
	{
		case 97: //a
			return 0X06BE;//v
		case 65: //A
			return 0;
		case 98: //b
			return 0X0628;//b
		case 66: //B
			return 0;
		case 99: //c
			if (lang == "UYG")
				return 0X063A;//gh
			else if (lang == "KZA" || lang == "KGA")
				return 0X0639;//gh
		case 67: //C
			return 0;
		case 100: //d
			return 0X062F;//d
		case 68: //D
			if (lang == "UYG")
				return 0X0698;//zj
		case 101: //e
			return 0X06D0;//e
		case 69: //E
			return 0;
		case 102: //f
			return 0X0627;//a
		case 70: //F
			if (lang == "UYG" || lang == "KGA")
				return 0X0641;//f
		case 103: //g
			return 0X06D5;//ae
		case 71: //G
			return 0X06AF;//g
		case 104: //h
			return 0X0649;//i
		case 72: //H
			if (lang == "UYG")
				return 0X062E;//h
			else if (lang == "KZA" || lang == "KGA")
				return 0X062D;//h
		case 105: //i
			return 0X06AD;//ng
		case 73: //I
			return 0;
		case 106: //j
			return 0X0642;//kh
		case 74: //J
			return 0X062C;//j
		case 107: //k
			return 0X0643;//k
		case 75: //K
			if (lang == "UYG")
				return 0X06C6;//oe
			else if (lang == "KGA")
				return 0X06C5;//oe
		case 108: //l
			return 0X0644;//l
		case 76: //L
			return 0;
		case 109: //m
			return 0X0645;//m
		case 77: //M
			return 0;
		case 110: //n
			return 0X0646;//n
		case 78: //N
			return 0;
		case 111: //o
			return 0X0648;//o
		case 79: //O
			return 0;
		case 112: //p
			return 0X067E;//p
		case 80: //P
			return 0;
		case 113: //q
			return 0X0686;//q
		case 81: //Q
			return 0;
		case 114: //r
			return 0X0631;//r
		case 82: //R
			return 0;
		case 115: //s
			return 0X0633;//s
		case 83: //S
			return 0;
		case 116: //t
			return 0X062A;//t
		case 84: //T
			return 0;
		case 117: //u
			return 0X06C7;//u
		case 85: //U
			return 0;
		case 118: //v
			if (lang == "UYG")
				return 0X06C8;//ue
			else if (lang == "KZA")
				return 0X06C6;//ue
			else if (lang == "KGA")
				return 0X06C9;//ue
		case 86: //V
			return 0;
		case 119: //w
			return 0X06CB;//w
		case 87: //W
			return 0;
		case 120: //x
			return 0X0634;//x
		case 88: //X
			return 0;
		case 121: //y
			return 0X064A;//y
		case 89: //Y
			return 0;
		case 122: //z
			return 0X0632;//z
		case 90: //Z
			return 0;
		case 44: //,
			return 0X060C;//逗号
		case 62: //>
			return 0X003C;
		case 41: //)
			return 0X0028;
		case 60: //>
			return 0X003E;
		case 40: //(
			return 0X0029;
		case 47: ///
			if (lang == "UYG")
				return 0X0626;//Hamza
			else if (lang == "KZA" || lang == "KGA")
				return 0X0621;//Hamza
		case 63: //?
			return 0X061F;//问号
		case 59: //;
			return 0X061B;//分号
		case 39: // '
			return 0X002C;
		case 34: //"
			return 0X0022;
		case 91: //[
			return 0X005D;
		case 123: //{
			return 0X007D;
		case 93: //]
			return 0X005B;
		case 125: //}
			return 0X007B;
	}
	
	return code;
}
