﻿using System;
using System.Data;
using System.Xml;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Web;
using IlgharCMS;
public partial class CIndex : IlgharCMS.Page
{
public CIndex()
: base("index.dwt.aspx")
{}
protected XmlDocument _xmlTemplate;
protected override void OnInit(EventArgs e)
{
base.OnInit(e);
_xmlTemplate = XmlData.GetXmlDocument();
if (!String.IsNullOrEmpty(Request.QueryString["GetPageCount"]))
                            {
                                Response.Write(1);
                                Response.End();
                            }
                        
Response.AddCacheItemDependency("ClearAllCache");
}

                                protected DataRow ShopChannel
                                {
                                    get
                                    {
                                        if (_ShopChannel == null)
                                            _ShopChannel = Manager.GetExtraInstance(Channel, "Shop");

                                        return _ShopChannel;
                                    }
                                }
                                private DataRow _ShopChannel;

                            
                                protected DataRow ArticleChannel
                                {
                                    get
                                    {
                                        if (_ArticleChannel == null)
                                            _ArticleChannel = Manager.GetExtraInstance(Channel, "Article");

                                        return _ArticleChannel;
                                    }
                                }
                                private DataRow _ArticleChannel;

                            protected string MetaKeywords
                                            {
                                                get
                                                {
                                                    StringBuilder result = new StringBuilder();
                                                    result.Append(Channel[IlgharCMS.SystemModule.Alias.Channel.Name + PageLang]);
                                    if (!String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.MetaKeywords].ToString()))
                                        result.Append(" - " + Channel[IlgharCMS.SystemModule.Alias.Channel.MetaKeywords]);

                                    if (!String.IsNullOrEmpty(Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.MetaKeywords + PageLang].ToString()))
                                        result.Append(" - " + Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.MetaKeywords + PageLang]);
                                    
                                                    return result.ToString();
                                                }
                                            }
                            protected string MetaDescription
                                            {
                                                get
                                                {
                                                    StringBuilder result = new StringBuilder();
                                                    result.Append(Channel[IlgharCMS.SystemModule.Alias.Channel.Name + PageLang]);
                                    if (!String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.MetaDescription].ToString()))
                                        result.Append(" - " + Channel[IlgharCMS.SystemModule.Alias.Channel.MetaDescription]);

                                    if (!String.IsNullOrEmpty(Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.MetaDescription + PageLang].ToString()))
                                        result.Append(" - " + Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.MetaDescription + PageLang]);
                                    
                                                    return result.ToString();
                                                }
                                            }
                            protected string Notice
                                            {
                                                get
                                                {
                                                    if (String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.Notice].ToString()))
                                                        return Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Notice + PageLang].ToString();
                                                    else
                                                        return Channel[IlgharCMS.SystemModule.Alias.Channel.Notice].ToString();
                                                }
                                            }
                            protected string Footer
                                            {
                                                get
                                                {
                                                    if (String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.Footer].ToString()))
                                                        return Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Footer + PageLang].ToString();
                                                    else
                                                        return Channel[IlgharCMS.SystemModule.Alias.Channel.Footer].ToString();
                                                }
                                            }
                            protected string ICP
                                            {
                                                get
                                                {
                                                    if (String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.ICP].ToString()))
                                                        return Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.ICP + PageLang].ToString();
                                                    else
                                                        return Channel[IlgharCMS.SystemModule.Alias.Channel.ICP].ToString();
                                                }
                                            }
                            protected string StatisticsCode
                                            {
                                                get
                                                {
                                                    if (String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.StatisticsCode].ToString()))
                                                        return Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.StatisticsCode + PageLang].ToString();
                                                    else
                                                        return Channel[IlgharCMS.SystemModule.Alias.Channel.StatisticsCode].ToString();
                                                }
                                            }
                            
                            protected string t900Default
                            {
                                get
                                {
                                    StringBuilder result = new StringBuilder(_xmlTemplate.SelectSingleNode("//t900").InnerText);
                                    object t1002 = ImagePath;
result.Replace("{#t1002#}",t1002 == null ? "" : t1002.ToString());

                                    return result.ToString();
                                }
                            }
                            protected string t900
                            {
                                get
                                {
                                    int instanceID;
                                    DataRow[] rows = Manager.Instances.Select(IlgharCMS.SystemModule.Alias.Module.Namespace + "='IlgharCMS.AdModule'");if (rows.Length == 0)
{instanceID = 0;}
else
{instanceID = (int)rows[0][IlgharCMS.SystemModule.Alias.Instance.InnerID];}
                                    if (instanceID == 0)
                                        return t900Default;

                                    string path = String.Empty;
                                    int id = -1;
                                    
                            using (IlgharCMS.AdModule.IPosition bll = (IlgharCMS.AdModule.IPosition)Manager.CreateObject("Position", instanceID, PageLang, false))
                            {
                                id = bll.GetInnerIDFromGuid(new Guid("{099A2FEC-2278-4b03-BC08-A3C1FC3ADC66}"));
                                path = Manager.GetCachePath() + "ad/" + instanceID + "_" + PageLang + "_" + id + ".js";
                                if (id > 0 && !System.IO.File.Exists(Manager.MapPath(path)))
                                {
                                    path = bll.GenerateCacheFile(id);
                                    if (String.IsNullOrEmpty(path))
                                        id = -1;
                                }
                            }
                            

                                    if (id <= 0)
                                        return t900Default;
                                    else
                                        return "<script type=\"text/javascript\" src=\"" + path + "\"></script>";
                                }
                            }
                            
                            private string t1363BuildUrl(DataRow record)
                            {
                                string url = record[IlgharCMS.SystemModule.Alias.Menu.Path].ToString();
                                if (url.StartsWith("http://") || url.StartsWith("/"))
                                {
                                    if (url.StartsWith("/") && (Convert.ToBoolean(Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Fake404]) || Request.RawUrl.IndexOf("/ilghar.aspx?/") != -1))
                                        return Manager.GetWebPath() + "ilghar.aspx?" + url;
                                    else
                                        return url;
                                }

                                DataRow[] rows = Manager.Channels.Select(IlgharCMS.SystemModule.Alias.Channel.ID + "='" + record[IlgharCMS.SystemModule.Alias.Menu.ChannelID] + "'");
                                if (rows.Length == 0)
                                    return url;

                                DataRow channel = rows[0];
                                if (!Convert.IsDBNull(Channel[IlgharCMS.SystemModule.Alias.Channel.TranslateLang]))
                                {
                                    string instance = null;
                                    if (Convert.IsDBNull(channel[IlgharCMS.SystemModule.Alias.Instance.ID]))
                                        instance = IlgharCMS.SystemModule.Alias.Instance.ID + " IS NULL AND ";
                                    else
                                        instance = IlgharCMS.SystemModule.Alias.Instance.ID + "='" + channel[IlgharCMS.SystemModule.Alias.Instance.ID] + "' AND ";
                                    rows = Manager.Channels.Select(IlgharCMS.SystemModule.Alias.Channel.ID + " IS NOT NULL AND " + instance + IlgharCMS.SystemModule.Alias.Channel.TemplateLang + "='" + Channel[IlgharCMS.SystemModule.Alias.Channel.TemplateLang] + "' AND " + IlgharCMS.SystemModule.Alias.Channel.TranslateLang + "='" + Channel[IlgharCMS.SystemModule.Alias.Channel.TranslateLang] + "'");
                                    if (rows.Length > 0)
                                        channel = rows[0];
                                }

                                string content = record[IlgharCMS.SystemModule.Alias.Menu.Content].ToString();
                                if (!String.IsNullOrEmpty(content))
                                {
                                    if (!Convert.IsDBNull(record[IlgharCMS.SystemModule.Alias.Menu.PageTemplate]))
                                    {
                                        if (record[IlgharCMS.SystemModule.Alias.Menu.PageExtension].ToString() == String.Empty)
                                            url = BuildUrl(channel, record[IlgharCMS.SystemModule.Alias.Menu.PageTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + channel[IlgharCMS.SystemModule.Alias.Channel.Extension]);
                                        else
                                            url = BuildUrl(channel, record[IlgharCMS.SystemModule.Alias.Menu.PageTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + record[IlgharCMS.SystemModule.Alias.Menu.PageExtension]);
                                    }
                                    else
                                    {
                                        rows = Manager.Pages.Select(IlgharCMS.SystemModule.Alias.Template.Page.TemplatePath + "='" + channel[IlgharCMS.SystemModule.Alias.Channel.TemplatePath] + "' AND " + IlgharCMS.SystemModule.Alias.Template.Page.Mark + "='System' AND " + IlgharCMS.SystemModule.Alias.Template.Page.Object + "='Menu'");
                                        if (rows.Length == 0)
                                        {
                                            url = String.Empty;
                                        }
                                        else
                                        {
                                            if (record[IlgharCMS.SystemModule.Alias.Menu.PageExtension].ToString() == String.Empty)
                                                url = BuildUrl(channel, rows[0][IlgharCMS.SystemModule.Alias.Template.Page.PathInTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + channel[IlgharCMS.SystemModule.Alias.Channel.Extension]);
                                            else
                                                url = BuildUrl(channel, rows[0][IlgharCMS.SystemModule.Alias.Template.Page.PathInTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + record[IlgharCMS.SystemModule.Alias.Menu.PageExtension]);
                                        }
                                    }
                                }
                                else
                                {
                                    string channelPath = String.Empty;
                                    if (!String.IsNullOrEmpty(channel[IlgharCMS.SystemModule.Alias.Channel.Domain].ToString()))
                                    {
                                        Uri domain = new Uri(channel[IlgharCMS.SystemModule.Alias.Channel.Domain].ToString().Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries)[0]);
                                        if (channel == Channel)
                                            channelPath = domain.LocalPath;
                                        else
                                            channelPath = domain.ToString();
                                    }
                                    else if (!String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.Domain].ToString()))
                                    {
                                       channelPath = Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Domain].ToString() + channel[IlgharCMS.SystemModule.Alias.Channel.Path].ToString().TrimStart('/');
                                    }
                                    else
                                    {
                                        channelPath = channel[IlgharCMS.SystemModule.Alias.Channel.Path].ToString();
                                        
                                    }
                                    if (!String.IsNullOrEmpty(url))
                                    {
                                        url = channelPath + url;
                                        url = url.Replace(".ext", channel[IlgharCMS.SystemModule.Alias.Channel.Extension].ToString());
                                    }
                                    else
                                    {
                                        url = channelPath + channel[IlgharCMS.SystemModule.Alias.Channel.DefaultDocument].ToString() + channel[IlgharCMS.SystemModule.Alias.Channel.Extension];
                                    }

                                    if (Convert.ToBoolean(Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Fake404]) || Request.RawUrl.IndexOf("/ilghar.aspx?/") != -1)
                                        url = Manager.GetWebPath() + "ilghar.aspx?" + url;
                                }

                                return url;
                            }

                            private int t1363IDCounter = 0;
                            private object t1363IDRecord = null;
                            private DataTable t1363ID;
                            private DataTable t1363ID_
                            {
                                get
                                {
                                    string condition = null;
condition += "P2131_24_403=";
condition += "true";
condition += " and P2131_24_264 IS ";
condition += "NULL";
condition += " and P2131_24_263 IS ";
condition += "NULL";


                                    string sort = null;

                                    using (IlgharCMS.SystemModule.IMenu bll = (IlgharCMS.SystemModule.IMenu)Manager.CreateObject("Menu", SystemInstanceID, PageLang, false))
                                    {
                                        t1363ID = bll.List(-1, -1, condition, sort);
                                    }

                                    return t1363ID;
                                }
                            }
                            protected string t1363
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t1363");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    
                                        replacementPair["{#URL#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {
                                                                            return t1363BuildUrl(record);
                                                                        }
                                                                        );
                                                replacementPair["{#Target#}"] = IlgharCMS.SystemModule.Alias.Menu.Target;replacementPair["{#Name#}"] = IlgharCMS.SystemModule.Alias.Menu.Name;
                                    StringBuilder all = Manager.Build(node, t1363ID_, replacementPair, ref t1363IDRecord, ref t1363IDCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          
                        protected int t1993IDRecordCount
                        {
                            get
                            {
                                int instanceID;
instanceID = (int)ShopChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];
                                using (IlgharCMS.ShopModule.IGoods bll = (IlgharCMS.ShopModule.IGoods)Manager.CreateObject("Goods", instanceID, PageLang, false))
                                {
                                    string condition = null;
condition += "P1896_2_64=";
condition += "false";
condition += " and P1896_2_63=";
condition += "true";


                                    return bll.GetRecordCount(condition);
                                }
                            }
                        }
                        
                            protected int t1993IDCounter = 0;
                            protected object t1993IDRecord = null;
                            private DataTable t1993IDData;
                            protected DataTable t1993ID
                            {
                                get
                                {
                                    if (t1993IDData != null)
                                        return t1993IDData;

                                    t1993IDData = t1993ID_;
                                    return t1993IDData;
                                }
                            }
                        
                                private DataTable t1993ID_
                                {
                                    get
                                    {
                                        string condition = null;
condition += "P1896_2_64=";
condition += "false";
condition += " and P1896_2_63=";
condition += "true";


                                        string sort = null;sort = "P1896_2_57 DESC";

                                        int instanceID;
instanceID = (int)ShopChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];

                                        using (IlgharCMS.ShopModule.IGoods bll = (IlgharCMS.ShopModule.IGoods)Manager.CreateObject("Goods", instanceID, PageLang, false))
                                        {
                                            t1993IDData = bll.List(1, 10, condition, sort);
                                        }

                                        return t1993IDData;
                                    }
                                }
                            
                            protected string t1993
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t1993");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    
                                        replacementPair[@"{#BuildUrl()#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {
                                                                            object t2209 = BuildUrl(ShopChannel,"goods","ID=" + t1993ID.Rows[t1993IDCounter]["P1896_2_415"] + "&Ext=" + t1993ID.Rows[t1993IDCounter]["P1896_2_416"] + "&PageTemplate=" + t1993ID.Rows[t1993IDCounter]["P1896_2_414"]);
                                                                            if (t2209 != null)
                                                                                return t2209.ToString();
                                                                            else
                                                                                return String.Empty;
                                                                        }
                                                                        );
                                                replacementPair["{#Name#}"] = IlgharCMS.ShopModule.Alias.Goods.Name;replacementPair["{#Thumbnail#}"] = IlgharCMS.ShopModule.Alias.Goods.Thumbnail;
                                    StringBuilder all = Manager.Build(node, t1993ID_, replacementPair, ref t1993IDRecord, ref t1993IDCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          
                        protected int t2541IDRecordCount
                        {
                            get
                            {
                                int instanceID;
instanceID = (int)SystemChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];
                                using (IlgharCMS.SystemModule.ILink bll = (IlgharCMS.SystemModule.ILink)Manager.CreateObject("Link", instanceID, PageLang, false))
                                {
                                    string condition = null;
condition += "P2131_46_402=";
condition += "true";


                                    return bll.GetRecordCount(condition);
                                }
                            }
                        }
                        
                            protected int t2541IDCounter = 0;
                            protected object t2541IDRecord = null;
                            private DataTable t2541IDData;
                            protected DataTable t2541ID
                            {
                                get
                                {
                                    if (t2541IDData != null)
                                        return t2541IDData;

                                    t2541IDData = t2541ID_;
                                    return t2541IDData;
                                }
                            }
                        
                                private DataTable t2541ID_
                                {
                                    get
                                    {
                                        string condition = null;
condition += "P2131_46_402=";
condition += "true";


                                        string sort = null;

                                        int instanceID;
instanceID = (int)SystemChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];

                                        using (IlgharCMS.SystemModule.ILink bll = (IlgharCMS.SystemModule.ILink)Manager.CreateObject("Link", instanceID, PageLang, false))
                                        {
                                            t2541IDData = bll.List(-1, -1, condition, sort);
                                        }

                                        return t2541IDData;
                                    }
                                }
                            
                            protected string t2541
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t2541");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    replacementPair["{#URL#}"] = IlgharCMS.SystemModule.Alias.Link.URL;replacementPair["{#Name#}"] = IlgharCMS.SystemModule.Alias.Link.Name;replacementPair["{#Logo#}"] = IlgharCMS.SystemModule.Alias.Link.Logo;
                                    StringBuilder all = Manager.Build(node, t2541ID_, replacementPair, ref t2541IDRecord, ref t2541IDCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          
                            protected string t2971Default
                            {
                                get
                                {
                                    StringBuilder result = new StringBuilder(_xmlTemplate.SelectSingleNode("//t2971").InnerText);
                                    object t3075 = ImagePath;
result.Replace("{#t3075#}",t3075 == null ? "" : t3075.ToString());

                                    return result.ToString();
                                }
                            }
                            protected string t2971
                            {
                                get
                                {
                                    int instanceID;
                                    DataRow[] rows = Manager.Instances.Select(IlgharCMS.SystemModule.Alias.Module.Namespace + "='IlgharCMS.AdModule'");if (rows.Length == 0)
{instanceID = 0;}
else
{instanceID = (int)rows[0][IlgharCMS.SystemModule.Alias.Instance.InnerID];}
                                    if (instanceID == 0)
                                        return t2971Default;

                                    string path = String.Empty;
                                    int id = -1;
                                    
                            using (IlgharCMS.AdModule.IPosition bll = (IlgharCMS.AdModule.IPosition)Manager.CreateObject("Position", instanceID, PageLang, false))
                            {
                                id = bll.GetInnerIDFromGuid(new Guid("{1084F28E-DC7E-4008-8228-25CC9FA93EA5}"));
                                path = Manager.GetCachePath() + "ad/" + instanceID + "_" + PageLang + "_" + id + ".js";
                                if (id > 0 && !System.IO.File.Exists(Manager.MapPath(path)))
                                {
                                    path = bll.GenerateCacheFile(id);
                                    if (String.IsNullOrEmpty(path))
                                        id = -1;
                                }
                            }
                            

                                    if (id <= 0)
                                        return t2971Default;
                                    else
                                        return "<script type=\"text/javascript\" src=\"" + path + "\"></script>";
                                }
                            }
                            
                        protected int t3470IDRecordCount
                        {
                            get
                            {
                                int instanceID;
instanceID = (int)ArticleChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];
                                using (IlgharCMS.ArticleModule.IArticle bll = (IlgharCMS.ArticleModule.IArticle)Manager.CreateObject("Article", instanceID, PageLang, false))
                                {
                                    string condition = null;
condition += "P2194_2_42=";
condition += "false";
condition += " and P2194_2_41=";
condition += "true";


                                    return bll.GetRecordCount(condition);
                                }
                            }
                        }
                        
                            protected int t3470IDCounter = 0;
                            protected object t3470IDRecord = null;
                            private DataTable t3470IDData;
                            protected DataTable t3470ID
                            {
                                get
                                {
                                    if (t3470IDData != null)
                                        return t3470IDData;

                                    t3470IDData = t3470ID_;
                                    return t3470IDData;
                                }
                            }
                        
                                private DataTable t3470ID_
                                {
                                    get
                                    {
                                        string condition = null;
condition += "P2194_2_42=";
condition += "false";
condition += " and P2194_2_41=";
condition += "true";


                                        string sort = null;sort = "P2194_2_35 DESC";

                                        int instanceID;
instanceID = (int)ArticleChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];

                                        using (IlgharCMS.ArticleModule.IArticle bll = (IlgharCMS.ArticleModule.IArticle)Manager.CreateObject("Article", instanceID, PageLang, false))
                                        {
                                            t3470IDData = bll.List(1, 5, condition, sort);
                                        }

                                        return t3470IDData;
                                    }
                                }
                            
                            protected string t3470
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t3470");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    
                                        replacementPair[@"{#BuildUrl()#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {
                                                                            object t3731 = BuildUrl(ArticleChannel,"article","ID=" + t3470ID.Rows[t3470IDCounter]["P2194_2_89"] + "&Ext=" + t3470ID.Rows[t3470IDCounter]["P2194_2_90"] + "&PageTemplate=" + t3470ID.Rows[t3470IDCounter]["P2194_2_88"] + "&PageUrl=" + HttpUtility.UrlEncode(t3470ID.Rows[t3470IDCounter]["P2194_2_91"].ToString()));
                                                                            if (t3731 != null)
                                                                                return t3731.ToString();
                                                                            else
                                                                                return String.Empty;
                                                                        }
                                                                        );
                                                replacementPair["{#Title#}"] = IlgharCMS.ArticleModule.Alias.Article.Title;replacementPair["{#UpdateTime#}"] = IlgharCMS.ArticleModule.Alias.Article.UpdateTime;
                                    StringBuilder all = Manager.Build(node, t3470ID_, replacementPair, ref t3470IDRecord, ref t3470IDCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          
                        protected int t3979IDRecordCount
                        {
                            get
                            {
                                int instanceID;
instanceID = (int)ShopChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];
                                using (IlgharCMS.ShopModule.IGoods bll = (IlgharCMS.ShopModule.IGoods)Manager.CreateObject("Goods", instanceID, PageLang, false))
                                {
                                    string condition = null;
condition += "P1896_2_64=";
condition += "false";
condition += " and P1896_2_63=";
condition += "true";
condition += " and P1896_2_66=";
condition += "true";


                                    return bll.GetRecordCount(condition);
                                }
                            }
                        }
                        
                            protected int t3979IDCounter = 0;
                            protected object t3979IDRecord = null;
                            private DataTable t3979IDData;
                            protected DataTable t3979ID
                            {
                                get
                                {
                                    if (t3979IDData != null)
                                        return t3979IDData;

                                    t3979IDData = t3979ID_;
                                    return t3979IDData;
                                }
                            }
                        
                                private DataTable t3979ID_
                                {
                                    get
                                    {
                                        string condition = null;
condition += "P1896_2_64=";
condition += "false";
condition += " and P1896_2_63=";
condition += "true";
condition += " and P1896_2_66=";
condition += "true";


                                        string sort = null;sort = "P1896_2_57 DESC";

                                        int instanceID;
instanceID = (int)ShopChannel[IlgharCMS.SystemModule.Alias.Instance.InnerID];

                                        using (IlgharCMS.ShopModule.IGoods bll = (IlgharCMS.ShopModule.IGoods)Manager.CreateObject("Goods", instanceID, PageLang, false))
                                        {
                                            t3979IDData = bll.List(1, 6, condition, sort);
                                        }

                                        return t3979IDData;
                                    }
                                }
                            
                            protected string t3979
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t3979");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    
                                        replacementPair[@"{#BuildUrl()#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {
                                                                            object t4268 = BuildUrl(ShopChannel,"goods","ID=" + t3979ID.Rows[t3979IDCounter]["P1896_2_415"] + "&Ext=" + t3979ID.Rows[t3979IDCounter]["P1896_2_416"] + "&PageTemplate=" + t3979ID.Rows[t3979IDCounter]["P1896_2_414"]);
                                                                            if (t4268 != null)
                                                                                return t4268.ToString();
                                                                            else
                                                                                return String.Empty;
                                                                        }
                                                                        );
                                                replacementPair["{#Name#}"] = IlgharCMS.ShopModule.Alias.Goods.Name;replacementPair["{#Thumbnail#}"] = IlgharCMS.ShopModule.Alias.Goods.Thumbnail;
                                    StringBuilder all = Manager.Build(node, t3979ID_, replacementPair, ref t3979IDRecord, ref t3979IDCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          
                            private string t4649BuildUrl(DataRow record)
                            {
                                string url = record[IlgharCMS.SystemModule.Alias.Menu.Path].ToString();
                                if (url.StartsWith("http://") || url.StartsWith("/"))
                                {
                                    if (url.StartsWith("/") && (Convert.ToBoolean(Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Fake404]) || Request.RawUrl.IndexOf("/ilghar.aspx?/") != -1))
                                        return Manager.GetWebPath() + "ilghar.aspx?" + url;
                                    else
                                        return url;
                                }

                                DataRow[] rows = Manager.Channels.Select(IlgharCMS.SystemModule.Alias.Channel.ID + "='" + record[IlgharCMS.SystemModule.Alias.Menu.ChannelID] + "'");
                                if (rows.Length == 0)
                                    return url;

                                DataRow channel = rows[0];
                                if (!Convert.IsDBNull(Channel[IlgharCMS.SystemModule.Alias.Channel.TranslateLang]))
                                {
                                    string instance = null;
                                    if (Convert.IsDBNull(channel[IlgharCMS.SystemModule.Alias.Instance.ID]))
                                        instance = IlgharCMS.SystemModule.Alias.Instance.ID + " IS NULL AND ";
                                    else
                                        instance = IlgharCMS.SystemModule.Alias.Instance.ID + "='" + channel[IlgharCMS.SystemModule.Alias.Instance.ID] + "' AND ";
                                    rows = Manager.Channels.Select(IlgharCMS.SystemModule.Alias.Channel.ID + " IS NOT NULL AND " + instance + IlgharCMS.SystemModule.Alias.Channel.TemplateLang + "='" + Channel[IlgharCMS.SystemModule.Alias.Channel.TemplateLang] + "' AND " + IlgharCMS.SystemModule.Alias.Channel.TranslateLang + "='" + Channel[IlgharCMS.SystemModule.Alias.Channel.TranslateLang] + "'");
                                    if (rows.Length > 0)
                                        channel = rows[0];
                                }

                                string content = record[IlgharCMS.SystemModule.Alias.Menu.Content].ToString();
                                if (!String.IsNullOrEmpty(content))
                                {
                                    if (!Convert.IsDBNull(record[IlgharCMS.SystemModule.Alias.Menu.PageTemplate]))
                                    {
                                        if (record[IlgharCMS.SystemModule.Alias.Menu.PageExtension].ToString() == String.Empty)
                                            url = BuildUrl(channel, record[IlgharCMS.SystemModule.Alias.Menu.PageTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + channel[IlgharCMS.SystemModule.Alias.Channel.Extension]);
                                        else
                                            url = BuildUrl(channel, record[IlgharCMS.SystemModule.Alias.Menu.PageTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + record[IlgharCMS.SystemModule.Alias.Menu.PageExtension]);
                                    }
                                    else
                                    {
                                        rows = Manager.Pages.Select(IlgharCMS.SystemModule.Alias.Template.Page.TemplatePath + "='" + channel[IlgharCMS.SystemModule.Alias.Channel.TemplatePath] + "' AND " + IlgharCMS.SystemModule.Alias.Template.Page.Mark + "='System' AND " + IlgharCMS.SystemModule.Alias.Template.Page.Object + "='Menu'");
                                        if (rows.Length == 0)
                                        {
                                            url = String.Empty;
                                        }
                                        else
                                        {
                                            if (record[IlgharCMS.SystemModule.Alias.Menu.PageExtension].ToString() == String.Empty)
                                                url = BuildUrl(channel, rows[0][IlgharCMS.SystemModule.Alias.Template.Page.PathInTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + channel[IlgharCMS.SystemModule.Alias.Channel.Extension]);
                                            else
                                                url = BuildUrl(channel, rows[0][IlgharCMS.SystemModule.Alias.Template.Page.PathInTemplate].ToString(), "ID=" + record[IlgharCMS.SystemModule.Alias.Menu.PageID] + "&Ext=" + record[IlgharCMS.SystemModule.Alias.Menu.PageExtension]);
                                        }
                                    }
                                }
                                else
                                {
                                    string channelPath = String.Empty;
                                    if (!String.IsNullOrEmpty(channel[IlgharCMS.SystemModule.Alias.Channel.Domain].ToString()))
                                    {
                                        Uri domain = new Uri(channel[IlgharCMS.SystemModule.Alias.Channel.Domain].ToString().Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries)[0]);
                                        if (channel == Channel)
                                            channelPath = domain.LocalPath;
                                        else
                                            channelPath = domain.ToString();
                                    }
                                    else if (!String.IsNullOrEmpty(Channel[IlgharCMS.SystemModule.Alias.Channel.Domain].ToString()))
                                    {
                                       channelPath = Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Domain].ToString() + channel[IlgharCMS.SystemModule.Alias.Channel.Path].ToString().TrimStart('/');
                                    }
                                    else
                                    {
                                        channelPath = channel[IlgharCMS.SystemModule.Alias.Channel.Path].ToString();
                                        
                                    }
                                    if (!String.IsNullOrEmpty(url))
                                    {
                                        url = channelPath + url;
                                        url = url.Replace(".ext", channel[IlgharCMS.SystemModule.Alias.Channel.Extension].ToString());
                                    }
                                    else
                                    {
                                        url = channelPath + channel[IlgharCMS.SystemModule.Alias.Channel.DefaultDocument].ToString() + channel[IlgharCMS.SystemModule.Alias.Channel.Extension];
                                    }

                                    if (Convert.ToBoolean(Manager.Site[IlgharCMS.SystemModule.Alias.InstanceConfig.Fake404]) || Request.RawUrl.IndexOf("/ilghar.aspx?/") != -1)
                                        url = Manager.GetWebPath() + "ilghar.aspx?" + url;
                                }

                                return url;
                            }

                            private int t4649IDCounter = 0;
                            private object t4649IDRecord = null;
                            private DataTable t4649ID;
                            private DataTable t4649ID_
                            {
                                get
                                {
                                    string condition = null;
condition += "P2131_24_264=";
condition += "{BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}";


                                    string sort = null;

                                    using (IlgharCMS.SystemModule.IMenu bll = (IlgharCMS.SystemModule.IMenu)Manager.CreateObject("Menu", SystemInstanceID, PageLang, false))
                                    {
                                        t4649ID = bll.List(-1, -1, condition, sort);
                                    }

                                    return t4649ID;
                                }
                            }
                            protected string t4649
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t4649");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    
                                        replacementPair["{#URL#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {
                                                                            return t4649BuildUrl(record);
                                                                        }
                                                                        );
                                                replacementPair["{#Target#}"] = IlgharCMS.SystemModule.Alias.Menu.Target;replacementPair["{#Name#}"] = IlgharCMS.SystemModule.Alias.Menu.Name;
                                    StringBuilder all = Manager.Build(node, t4649ID_, replacementPair, ref t4649IDRecord, ref t4649IDCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          }
