<?php
class baseModel extends Model{

   	 function getSet(){
			global $styleList,$pictureSize,$thumbSize;
			$varList = array("selectStyle"		=> $styleList,
					 "appStyle"		=> APP_STYLE,
					 "articlePageSize"	=> ARTICLE_PAGE_SIZE,
					 "productPageSize"	=> PRODUCT_PAGE_SIZE,
					 "appDescription"	=> APP_DESCRIPTION,
					 "appKeywords"		=> APP_KEYWORDS,
					 "waterpath"		=> ATTCHMENT_PATH."product/",
					 "water"		=> WATER,
					 "position"		=> POSITION,
					 "seoType"		=> SEO_TYPE,
					 "htmlDir"		=> HTML_DIR,
					 "width"		=> $thumbSize["width"],
					 "height"		=> $thumbSize["height"],
					 "maxWidth"		=> $pictureSize["maxWidth"],
					 "maxHeight"	=> $pictureSize["maxHeight"]
				 );
			return $varList;
		}



		function validateForm($post) {
			$result=true;
			//ȫֱ
			if(!Validate::isNumber($post['articlePageSize'])){
				$this->messList[] = "ÿҳʾĿ.";
				$result=false;
			}
			if(!Validate::isNumber($post['productPageSize'])){
				$this->messList[] = "ƷÿҳʾĿ.";
				$result=false;
			}
			if($post['articlePageSize'] <= 0) {
				$this->messList[] = "ÿҳʾĿ.";
				$result=false;
			}
			if($post['productPageSize'] <= 0){
				$this->messList[] = "ƷÿҳʾĿ.";
				$result=false;
			}

			if(!Validate::isNumber($post['width']) || !Validate::isNumber($post['height'])) {
				$this->messList[] =  "ͼߴ粻.";
				$result=false;
			}
			if(!Validate::isNumber($post['maxWidth']) || !Validate::isNumber($post['maxHeight']))	{
				$errorList[] =  "ͼƬϴߴ粻.";
				$result=false;
			}
			if($post['width'] <= 0 || $post['height'] <= 0){
				$this->messList[] =  "ͼͼߴ.";
				$result=false;
			}
			if($post['maxWidth'] <= 0 || $post['maxHeight'] <= 0) {
				$this->messList[] = "ͼƬϴߴ.";
				$result=false;
			}
			return  $result;
		}


		private function upload(){
			$up=new upload(array('filepath'=>ATTCHMENT_REAL_PATH."product"));
			if($up->uploadFile('water')){
				return $up->getNewFileName();
			}else{
				$this->messList[]=$up->getErrorMsg();
				return false;
			}
		}


		function writeConfig($fileName,$post){
			$confile=CMS_ROOT.$fileName;
			if(file_exists($confile)){
				$configText = file_get_contents($confile);
			}else{
				$this->messList[]="ļ.";
				return false;
			}

			if(!empty($post)){
				$configArray['APP_STYLE'] = $post['appStyle'];
				$configArray['ARTICLE_PAGE_SIZE'] = $post['articlePageSize'];
				$configArray['PRODUCT_PAGE_SIZE'] = $post['productPageSize'];
				$configArray['APP_DESCRIPTION'] = $post['appDescription'];
				$configArray['APP_KEYWORDS'] = $post['appKeywords'];
				$configArray['POSITION']=$post["position"];
				$configArray['SEO_TYPE']=$post["seoType"];
				$configArray['HTML_DIR']=$post["htmlDir"];
				if(isset($_FILES["water"])){
					if($newwater=$this->upload()){
						$configArray["WATER"]=$newwater;
						@unlink(ATTCHMENT_REAL_PATH."product/".$post['unlink']);

					}else{
						return false;
					}
				}
				$configArray["pictureSize"] = "array('maxWidth' => {$post['maxWidth']}, 'maxHeight' => {$post['maxHeight']});";
				$configArray["thumbSize"] = "array('width' => {$post['width']}, 'height' => {$post['height']});";

			}else{
				$this->messList[]="ݴΪ.";
				return false;
			}


			//ѭ޸
			foreach($configArray as $key => $val) {
				$regV = "/$key\s*=\s*.+;/";		//ò
				$regC = "/define\(\"$key\".+;/";	//ò

				if(preg_match($regV, $configText)) {
					$configText = preg_replace($regV, $key." = ".$val, $configText);
				}else{
					if(!Validate::isNumber($val)) {	//ַ
						$val = "\"$val\"";
					}
					$configText = preg_replace($regC, "define(\"$key\", $val);", $configText);
				}
			}

			if($fp = fopen($confile, "w")) {
				fwrite($fp, $configText);
				fclose($fp);
				return true;
			}else{
				$this->messList[]="޸ʧ,.";
				return false;
			}
		}
}
?>