<?php

	class Install {
		private $process;
		private $installFrom;
		private $messageList;


		function __construct(){
			$this->process=new Process("../config.inc.php", "elincms.sql");
			$this->installFrom=new InstallFrom();
			$this->messageList="";
		}


		function exeStep($step){
			switch($step) {
				case 1:
					echo $this->installFrom->getAgreement();
					break;
				case 2:
					$this->messageList='请在下面的表单中正确填写数据库连接的配置信息';
					$inputs=array("DB_HOST"=>DB_HOST,
						"DB_USER"=>DB_USER,
						"DB_PWD"=>DB_PWD,
						"DB_NAME"=>DB_NAME,
						"TAB_PREFIX"=>TAB_PREFIX,
						"APP_NAME"=>APP_NAME
						);
					echo $this->installFrom->getDbFrom($this->messageList, $inputs);
					break;
				case 3:
					if(!$this->validateDbFrom($_POST)){
						echo $this->installFrom->getDbFrom($this->messageList, $_POST, "error");
					}else{
						if($this->process->configSYS($_POST)){
							$this->messageList='请在下面的表单中正确填写管理员账号信息';
							$inputs=array("ADMIN_USER"=>"admin",
								"ADMIN_pwd"=>"",
								"ADMIN_REPWD"=>""
							);
							echo $this->installFrom->getAdminFrom($this->messageList, $inputs);
						}else{
							echo "写入配置文件失败!!";
						}
					}
					break;
				case 4:
					if(!$this->validateAdminFrom($_POST)){
						echo $this->installFrom->getAdminFrom($this->messageList, $_POST, "error");
					}else{
						if($this->process->createDb($_POST)){
							$installStats=true;
						}else{
							$installStats=false;
						}
						echo $this->installFrom->getInstallMessage($this->process->getInstallInfo(), $installStats);
					}
					break;
				case 5:
					if(file_put_contents ("../install_lock.txt", "CMS INATALL OK ...")){
						echo '<script>window.location="'.APP_PATH.'"</script>';
					}
					break;

			}

		}

		function validateDbFrom($post){
			$result=true;
			if(trim(($post['DB_HOST'])=="")){
				$this->messageList.="数据库主机名不能为空!!<br>";
				$result=false;
			}
			if(trim(($post['DB_USER'])=="")){
				$this->messageList.="数据库用户名不能为空!!<br>";
				$result=false;
			}

			if(trim(($post['DB_NAME'])=="")){
				$this->messageList.="数据库名称不能为空!!<br>";
				$result=false;
			}
			if(trim(($post['TAB_PREFIX'])=="")){
				$this->messageList.="表名的前缀不能为空!!<br>";
				$result=false;
			}
			if(trim(($post['APP_NAME'])=="")){
				$this->messageList.="网站名称不能为空!!<br>";
				$result=false;
			}
			if(!$result){
				return false;
			}
			if(!@mysql_connect($post['DB_HOST'],$post['DB_USER'],$post['DB_PWD'])) {
				$this->messageList.="数据库连接失败,请检查用户名密码!!<br>";
				$result=false;
			}
			if(!@mysql_select_db($post['DB_NAME'])) {
				$this->messageList.="数据库<b>".$post['DB_NAME']."</b>不存在，请先创建数据库!<br>";
				$result=false;
			}
			return $result;
		}

		function validateAdminFrom($post){
			$result=true;
			if(trim(($post['ADMIN_USER'])=="")){
				$this->messageList.="管理员帐号不能为空!!<br>";
				$result=false;
			}
			if(trim(($post['ADMIN_PWD'])=="")){
				$this->messageList.="管理员密码不能为空!!<br>";
				$result=false;
			}
			if(trim(($post['ADMIN_REPWD'])=="")){
				$this->messageList.="重复输出的密码不能为空!!<br>";
				$result=false;
			}
			if(trim($post['ADMIN_PWD'])!=trim($post['ADMIN_REPWD'])){
				$this->messageList.="两次密码输入不一致!!<br>";
				$result=false;
			}
			if(trim(($post['ADMIN_MAIL'])=="")){
				$this->messageList.="管理员邮箱不能为空!!<br>";
				$result=false;
			}elseif(!preg_match("/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/", $post['ADMIN_MAIL'])){
				$this->messageList.="不是合法的电子邮箱格式!!<br>";
				$result=false;
			}
			return $result;
		}

	}
?>

