<?php
class image {
	private $path;
	function __construct($path){
		$this->path = rtrim($path,'/').'/';
		$this->path;
	}
	function thumb($srcimage,$width,$height,$pre){
		if(file_exists($this->path.$srcimage)){
			$imageinfo     = $this->get_imageinfo($srcimage);
			$resourceimage = $this->fromimage($srcimage,$imageinfo);
			$newsize       = $this->get_newsize($width,$height,$imageinfo);
			$newimage      = $this->createimage($resourceimage,$newsize,$imageinfo);
			return $this->create_image($newimage,$pre.$srcimage,$imageinfo);
		}else{
			echo 'ҪͼƬڣ';
			return;
		}

	}
	private function create_image($newimage,$name,$imageinfo){
		switch ($imageinfo['type']){
			case 1:
				$thumb=imagegif($newimage,$this->path.$name);
				break;
			case 2:
				$thumb=imagejpeg($newimage,$this->path.$name);
				break;
			case 3:
				$thumb=imagepng($newimage,$this->path.$name);
				break;
		}
		imagedestroy($newimage);
		return $name;

	}
	private function createimage($resourceimage,$newsize,$imageinfo){
		$newimage = imagecreatetruecolor($newsize['width'],$newsize['height']);
		$otsc     = imagecolortransparent($resourceimage);
		if($otsc >=0 && $otsc <= imagecolorstotal($resourceimage)){
			$tran = @imagecolorsforindex($resourceimage,$otsc);

			$fillcolor=imagecolorallocate($newimage,$tran['red'],$tran['green'],$tran['blue']);
			imagefill($newimage,0,0,$fillcolor);
			imagecolorsforindex($newimage,$fillcolor);
		}
		imagecopyresized($newimage,$resourceimage,0,0,0,0,$newsize['width'],$newsize['height'],$imageinfo['width'],$imageinfo['height']);
		imagedestroy($resourceimage);
		return $newimage;
	}
	private function get_newsize($width,$height,$imageinfo){
		$newsize['width']  = $imageinfo['width'];
		$newsize['height'] = $imageinfo['height'];
		if($width < $imageinfo['width']){
			$newsize['width']  = $width;
		}
		if($height < $imageinfo['height']){
			$newsize['height'] = $height;
		}
		if(($imageinfo['width']/$newsize['width'])>($imageinfo['height']/$newsize['height'])){
			$newsize['height'] = round($imageinfo['height']*$newsize['width']/$imageinfo['width']);
		}else{
			$newsize['width']  = round($imageinfo['width']*$newsize['height']/$imageinfo['height']);
		}
		return $newsize;

	}
	private function get_imageinfo($name){
		$info = getimagesize($this->path.$name);
		$imageinfo['width']  = $info[0];
		$imageinfo['height'] = $info[1];
		$imageinfo['type']   = $info[2];
		return $imageinfo;

	}
	private function fromimage($name,$info){
		$img = $this->path.$name;
		switch ($info['type']){
			case 1 :
				$img = imagecreatefromgif($img);
				break;
			case 2 :
				$img = imagecreatefromjpeg($img);
				break;
			case 3 :
				$img = imagecreatefrompng($img);
				break;
			default:
				return false;
		}
		return $img;
	}
	function water($srcimage,$waterimage,$postion,$pre){
		if(file_exists($this->path.$srcimage) && file_exists($this->path.$waterimage)){
			$srcinfo   = $this->get_imageinfo($srcimage);
			$waterinfo = $this->get_imageinfo($waterimage);
			if(!$pos = $this->get_postion($srcinfo,$waterinfo,$postion)){
				return false;
			}
			$srcimg   = $this->fromimage($srcimage,$srcinfo);
			$waterimg = $this->fromimage($waterimage,$waterinfo);
			$srcimg   = $this->copyimage($srcimg,$waterimg,$pos,$waterinfo);
			return $this->create_image($srcimg,$pre.$srcimage,$srcinfo);

		}else{
			echo 'ҪͼƬˮӡͼƬڣ';
			return;
		}

	}
	private function copyimage($srcimg,$waterimg,$pos,$waterinfo){
		imagecopy($srcimg,$waterimg,$pos['posx'],$pos['posy'],0,0,$waterinfo['width'],$waterinfo['height']);
		imagedestroy($waterimg);
		return $srcimg;
	}
	private function get_postion($srcinfo,$waterinfo,$postion){
		if(($srcinfo['width'] < $waterinfo['width']) || ($srcinfo['height'] < $waterinfo['height'])){
			return false;
		}
		switch ($postion){

			case 1:
				$posx = 0;
				$posy = 0;
				break;
			case 2:
				$posx = ($srcinfo['width']-$waterinfo['width'])/2;
				$posy = 0;
				break;
			case 3:
				$posx = $srcinfo['width']-$waterinfo['width'];
				$posy = 0;
				break;
			case 4:
				$posx = 0;
				$posy = ($srcinfo['height']-$waterinfo['height'])/2;
				break;
			case 5:
				$posx = ($srcinfo['width']-$waterinfo['width'])/2;
				$posy = ($srcinfo['height']-$waterinfo['height'])/2;
				break;
			case 6:
				$posx = $srcinfo['width']-$waterinfo['width'];
				$posy = ($srcinfo['height']-$waterinfo['height'])/2;
				break;
			case 7:
				$posx = 0;
				$posy = $srcinfo['height']-$waterinfo['height'];
				break;
			case 8:
				$posx = ($srcinfo['width']-$waterinfo['width'])/2;
				$posy = $srcinfo['height']-$waterinfo['height'];
				break;
			case 9:
				$posx = $srcinfo['width']-$waterinfo['width'];
				$posy = $srcinfo['height']-$waterinfo['height'];
				break;
			case 0:
			default :
				$posx = rand(0,($srcinfo['width']-$waterinfo['width']));
				$posy = rand(0,$srcinfo['height']-$waterinfo['height']);
				break;
		}
		return array('posx'=>$posx,'posy'=>$posy);

	}



}
?>