<?php

class sysinfoModel extends Model{
		private $gd;
		private $serverEnv;
		private $domainName;
		private $phpVersion;
		private $gdInfo;
		private $freeType;
		private $mysqlVersion;
		private $allowUrl;
		private $fileUpload;
		private $dbSize;
		private $maxExeTime;


		function __construct(){
			parent::__construct();
			$this->serverEnv =$this->getServerEnv();
			$this->domainName = $this->getDomainName();
			$this->phpVersion = $this->getPhpVersion();
			$this->gdInfo = $this->getGdInfo();
			$this->freeType = $this->getFreeType();
			$this->mysqlVersion = $this->getMysqlVersion();
			$this->allowUrl = $this->getAllowUrl();
			$this->fileUpload = $this->getFileUpload();
			$this->dbSize = $this->getDbSize();
			$this->maxExeTime = $this->getMaxExeTime();
		}

		private function getServerEnv() {
			return PHP_OS.' | '.$_SERVER['SERVER_SOFTWARE'];
		}
		private function getDomainName() {
			return $_SERVER['SERVER_NAME'];
		}
		private function getPhpVersion() {
			return PHP_VERSION;
		}

		private function getGdInfo() {
			if(function_exists('gd_info')){
				$this->gd = gd_info();
				$gdInfo = $this->gd['GD Version'];
			}else {
				$gdInfo = '<span class="red_font">δ֪</span>';
			}
			return $gdInfo;
		}

		private function getFreeType() {
			if($this->gd["FreeType Support"])
				return '֧';
			else
				return '<span class="red_font">֧</span>';
		}

		private function getMysqlVersion() {

		}

		private function getAllowUrl() {
			if(@ini_get('allow_url_fopen'))
				return '֧';
		        else
				return '<span class="red_font">֧</span>';
		}

		private function getFileUpload() {
			if(@ini_get('file_uploads')){
				$umfs = ini_get('upload_max_filesize');
				$pms = ini_get('post_max_size');
   				return ' | ļ:'.$umfs.' | '.$pms;
			}else{
				return '<span class="red_font">ֹ</span>';
			}
		}

		private function getDbSize() {
			$sql = "SHOW TABLE STATUS FROM " . DB_NAME;

			$result=$this->pdo->query($sql);
			$size = 0;
			while($row=$result->fetch(PDO::FETCH_ASSOC))
				$size += $row["Data_length"] + $row["Index_length"];
			return Common::sizeCount($size);
		}

		private function getMaxExeTime() {
			return ini_get('max_execution_time').'';
		}

		public function getSysInfos() {
			$infos=array(
				":" => $this->serverEnv,
				":" => $this->domainName,
				"PHP汾:" => $this->phpVersion,
				"GD汾:" => $this->gdInfo,
				"FreeType:" => $this->freeType,
//				"MYSQL汾:" => $this->mysqlVersion,
				"Զļȡ:" => $this->allowUrl,
				"ļϴ:" => $this->fileUpload,
				"ݿʹ:" => $this->dbSize,
				"űִʱ"=> $this->maxExeTime
			);
			return $infos;
		}
}
?>