<?php
!defined('M_P') && exit('Forbidden');

/**
 * ݱת
 * @param string $data
 * @param string $to_encoding Ŀ
 * @return string
 */
function dataConvert($data, $to_encoding = 'gbk') {
	global $db_charset;
	if ($db_charset != $to_encoding) {
		if (function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($data, $to_encoding, $db_charset);
		} else {
			L::loadClass('Chinese', 'utility/lang', false);
			$chs = new Chinese($db_charset, $to_encoding);
			return $chs->Convert($data);
		}
	}
	return $data;
}

/**
 * õǰʽ
 * @param string $currentPage
 * @param string $style
 */
function setDianpuStyle($currentPage = '', $style = '') {
	$_dianpupage = array('info', 'product');
	$_managepage = array('dmanage', 'imanage', 'pmanage', 'cmanage', 'manage');
	$_dianpustyle = 'images/post/minieitor/minieitor.css';
	$_managestyle = 'mode/dianpu/images/admin/adminstyle.css';
	if (in_array($currentPage, $_dianpupage)) {
		$GLOBALS['currentstyle'] = $_dianpustyle;
	} elseif (in_array($currentPage, $_managepage)) {
		$GLOBALS['currentstyle'] = $_managestyle;
	}
	$GLOBALS['dianpustyle'] = 'default';
	if ($style && is_dir('mode/dianpu/themes/'.$style.'/')) $GLOBALS['dianpustyle'] = $style;
}

/**
 * @param string $_page ǰҳϢ(list,view)
 * @param string $_definedSeo ԶSEOϢ
 * @param string $_fname 
 * @param string $_types Ϣ
 * @param string $_subject 
 * @param string $_tags ǩ
 * @param string $_summary ժҪ
 */
function dianpuSeoSettings($_page = 'index', $_definedSeo = '', $_category = '', $_subject = '') {
	global $dianpu_sitename;
	$_default = array('title' => '{flmc} | {tzmc} - {wzmc}', 'descp' => '{wzgy} | {wzmc}', 
		'keywords' => '{flmc} , {tzmc} | {wzmc}');
	/* վƣĿƣƣǩƣ¸Ҫ  */
	$_replace = array($dianpu_sitename, '', $_category, $_subject, '', '');
	return seoSettings($_definedSeo, $_replace, $_default, '');
}

/**
 * @param string $checkway
 * @param string $type (checkbox/img/txt)
 * @return string
 */
function getDianpuCheckWay($checkway, $type = 'checkbox') {
	$dianpu_checkway = L::config('dianpu_checkway', 'dianpu_config');
	if (!is_array($checkway) && $type == 'checkbox') $_result = '<ul class="list_A list_80">';
	foreach ((array) $dianpu_checkway as $key => $value) {
		$_checked = strpos(',' . $checkway . ',', ',' . $key . ',') !== false ? 'checked="checked"' : '';
		if ($type == 'checkbox') {
			$_result .= '<li><label><input type="checkbox" value="' . $key . '" name="checkway[]" ' . $_checked . '>' . $value . '</label></li>';
		} elseif ($type == 'img' && strpos(',' . $checkway . ',', ',' . $key . ',') !== false) {
			$_result .= '<span title="' . $value . '" class="B_ico ico_' . $key . ' fl">' . $value . '</span>';
		}
	}
	if ($type == 'checkbox') $_result .= '</ul>';
	return $_result;
}

/**
 * ĵĽضַȥ棩
 * 
 * @author xiaoxia.xuxx
 * @param string $str Ҫضϵ
 * @param integer $length Ҫضϵĳ
 * @param boolean $isDhtmlentity Ƿתhtmlʵ壨&nbsp;ЩڽضϵʱӰ죩
 * ----̨ݵĽضҪ˿ո񣬶ǰ̨бҳеĹضϲҪ˱Ϳո
 * @return string ؽضϺַ
 */
function substr_cut($str, $length = 30, $isDhtmlentity = false) {
	$_str = trim(htmlspecialchars_decode($str, ENT_QUOTES));
	($isDhtmlentity) && $_str = trim(preg_replace('/\[s:\w*\]|(&nbsp;)/', '', $_str));
	global $db_charset;
	if (strlen($_str) <= $length) return $_str;
	$i = 0;
	if (strtoupper($db_charset) == 'GBK') {
		for ($i = 0; $i < $length; $i++)
			if (ord($_str[$i]) > 128) $i++;
	} else {
	    for ($i = 0; $i < $length; $i++){
	        $value = ord($_str[$i]);
	        if($value > 127){
	            if ($value >= 192 && $value <= 223) $i++;
	            elseif($value >= 224 && $value <= 239) $i = $i + 2;
	            elseif($value >= 240 && $value <= 247) $i = $i + 3;
	        }
	    }
	}
	//ص&gt;&#60;ֱУӳȡֱñš;мȡ
	if (preg_match('/[0-9]|[a-z]|#|&/', $_str[$i])) {
		for ($j=$i; $j < ($i+6); $j++) {
			if ($_str[$j] === ';') {
				$i = $j;
				break;
			}
		}
	 }
	 return substr($_str, 0, $i);
}

class DP extends PW_BaseLoader {
	/**
	 * ļļ
	 * 
	 * @param string $className 
	 * @param string $dir Ŀ¼ĩβҪ'/'
	 * @param boolean $isGetInstance Ƿʵ
	 * @return mixed
	 */
	function loadClass($className, $dir = '', $isGetInstance = true) {
		return parent::_loadClass($className, 'mode/dianpu/lib/' . parent::_formatDir($dir), $isGetInstance);
	}
	
	/**
	 * db
	 * @param $className
	 */
	function loadDB($dbName, $dir = '') {
		parent::_loadBaseDB();
		return DP::loadClass($dbName . 'DB', parent::_formatDir($dir) . 'db');
	}
}
?>