<?php
!defined('M_P') && exit('Forbidden');
/**
 * 
 * @author L.IuHu.I@2010/8/26
 *
 */
class PW_StylesService {
	
	/**
	 * DAO
	 * @access private
	 * @var PW_Dianpu_StylesDB
	 */
	var $_stylesDao;
	
	/**
	 * ǰʱ
	 * @access private
	 * @var string
	 */
	var $_timestamp;
	
	/**
	 * 캯PHP4
	 */
	function PW_StylesService() {
		$this->__construct();
	}
	
	/**
	 * 캯,PHP5
	 */
	function __construct() {
		global $timestamp;
		$this->_stylesDao = $this->_getStylesDao();
		$this->_timestamp = $timestamp;
	}
	
	/**
	 * ӷ
	 * @param array $fieldData array('ֶ' => 'ֵ') Ҫķ
	 * @return boolean ӵĽ
	 */
	function addStyle($fieldData) {
		if (!S::isArray($fieldData)) return false;
		$this->_stylesDao->insert($fieldData);
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * ӷ
	 * @param array $fieldDatas array(array('ֶ' => 'ֵ'),...) Ҫб
	 * @return boolean 
	 */
	function addStyles($fieldDatas) {
		if (!S::isArray($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['title'] = $v['title'] ? $v['title'] : $v['filename'];
			$tmp['filename'] = $v['filename'];
			$tmp['createdtime'] = $this->_timestamp;
			$fields[] = $tmp;
		}
		$this->_stylesDao->addStyles($fields);
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * ݷID·
	 * @param array $fieldData  µķϢ
	 * @param integer $styleId ҪµķID
	 * @return boolean ظ½
	 */
	function updateStyle($fieldData, $styleId) {
		$styleId = intval($styleId);
		if (!S::isArray($fieldData) || $styleId < 0) return false;
		$this->_stylesDao->update($fieldData, $styleId);
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * ݷIDݿлȡϢ
	 * @param integer $styleId ID
	 * @return mixed boolean (false:ʧ) | array array('ֶ' => 'ֵ') طϢ
	 */
	function getStyle($styleId) {
		$styleId = intval($styleId);
		if ($styleId < 0) return false;
		return $this->_stylesDao->get($styleId);
	}
	
	/**
	 * ȡ
	 * @return array array('styleid' => array('ֶ' => 'ֵ'),...)طϢб
	 */
	function getStyles() {
		$styles = $this->_getStyleCache();
		if (!$styles) $styles = $this->_stylesDao->gets();
		$tmp = array();
		foreach ($styles as $v) {
			$v['preview'] = 'mode/dianpu/themes/' . $v['filename'] . '/images/preview.jpg';
			$tmp[$v['styleid']] = $v;
		}
		return $tmp;
	}
	
	/**
	 * IDsȡ
	 * @param array $ids ҪȡķIDб
	 * @return mixed boolean (false:ʧ) | array array('styleid' => array('ֶ' => 'ֵ'),...)طб
	 */
	function getStylesByIds($ids) {
		if (!S::isArray($ids)) return false;
		$result = $this->_stylesDao->getsByIds($ids);
		if (!$result) return false;
		$tmp = array();
		foreach ($result as $v) {
			$v['preview'] = 'mode/dianpu/themes/' . $v['filename'] . '/images/preview.jpg';
			$tmp[$v['styleid']] = $v;
		}
		return $tmp;
	}
	
	/**
	 * ݷIDɾ
	 * @param integer $styleId ҪɾķID
	 * @return boolean ɾĽ
	 */
	function deleteStyle($styleId) {
		$styleId = intval($styleId);
		if ($styleId < 0) return false;
		if (!$this->_stylesDao->delete($styleId)) return false;
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * ļȡ
	 * @param string $filename ļ
	 * @return mixed boolean (false:ʧ) | array array('ֶ' => 'ֵ') صķϢ
	 */
	function getStyleByFilename($filename) {
		$filename = trim($filename);
		if ($filename == '') return false;
		return $this->_stylesDao->getByFileName($filename);
	}
	
	/**
	 * 駷IDӻļлȡ
	 * @param integer $styleid
	 * @return array طϢ
	 */
	function getStyleById($styleid = '') {
		$styles = L::config('styles', 'dianpu_styles');
		return $styleid ? $styles[$styleid] : $styles;
	}
	
	/**
	 * µ̷񻺴
	 * @return void
	 */
	function updateDianpuStyleCache() {
		$data = $this->_stylesDao->gets();
		$_tmp = array();
		foreach ($data as $key => $value) {
			$value['preview'] = 'mode/dianpu/themes/' . $value['filename'] . '/images/preview.jpg';
			$_tmp[$value['styleid']] = $value;
		}
		$this->_updateCache($_tmp);
	}
	
	/**
	 * ÷񻺴Ϣ
	 * @access private
	 * @return array ػļеķϢ
	 */
	function _getStyleCache() {
		$_cachefile = D_P . "data/bbscache/dianpu_styles.php";
		if (file_exists($_cachefile)) return L::config('styles', 'dianpu_styles');
		return array();
	}
	
	/**
	 * ݴķϢб·񻺴ļ
	 * @param array $data µķϢ
	 * @return void 
	 */
	function _updateCache($data) {
		$_cachefile = D_P . "data/bbscache/dianpu_styles.php";
		writeover($_cachefile, "<?php\r\n\$styles=" . pw_var_export($data) . "\r\n?>");
	}
	
	/**
	 * ȡƷDAO
	 * @return PW_Dianpu_StylesDB 
	 */
	function _getStylesDao() {
		return DP::loadDB("dianpu_styles");
	}

}