<?php
!defined('M_P') && exit('Forbidden');
/**
 * Ʒʷ
 * @author L.IuHu.I@2010/9/8
 *
 */
class PW_ProducthitsService {
	
	/**
	 * ƷDAO
	 * @access private
	 * @var PW_Dianpu_ProducthitsDB
	 */
	var $_producthitsDao;
	
	/**
	 * 캯PHP4
	 */
	function PW_ProducthitsService() {
		$this->__construct();
	}
	
	/**
	 * 캯PHP5
	 */
	function __construct() {
		$this->_producthitsDao = $this->_getProducthitsDao();
	}
	
	/**
	 * Ʒ / ÿ51 һ
	 * @param integer $productId ƷID
	 * @param integer $objId ID
	 * @return integer Ӱ
	 */
	function updateProductHits($productId, $objId = '') {
		$productId = intval($productId);
		$phits = $this->_producthitsDao->get($productId);
		if (!$phits) return $this->_producthitsDao->insert(array('id' => $productId, 'hits' => 1));
		if ($phits['hits'] && ($phits['hits'] % 51) === 0) {
			$productService = $this->_getProductService();
			$productService->updateProduct(array('hits'=>$phits['hits']) , $productId , $objId);
		}
		return $this->_producthitsDao->updateHits($productId);
	}
	
	/**
	 * ݵʻƷIDб
	 * @param integer $start ʼλ
	 * @param integer $offset 
	 * @return mixed boolean (false:ʧ) | array array(array('id' => 'ֵ'),...)Ʒб
	 */
	function getProductByHits($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		return $this->_producthitsDao->gets($start, $offset);
	}
	
	/**
	 * Ʒķ
	 * @access private
	 * @return PW_ProductsService 
	 */
	function _getProductService() {
		return DP::loadClass('productsservice', 'service');
	}
	
	/**
	 * ȡƷDAO
	 * @access private
	 * @return PW_Dianpu_ProducthitsDB 
	 */
	function _getProducthitsDao() {
		return DP::loadDB("dianpu_producthits");
	}

}