<?php
!defined('M_P') && exit('Forbidden');

/**
 * ̵ķ
 * @author 
 *
 */
class PW_DianpuService {
	
	/**
	 * µ̵ĵ
	 * @param integer $dianpuid ID
	 * @param integer $num  ̵
	 * @return integer Ӱ
	 */
	function updateDianpuHits($dianpuid, $num = 1) {
		if (!$dianpuid || !$num) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->updateDianpuHits($dianpuid, $num);
	}
	
	/**
	 * ݷͳƵδ˺͹رյĵ̣
	 * @return array  array('categoryid'=>'','parentid'=>'','total'=>'')
	 */
	function statDianpuByCategory() {
		$_dianpuDB = $this->_getDianpuDB();
		$_stats = $_dianpuDB->statDianpuByCategory();
		$_tmp = array();
		foreach ($_stats as $key => $value) {
			$_tmp[$value['categoryid']] = $value;
		}
		return $_tmp;
	}
	
	/**
	 * ݷIDѯ÷µĵδ˺͹رյĵ̣
	 * 
	 * ں̨ɾʱҪж¸÷ǷѾе̣ң÷µĵ״̬
	 * 
	 * @param integer $categoryID ID
	 * @return integer 
	 */
	function getDianpuCountByCategoryid($categoryID) {
		$categoryId = intval($categoryID);
		if ($categoryId < 1) return false;
		$_dianpuDB = $this->_getDianpuDB();
		$_result = $_dianpuDB->statDianpuByCategory($categoryId);
		return $_result['total'];
	}
	
	/**
	 * ƶ̷
	 * @param array $fieldData  array('parentid' => '', 'categoryid' => '') ҪƶķϢ
	 * @return integer Ӱ
	 */
	function moveDianpuCategory($fieldData) {
		if (!is_array($fieldData) || empty($fieldData)) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->updateDianpuCategory($fieldData);
	}
	
	/**
	 * ݵIDõϢ
	 * @param integer $id ID
	 * @return PW_DianpuModule 
	 */
	function getDianpu($id) {
		$_dianpuDB = $this->_getDianpuDB();
		$_tmp = $_dianpuDB->getDianpuById($id);
		if (!$_tmp) return false;
		return $this->_fieldDataToModule($this->_buildResult($_tmp, true));
	}
	
	/**
	 * ûõϢ
	 * @param string $username ̵ĵ
	 * @return PW_DianpuModule 
	 */
	function getDianpuByUser($username) {
		$_dianpuDB = $this->_getDianpuDB();
		$dianpu = $_dianpuDB->getDianpuByUsername($username);
		if (!$dianpu) return false;
		return $this->_fieldDataToModule($this->_buildResult($dianpu, true));
	}
	
	/**
	 * ̼ID̼Ϣ
	 * @param integer $shangjiaid  ̼ID
	 * @return array array('ֶ' => 'ֵ') ̼Ϣ  
	 */
	function getShangjia($shangjiaid) {
		if (!$shangjiaid) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->getShangjia($shangjiaid);
	}
	
	/**
	 * ͨIDõϢб
	 * @param array $ids  IDб
	 * @param boolean $order ǷID˳
	 * @return array array(array('ֶ' => 'ֵ'),...) Ϣб  
	 */
	function getDianpuListByIds($ids, $order = false) {
		if (!is_array($ids) || empty($ids)) return array();
		$_dianpuDB = $this->_getDianpuDB();
		$_tmp = $_dianpuDB->getDianpuListByIds($ids);
		if ($order) return $this->_orderResult($ids, $this->_buildDianpuResultList($_tmp));
		return $this->_buildDianpuResultList($_tmp);
	}
	
	/**
	 * չ֧
	 * @param array $conditions	 $conditions[$field] = array($value, 'like/eq');
	 * @param integer $start ʼλ
	 * @param integer $perpage Ҫ
	 * @return array array(array('ֶ' => 'ֵ'),...) صϢб        
	 */
	function search($conditions, $start = '0', $perpage = '0') {
		$_dianpuDB = $this->_getDianpuDB();
		$_tmp = $_dianpuDB->search($conditions, $start, $perpage);
		return $this->_buildDianpuResultList($_tmp);
	}
	
	/**
	 * 
	 * @param string $title  ̱
	 * @param string $owner  ̵
	 * @param integer $area  ڵID
	 * @param integer $parentid ҵID
	 * @param integer $category  ҵID
	 * @param integer $start  Ҫʾĵбʼλ
	 * @param integer $perpage  Ҫʾĵб
	 * @return array  array(array('ֶ' => 'ֵ'), ...)Ϣб  
	 */
	function searchForAdmin($title = '', $owner = '', $area = '', $category = '', $parentid = '', $start = '0', $perpage = '0') {
		$conditions = array();
		$conditions['ifcheck'] = array('1', 'eq');
		if ($title) $conditions['title'] = array($title, 'like');
		if ($owner) $conditions['username'] = array($owner, 'like');
		if ($area) $conditions['areaid'] = array($area, 'eq');
		if ($category) $conditions['categoryid'] = array($category, 'eq');
		if ($parentid) $conditions['parentid'] = array($parentid, 'eq');
		return $this->search($conditions, $start, $perpage);
	}
	
	/**
	 * ǰ̨
	 * @param integer $area  ڵID
	 * @param integer $parentid ҵID
	 * @param integer $category ҵID
	 * @param array $checkway ̵֤
	 * @param string $title ĵ
	 * @param string $orderby ʾʽ
	 * @param string $desc ̵˳in_array('asc', 'desc')
	 * @param integer $start ʼλ
	 * @param integer $perpage 
	 * @return array array('dianpuid' => array('ֶ' => 'ֵ'),...) ĵб  
	 */
	function searchForList($area = '', $parentid = '', $category = '', $checkway = array(), $title = '', $orderby = '', $desc = '', $start = '0', $perpage = '0') {
		$conditions = array();
		$conditions['state'] = array('1', 'eq');
		$conditions['ifcheck'] = array('1', 'eq');
		if ($area) $conditions['areaid'] = array($area, 'eq');
		if ($parentid) $conditions['parentid'] = array($parentid, 'eq');
		if ($category) $conditions['categoryid'] = array($category, 'eq');
		if ($title) $conditions['title'] = array($title, 'like');
		if ($checkway) {
			foreach ((array) $checkway as $key => $value) {
				$conditions['checkway'][] = array($value, 'like');
			}
		}
		if ($conditions) {
			$_dianpuDB = $this->_getDianpuDB();
			$dianpus = $_dianpuDB->searchByIndex($conditions, $orderby, $desc, $start, $perpage);
			return $this->getDianpuListByDianpuIndex($dianpus);
		}
		return array();
	}
	
	/**
	 * ǰ̨ͳƷ
	 * @param integer $area ͳƵĵϢ
	 * @param integer $parentid ͳƵҵID
	 * @param integer $category ͳƵķID
	 * @param string  $checkway ͳƵĵ֤ʽ
	 * @param string  $title ͳƵĵ ģѯ
	 * @param string  $orderby ͳƵ
	 * @return mixed boolean  (false:ʧ) | integer ͳƵ
	 */
	function getCountForList($area = '', $parentid = '', $category = '', $checkway = '', $title = '', $orderby = '') {
		$conditions = array();
		$conditions['state'] = array('1', 'eq');
		$conditions['ifcheck'] = array('1', 'eq');
		if ($area) $conditions['areaid'] = array($area, 'eq');
		if ($parentid) $conditions['parentid'] = array($parentid, 'eq');
		if ($category) $conditions['categoryid'] = array($category, 'eq');
		if ($title) $conditions['title'] = array($title, 'like');
		if ($checkway) {
			foreach ((array) $checkway as $key => $value) {
				$conditions['checkway'][] = array($value, 'like');
			}
		}
		if ($conditions) {
			$_dianpuDB = $this->_getDianpuDB();
			return $_dianpuDB->searchByIndexCount($conditions);
		}
		return false;
	}
	
	/**
	 * ̨ĩ˵
	 * @param string $title ̱
	 * @param string $owner  
	 * @param integer $start ʼλ
	 * @param integer $perpage 
	 * @return array  array(array('ֶ' => 'ֵ'),...) صϢб     
	 */
	function searchForVerify($title = '', $owner = '', $start = '0', $perpage = '0') {
		$conditions = array();
		if (!empty($title)) $conditions['title'] = array($title, 'like');
		if (!empty($owner)) $conditions['username'] = array($owner, 'like');
		$conditions['ifcheck'] = array(0, 'eq');
		return $this->search($conditions, $start, $perpage);
	}
	
	/**
	 * ͳƺ̨ĩ˵
	 * @param string  $title  ̱
	 * @param string $owner ̵
	 * @return integer ͳ
	 */
	function getCountByVerify($title = '', $owner = '') {
		$conditions = array();
		if (!empty($title)) $conditions['title'] = array($title, 'like');
		if (!empty($owner)) $conditions['username'] = array($owner, 'like');
		$conditions['ifcheck'] = array(0, 'eq');
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->count($conditions);
	}
	
	/**
	 * δ˵б
	 * @param integer $start  ʼλ
	 * @param integer $perpage   
	 * @return array  array(array('ֶ' => 'ֵ'),...) صĵбϢ
	 */
	function getUncheckDianpuList($start = '0', $perpage = '0') {
		$conditions['ifcheck'] = array('0', 'eq');
		$_dianpuDB = $this->_getDianpuDB();
		$_tmp = $_dianpuDB->search($conditions, $start, $perpage);
		return $this->_buildDianpuResultList($_tmp);
	}
	
	/**
	 * ͳû֤ĵ
	 * @return integer ͳƽ
	 */
	function countUncheckDianpuList() {
		$conditions['ifcheck'] = array('0', 'eq');
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->count($conditions);
	}
	
	/**
	 * ͳ
	 * @param string $title  ̱
	 * @param string $owner  ̵
	 * @param integer $area  ̵ID
	 * @param integer $category  ҵID
	 * @param integer $parentid ҵID
	 * @return integer ͳƽ
	 */
	function getCount($title = '', $owner = '', $area = '', $category = '', $parentid = '') {
		$conditions = array();
		$conditions['ifcheck'] = array('1', 'eq');
		if (!empty($title)) $conditions['title'] = array($title, 'like');
		if (!empty($owner)) $conditions['username'] = array($owner, 'like');
		if (!empty($area)) $conditions['areaid'] = array($area, 'eq');
		if (!empty($category)) $conditions['categoryid'] = array($category, 'eq');
		if ($parentid) $conditions['parentid'] = array($parentid, 'eq');
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->count($conditions);
	}
	
	/**
	 * һƼ
	 * @param string $recommendType  Ƽʾ 
	 * @param integer $num ʾ
	 * @return array  array('dianpuid' => array('ֶ' => 'ֵ'),...) õϢ   
	 */
	function getDianpuByRand($recommendType, $num = 10) {
		$_groupservice = $this->_getGroupService();
		$_groups = $_groupservice->getDianpushowGroups($recommendType);
		if (!$_groups) return array();
		$_dianpuDB = $this->_getDianpuDB();
		$dianpus = $_dianpuDB->searchByRandWithRecommend($num, $_groups);
		return $this->getDianpuListByDianpuIndex($dianpus);
	}
	
	/**
	 * ݵid飬õб
	 * @param array $dianpus array('ֶ' => 'ֵ') IDϢб  
	 * @return array  array('dianpuid' => array('ֶ' => 'ֵ'),...)  صϢб
	 */
	function getDianpuListByDianpuIndex($dianpus) {
		$_tmp = array();
		foreach ($dianpus as $key => $value) {
			$_tmp[$value['dianpuid']] = $value['dianpuid'];
		}
		$_dianpuList = $this->getDianpuListByIds($_tmp);
		foreach ($_dianpuList as $key => $value) {
			if ($_tmp[$value['dianpuid']]) $_tmp[$value['dianpuid']] = $value;
		}
		return $_tmp;
	}
	
	/**
	 * һ
	 * @param PW_DianpuModule $dianpu  ҪӵĵϢ
	 * @return integer ز뷵صID
	 */
	function insertDianpu($dianpu) {
		$fieldData = $this->_moduleToFieldData($dianpu);
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->insertDianpu($fieldData);
	}
	
	/**
	 * µϢ
	 * @param PW_DianpuModule $dianpu ҪµĵϢ
	 * @return boolean
	 */
	function updateDianpu($dianpu) {
		$fieldData = $this->_moduleToFieldData($dianpu);
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->updateDianpu($fieldData);
	}
	
	/**
	 * ݵIDɾ
	 * @param integer $cid ̵ID
	 * @return mixed boolean (false:Ƿ) | integer Ӱ
	 */
	function deleteDianpuContentByCid($cid) {
		if (!$cid) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->deleteContentByCid($cid);
	}
	
	/**
	 * ɾ
	 * @param array $ids ҪɾĵIDб
	 * @return boolean
	 */
	function deleteDianpuMulit($ids) {
		if (!is_array($ids) || empty($ids)) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->deleteDianpuMulit($ids);
	}
	
	/**
	 * ݵIDرյ
	 * @param integer $id ҪرյĵID
	 * @return integer ظӰ
	 */
	function closeDianpu($id) {
		$_dianpuDB = $this->_getDianpuDB();
		$_fieldData = array('dianpuid' => $id, 'state' => '0');
		return $_dianpuDB->updateDianpu($_fieldData);
	}
	
	/**
	 * ݵID
	 * @param integer $id ҪĵID
	 * @return integer ظӰ
	 */
	function openDianpu($id) {
		$_dianpuDB = $this->_getDianpuDB();
		$_fieldData = array('dianpuid' => $id, 'state' => '1');
		return $_dianpuDB->updateDianpu($_fieldData);
	}
	
	/**
	 * ֤
	 * @param array $ids Ҫ֤ĵIDб
	 * @param integer $ifcheck (0/1) ֤
	 * @return integer ʵе֤Ӱ
	 */
	function checkDianpuMulit($ids, $ifcheck) {
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->checkDianpuMulit($ids, $ifcheck);
	}
	
	/**
	 * ӵ˵
	 * @param array $dianpu  Ҫӵĵ˵
	 * @return boolean
	 */
	function insertDianpuContent($dianpu) {
		if (!is_object($dianpu)) return false;
		$_dianpuDB = $this->_getDianpuDB();
		if (!$contentid = $_dianpuDB->insertContent($this->_moduleToFieldData($dianpu))) return false;
		return $this->_setDianpuContentorder($dianpu, $contentid);
	}
	
	/**
	 * µ
	 * @param array $dianpu  ˵
	 * @param integer $contentid ˵ID
	 * @return boolean
	 */
	function updateDianpuContent($dianpu, $contentid) {
		if (!is_object($dianpu)) return false;
		$_dianpuDB = $this->_getDianpuDB();
		if (!$_dianpuDB->updateContent($this->_moduleToFieldData($dianpu), $contentid)) return false;
		return $this->_setDianpuContentorder($dianpu, $contentid);
	}
	
	/**
	 * ݵIDõ̹ڣͬʱƼΪƼ
	 * @param array $dianpuids
	 * @return boolean
	 */
	function setOverdueDianpu($dianpuids) {
		if (!is_array($dianpuids)) return false;
		$_dianpuDB = $this->_getDianpuDB();
		if (!$_dianpuDB->updateDianpuOvertime($dianpuids)) return false;
		return true;
	}
	
	/**
	 * ݵ˵IDõ˵
	 * @param integer $contentid
	 * @return mixed boolean (false:ʧ) | array array('ֶ' => 'ֵ')
	 */
	function getDianpuContent($contentid) {
		if (!$contentid) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->getDianpuContent($contentid);
	}
	
	/**
	 * ɾ˵
	 * @param array $contentids  ˵ID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteDianpuContents($contentids) {
		if (!$contentids) return false;
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->deleteContents($contentids);
	}

	/**
	 * ݵIDرյ
	 * @param array $ids  IDб
	 * @param string $state  ״̬Ϣ
	 * @return integer
	 */
	function closeDianpuMulit($ids, $state) {
		$_dianpuDB = $this->_getDianpuDB();
		return $_dianpuDB->stateDianpuMulit($ids, $state);
	}
	
	/**
	 * IDS
	 * @access private
	 * @param array $ids   б
	 * @param array $result array(array('ֶ' => 'ֵ')...) ҪĽ     
	 * @return array array('dianpuid' => array('ֶ' => 'ֵ'),...)  idsĽ
	 */
	function _orderResult($ids, $result) {
		$_result = array();
		foreach ($ids as $key => $value) {
			$_result[$value] = array();
		}
		foreach ($result as $key => $value) {
			$_result[$value['dianpuid']] = $value;
		}
		return $_result;
	}
	
	/**
	 * ӵ
	 * @access private
	 * @param PW_DianpuModule $dianpu Ҫ̵ݵĵϢ
	 * @param integer $contentid  ˵ID
	 * @return boolean 
	 */
	function _setDianpuContentorder($dianpu, $contentid) {
		if (!$contentid) return false;
		$_dianpuDB = $this->_getDianpuDB();
		$_contentorder = $dianpu->contentorder;
		$_contentorder[$contentid]['t'] = $dianpu->titles;
		$dianpu->titlesorder && $_contentorder[$contentid]['o'] = $dianpu->titlesorder;
		$dianpu->setContentorder($_contentorder);
		return $_dianpuDB->updateDianpu($this->_moduleToFieldData($dianpu));
	}
	
	/**
	 * չֶηװ
	 * @access private
	 * @param PW_DianpuModule $dianpu
	 * @return array array('phone' => '', 'overtime' => '');
	 */
	function _getExtendField($dianpu) {
		$_result = array();
		$_result['phone'] = (!is_null($dianpu->areanumber) && !is_null($dianpu->phone)) ? $dianpu->areanumber . '-' . $dianpu->phone : null;
		$_result['overtime'] = $dianpu->overtime ? PwStrtoTime($dianpu->overtime) : 0;
		return $_result;
	}
	
	/**
	 * չmoduleװ
	 * @access private
	 * @param array $fieldData  Ҫ˵Ϣ
	 * @return array array('ֶ' => 'ֵ')
	 */
	function _getExtendModule($fieldData) {
		$_result = array();
		$_result['phone'] = substr($fieldData['phone'], (strpos($fieldData['phone'], '-') + 1));
		$_result['areanumber'] = substr($fieldData['phone'], '0', strpos($fieldData['phone'], '-'));
		$_result['checkwayhtml'] = $fieldData['checkwayhtml'];
		$_result['contentorder'] = $fieldData['contentorder'];
		$_result['category'] = $fieldData['category'];
		$_result['parent'] = $fieldData['parent'];
		$_result['group'] = $fieldData['group'];
		return $_result;
	}
	
	/**
	 * PW_DianpuModuleת
	 * @access private
	 * @param PW_DianpuModule $dianpu
	 * @return array array('ֶ' => 'ֵ', ...)
	 */
	function _moduleToFieldData($dianpu) {
		$_extends = $this->_getExtendField($dianpu);
		$struct = $this->getTableStruct();
		$_result = array();
		foreach ($struct as $key => $value) {
			$_result[$value] = $dianpu->{$value};
		}
		foreach ($_extends as $key => $value) {
			$_result[$key] = $value;
		}
		return $_result;
	}
	
	/**
	 * תPW_DianpuModule
	 * @access private 
	 * @param array $fieldData
	 * @return PW_DianpuModule 
	 */
	function _fieldDataToModule($fieldData) {
		$dianpu = DP::loadClass('dianpumodule', 'module'); /* @var $dianpu PW_DianpuModule */
		$_extends = $this->_getExtendModule($fieldData);
		$struct = $this->getTableStruct();
		foreach ($struct as $key => $value) {
			if (array_key_exists($value, get_class_vars('PW_DianpuModule'))) $dianpu->{$value} = $fieldData[$value];
		}
		foreach ($_extends as $key => $value) {
			if (array_key_exists($key, get_class_vars('PW_DianpuModule'))) $dianpu->{$key} = $value;
		}
		return $dianpu;
	}
		
	/**
	 * 췵صĽ
	 * @access private
	 * @param array $result  array(array('ֶ' => 'ֵ'),...) Ҫ
	 * @return array array(array('ֶ' => 'ֵ'),...) عĽ
	 */
	function _buildDianpuResultList($result) {
		$_tmp = array();
		foreach ((array) $result as $key => $value) {
			$_tmp[$key] = $this->_buildResult($value, true);
		}
		return $_tmp;
	}
	
	/**
	 * װ
	 * @access private
	 * @param array $fieldData  װĽ
	 * @param boolean $buildField  ǷװҵϢ͵Ϣ
	 * @return array array('ֶ' => 'ֵ');
	 */
	function _buildResult($fieldData, $buildField = false) {
		if ($fieldData['createtime']) $fieldData['createtime'] = get_date($fieldData['createtime'], 'Y-m-d H:i');
		if ($fieldData['overtime']) $fieldData['overtime'] = get_date($fieldData['overtime'], 'Y-m-d H:i');
		if (isset($fieldData['groupid']) && $fieldData['groupid']) {
			$groups = L::config('dianpuGroups', 'dianpu_groups');
			$_groupsInfo = $groups[$fieldData['groupid']];
			$fieldData['group'] = $_groupsInfo;
		}
		if (isset($fieldData['logo']) && $fieldData['logo'] && $_groupsInfo['configinfo']['uploadlogo']) {
			$_tmp = geturl($fieldData['logo'], '', true);
			$fieldData['logo'] = $_tmp[0];
		} else {
			$fieldData['logo'] = 'mode/dianpu/images/default.jpg';
		}
		if (isset($fieldData['checkway']) && $fieldData['checkway']) {
			$fieldData['checkwayhtml'] = getDianpuCheckWay($fieldData['checkway'], 'img');
		}
		if (isset($fieldData['categoryid']) && $fieldData['categoryid'] && $buildField) {
			$category = DP::loadClass('categoriesservice', 'service');
			/* @var $category PW_CategoriesService */
			$fieldData['category'] = $category->getCategory($fieldData['categoryid']);
			$fieldData['parent'] = $category->getCategory($fieldData['category']['parentid']);
			$fieldData['category'] = $fieldData['category']['name'];
			$fieldData['parent'] = $fieldData['parent']['name'];
		}
		if (isset($fieldData['areaid']) && $fieldData['areaid'] && $buildField) {
			$area = DP::loadClass('areasservice', 'service');
			/* @var $area PW_AreasService */
			$fieldData['area'] = $area->getArea($fieldData['areaid']);
			$fieldData['area'] = $fieldData['area']['name'];
		}
		return $fieldData;
	}
	
	/**
	 * õ̱ṹ
	 * @return array 
	 */
	function getTableStruct() {
		$dianpuDB = $this->_getDianpuDB();
		return $dianpuDB->getStruct();
	}
	
	/**
	 * õservice
	 * @access private
	 * @return PW_GroupService 
	 */
	function _getGroupService() {
		return DP::loadClass('groupservice', 'service');
	}
	
	/**
	 * õDAO
	 * @access private
	 * @return PW_Dianpu_DianpuDB 
	 */
	function _getDianpuDB() {
		return DP::loadDB('dianpu_dianpu');
	}
}
?>