<?php
!defined('M_P') && exit('Forbidden');

/**
 * ̸ķʵ
 * @author 
 */
class PW_DianpuattachService {
	/**
	 * µ̸Ϣ
	 * @param integer $did ̵ID
	 * @param array $attachs ϴĸϢ
	 * @return array array('Ƿи','ͼƬid')
	 */
	function updateAttachs($did, $attachs) {
		$_attachDB = $this->_getAttachDB();
		$ifAttach = 0;
		$uploadIds = array();
		foreach ($attachs as $value) {
			if ($value['attname'] != 'delete') $ifAttach = 1;
			if ($value['attname'] == 'replace') {
				$saveData = $this->_cookUploadData($value, $did);
				$_attachDB->update($saveData, $value['id']);
			} elseif ($value['attname'] == 'attachment') {
				$saveData = $this->_cookUploadData($value, $did);
				$temp = $_attachDB->insert($saveData);
				$uploadIds[$value['id']] = $temp;
			} elseif ($value['attname'] == 'update') {
				$_attachDB->update(array('descrip' => $value['descrip']), $value['attachid']);
			} elseif ($value['attname'] == 'delete') {
				$_attachDB->delete($value['attachid']);
			}
		}
		return array($ifAttach, $uploadIds);
	}
	
	/**
	 * ȡ̵ĸϢ
	 * @param integer $did ID
	 * @return array array('ֶ' => 'ֵ')
	 */
	function getAttachsByDianpuId($did) {
		$_attachDB = $this->_getAttachDB();
		$attachs = $_attachDB->getAttachsByDianpuId($did);
		$result = array();
		foreach ($attachs as $key => $value) {
			$value['attachurl'] = $this->_getImageUrl($value['attachurl']);
			$result[$value['attachid']] = $value;
		}
		return $result;
	}
	
	/**
	 * IDȡϢ
	 * @param integer $id ҪȡϢĸID
	 * @return array array('ֶ' => 'ֵ')
	 */
	function getAttachById($id) {
		$_attachDB = $this->_getAttachDB();
		$temp = $_attachDB->get($id);
		if (!$temp) return array();
		$temp['attachurl'] = $this->_getImageUrl($temp['attachurl']);
		return $temp;
	}
	
	/**
	 * װϴ
	 * @access private
	 * @param array $data 
	 * @param integer $did  ID
	 * @return array array('ֶ' => 'ֵ')
	 */
	function _cookUploadData($data, $did) {
		global $timestamp;
		return array('name' => $data['name'], 'descrip' => $data['descrip'], 'dianpuid' => $did, 
					'type' => $data['type'], 'size' => $data['size'], 'uploadtime' => $timestamp, 
					'attachurl' => $data['fileuploadurl'], 'ifthumb' => $data['ifthumb']);
	}
	
	/**
	 * װͼƬurl
	 * @access private
	 * @param string $path ͼƬĵַ
	 * @return string ͼƬĴ洢ַ
	 */
	function _getImageUrl($path) {
		$temp = geturl($path);
		return $temp[0];
	}
	
	/**
	 * õ̸DAO
	 * @access private
	 * @return PW_Dianpu_AttachDB 
	 */
	function _getAttachDB() {
		return DP::loadDB('dianpu_attach');
	}
}
?>