<?php
!defined('P_W') && exit('Forbidden');

/**
 * Ϣcsvļ
 * @author yishuo
 */
class PW_CSVService {
	
	/**
	 * ȡļ
	 * @access private
	 * @var string
	 */
	var $_filename;
	
	/**
	 * ļľ
	 * @access private
	 * @var resource
	 */
	var $_fp = NULL;
	
	/**
	 * ϴCSVļ
	 * 
	 * @access private
	 * @return boolean ¼ϴǷɹ
	 */
	function _uploadCsv() {
		$csvupload = DP::loadClass('csvupload');
		if (PwUpload::getUploadNum()) {
			PwUpload::upload($csvupload);
			$this->_filename = $csvupload->pathname;
			return true;
		}
		return false;
	}
	
	/**
	 * ӵļлȡϢб
	 * @return array  array(array('ֶ' => 'ֵ')...)
	 */
	function getDataList() {
		global $db_charset;
		if (!$this->_uploadCsv()) return array();
		if (!$this->_isCsv()) return array();
		$this->_open();
		$filesize = filesize($this->_filename);
		$_result = array();
		$_col = 0;
		L::loadClass('Chinese', 'utility/lang', false);
		$chs = new Chinese('gbk', $db_charset);
		while (($data = fgets($this->_fp, $filesize)) !== false) {
			if ($_col >= 100) break;
			$data = explode(',', $this->_filterInputData($data));
			if ($_col > 0 && $data) {
				if (!$data[0] && !$data[1] && !$data[2] && !$data[3]) continue;
				$_formator['username'] = $chs->Convert($data[0]);
				$_formator['title'] = $chs->Convert($data[1]);
				$_formator['operator'] = $chs->Convert($data[2]);
				$_formator['operatorphone'] = $chs->Convert($data[3]);
				$_formator['company'] = $chs->Convert($data[4]);
				$_formator['delegate'] = $chs->Convert($data[5]);
				$_formator['delegatephone'] = $chs->Convert($data[6]);
				$_formator['companyaddress'] = $chs->Convert($data[7]);
				$_formator['companyfax'] = $chs->Convert($data[8]);
				$_formator['companyphone'] = $chs->Convert($data[9]);
				$_formator['companyzipcode'] = $chs->Convert($data[10]);
				$_result[] = $_formator;
			}
			$_col++;
		}
		$this->_close();
		$this->_del();
		return $_result;
	}
	
	/**
	 * һе
	 * ˿ոƱ\tַת
	 * @access private
	 * @param string $data Ҫ˵
	 * @return string ˺
	 */
	function _filterInputData($data) {
		$data = str_replace(array("\t", ' '), '', $data);
		return S::escapeChar($data, 0, true);
	}
	
	/**
	 * жϵļǷCSVļ
	 * @access private
	 * @return boolean жϵĽ
	 */
	function _isCsv() {
		if (!$this->_filename || !is_file($this->_filename)) return false;
		$ext = strtolower(substr(strrchr($this->_filename, '.'), 1));
		if (!in_array($ext, array('csv'))) return false;
		return true;
	}
	
	/**
	 * 򿪵ļ
	 * @access private
	 * @param string $method 򿪷ʽ ĬΪֻ
	 * @return void
	 */
	function _open($method = 'r') {
		if (!is_resource($this->_fp)) {
			$this->_fp = fopen($this->_filename, $method);
		}
	}
	
	/**
	 * رմ򿪵ļ
	 * @access private
	 * @return void
	 */
	function _close() {
		if (is_resource($this->_fp)) {
			fclose($this->_fp);
			$this->_fp = NULL;
		}
	}
	
	/**
	 * ɾļ
	 * @access private
	 * @return void
	 */
	function _del() {
		if ($this->_filename && is_file($this->_filename)) {
			P_unlink($this->_filename);
		}
	}
}
?>