<?php
/**
 * û۵ķʵ
 * 
 * Ҫʵɾҵ
 * @author xiaoxia.xuxx
 */
!defined('M_P') && exit('Forbidden');

/**
 * û۷
 * @author xiaoxia.xuxx
 */
class PW_CommentService {
	
	/**
	 * ݱDAO
	 * @access private
	 * @var PW_Dianpu_CommentContentsDB
	 */
	var $_commentContentsDB;
    
	/**
	 * 캯PHP4
	 */
	function PW_CommentService() {
		$this->__construct();
	}
    
	/**
	 * 캯PHP5
	 */
	function __construct() {
		$this->_commentContentsDB = $this->_getCommentcontentsDB();
	}
	
	/**
	 * 
	 * 
	 * Ȳ
	 * rootidparentidǷһֵ Ǹ
	 * 
	 * @param array $data array('ֶ' => 'ֵ') ۵Ϣ 
	 * @return mixed boolean زĽ  | array(false, 'message')ع˵Ľ
	 */
	function addComment($data) {
		if (!$data) return false;
		$data = $this->_filterInsertParam($data);
		if($data[0] === false) return $data;
		$intoContents = $this->_filterInsertData($data, 'contents');
		if (!$intoContents) return false;
		$data['commentid'] = $this->_commentContentsDB->insert($intoContents);
		if (!$data['commentid']) return false;
		if ($data['rootid'] && intval($data['rootid']) != 0) {
			return $this->_addCommentReply($data);
		} else {
			return $this->_addRootComment($data);
		}
	}
	
	/**
	 * ɾһ()
	 * 
	 * ˼·ȥ۱Ҹݣ
	 * ûм¼ñɾڸݱֱӵ˽к_deleteByRootidsɾۼ,Ӱ
	 * м¼ñɾڶۻۣ˽к_deleteByParentidsɾµ
	 * 
	 * @param integer $id ҪɾID
	 * @param integer $objectid Ҫɾĸ۵ڵĵ()ID
	 * @return mixed boolean (false:ʧ) | integer ɾӰ
	 */
	function deleteComment($id, $objectid) {
		if (!$id || !$objectid) return false;
		$commentsDB2 = $this->_getCommentReplysDB();
		if (!$commentsDB2->getRootidByCommentid($id, $objectid)) {
			return $this->_deleteByRootids(array($id), $objectid);
		} else {
			return $this->_deleteByParentids(array($id), $objectid);
		}
	}
	
	/**
	 * վɾһ()
	 * 
	 * @param integer $id ҪɾID
	 * @return mixed boolean (false:ʧ) | integer ɾӰ
	 */
	function delCommentForAdmin($id) {
		if (!$id) return false;
		$commentsDB2 = $this->_getCommentReplysDB();
		if (!$commentsDB2->getRootidByCommentid($id)) {
			return $this->_deleteByRootidsForAdmin(array($id));
		} else {
			return $this->_deleteByParentidsForAdmin(array($id));
		}
	}
	
	/**
	 * ɾ()
	 * 
	 * ˼·
	 * ȥ˽к_filterDeleteRootID˱ɾбеиID
	 * иۣ˽к_deleteByRootidsɾۼ,Ӱ
	 * phpúarray_diffԭʼIDбͱѯĸ۵бһòмҪɾĶ
	 * ûиۣòԭʼIDб
	 * ԪΪ0˵ñɾIDбǸֱۣӷ
	 * ԪزΪ0˽к_deleteByParentidsɾµ
	 * 
	 * @param array $ids ҪɾID
	 * @param integer $dianpuid  Ҫɾڵĵ(objectid)ID
	 * @return mixed boolean (false:ʧ) | integer  Ӱ
	 */
	function deleteComments($ids, $objectid) {
		if (!S::isArray($ids) || !$objectid) return false;
		$delNum = 0;
		$rootIDs = $this->_filterDeleteRootID($ids);
		(count($rootIDs) != 0 ) && $delNum = $this->_deleteByRootids($rootIDs, $objectid);
		$secondIDs = array_diff($ids, $rootIDs);
		if (count($secondIDs) != 0) {
			$delNum += $this->_deleteByParentids($secondIDs, $objectid);
		}
		return $delNum;
	}
	/**
	 * վɾ()
	 * 
	 * @param array $ids  ҪɾIDб
	 * @return mixed boolean (false:ʧ) | integer  Ӱ
	 */
	function delCommentsForAdmin($ids) {
		if (!S::isArray($ids)) return false;
		$delNum = 0;
		$rootIDs = $this->_filterDeleteRootID($ids);
		(count($rootIDs) != 0 ) && $delNum = $this->_deleteByRootidsForAdmin($rootIDs);
		$secondIDs = array_diff($ids, $rootIDs);		
		if (count($secondIDs) != 0) {
			$delNum += $this->_deleteByParentidsForAdmin($secondIDs);
		}	
		return $delNum;
	}
	
	/**
	 * Ϊ̵ƷɾҪɾ Ʒ͵̹ṩӿڣ
	 * 
	 * @param integer $objectid ID
	 * @param integer $typeid ƷID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteCommentByObject($objectid, $typeid = 0) {
		if (!$objectid) return false;
		$commentDB1 = $this->_getCommentsDB();
		$rootID = $commentDB1->getRootidByObject($objectid, $typeid);
		$rootidList = $this->_filterArray($rootID, 'commentid');
		$commentDB1->deletes($rootidList);
		$commentDB2 = $this->_getCommentReplysDB();
		$commentDB2->deletesByRootID($rootidList);
		return $this->_commentContentsDB->deleteByObject($objectid, $typeid);
	}		
	
	/**
	 * (̨ վ̨̼Һ̨)
	 * 
	 * @param array $params 
	 * @param integer $start ʼѯļ¼
	 * @param integer $perpage ܹصļ¼
	 * @return array array(array('ֶ' => 'ֵ'),...) زѯĽ
	 */
	function getSearchCommentList($params, $start = 0, $perpage = 20) {
		$_tempList = $this->_commentContentsDB->search($params, $start, $perpage);
		return $this->_buildResultList($_tempList);
	}	

	/**
	 * ǰ̨ʾȡһϢб
	 * 
	 * @param integer $objectid  ID
	 * @param integer $typeid  ƷID  Ϊ0ֻȡ̵ۣΪ0ȡõиƷ
	 * @param integer $start ҳʼλ
	 * @param integer $perpage ÿҳʾ
	 * @return mixed boolean (false:ʧ) | array array(array('ֶ' => 'ֵ'),...) б
	 */
	function getFrontCommentList($objectid, $typeid = 0, $start = 0, $perpage = 20) {
		if (!$objectid) return array();
		$frontRootidList = $this->_commentContentsDB->getRootidByObject($objectid, $typeid, $start, $perpage);
		$IDList = $this->_filterArray($frontRootidList, 'commentid');
		$_tempList = $this->_commentContentsDB->getFrontCommentsInfoList($IDList);
		return $this->_buildResultList($_tempList);
		
	}
	
	/**
	 * ݵIDƷIDøи۵
	 * 
	 * @param integer $objectid ̣ID
	 * @param integer $typeid ƷID
	 * @return integer ظọ̃߸õµĸƷ
	 */
	function getFrontCount($objectid, $typeid = 0) {
		if (!$objectid) return 0;
		return $this->_commentContentsDB->getFrontCount($objectid, $typeid);
	}
	
	/**
	 * ۵IDбȡ۵ӼϸϢʱ
	 * 
	 * @param array $rootidList ۵IDб
	 * @return array array('rootid' =>array(array('ֶ'=>'ֵ'),...),...)ԸIDΪڵӼݼ
	 */
	function getChildCommentList($rootidList){
		if (!S::isArray($rootidList)) return array();
		$_commentList = $this->_commentContentsDB->getChildCommentInfoList($rootidList);
		return $this->_buildCommentList($_commentList, 'rootid');
	}
	
	/**
	 * ݶIDƷIDøеĵظ(ʱ)
	 * 
	 * @param integer $objectid (ID
	 * @param integer $typeid ƷID
	 * @return array array('parentid' =>array(array('ֶ'=>'ֵ'),...),...)Ѹڵ缯
	 */
	function getReplyCommentList($objectid, $typeid = 0) {
		if (!$objectid) return array();
		$_commentList = $this->_commentContentsDB->getReplyCommentList($objectid, $typeid);
		return $this->_buildCommentList($_commentList, 'parentid');
	}
	
	/**
	 * Ĳбؼ¼
	 * 
	 *@param array $params  Ҫɸѡб   array('content' => '',  
	 *												'username' => '۷',  
	 *           									'startdate' => 'ѯ۵Ŀʼʱ ', 
	 *           									'enddate' => 'ѯ۵Ľʱ' ,
	 *          									'isanswer' = > 'Ƿǻظ1ǻظ',
	 *          									'state' => 'ǷѾظ1ΪѾظ',
	 *           									'objectid' => 'ɸѡбĵ̣Ƕ󣩵ID',
	 *           									'typeid' => 'ɸѡбƷID',
	 *     										)
	 * @return integer طɸѡ
	 */
	function countTotals($params) {
		return $this->_commentContentsDB->count($params);
	}
	
	/**
	 * ĵڶб,صĽнԵڶΪڵγɵ(̺Ʒչʾ)
	 * 
	 * @access private
	 * @param array $commentList array(array('ֶ','ֵ'),...)Ϣб
	 * @param integer $parentid ۵ID
	 * @return array array('id' =>array(array('ֶ'=>'ֵ'),...),...)ؾۺ֮Ϣ
	 */
	function _buildCommentList($commentList, $parentid) {
		$_temp = array();
		$parentid = (!in_array($parentid, array('rootid', 'parentid'))) ? 'rootid' : trim($parentid);
		foreach ($commentList as $key => $value) {
			$_temp[$value[$parentid]][] = $this->_buildResultValue($value);
		}
		return $_temp;
	}
	
	/**
	 * б һάб(ǰ̨ҳ)
	 * 
	 * @access private
	 * @param array $commentList array(array('ֶ','ֵ'),...) ۵Ϣб
	 * @return array array(array('ֶ' => 'ֵ'),...) װɵĽ
	 */
	function _buildResultList($commentList) {
		$_temp = array();
		foreach ($commentList as $key => $value) {
			$_temp[$key] = $this->_buildResultValue($value);
		}
		return $_temp;
	}
	
	/**
	 * װÿֵֶ
	 * 
	 * @access private 
	 * @param array $comment array('ֶ' => 'ֵ') ϸϢб
	 * @return array array('ֶ' => 'ֵ') װ 
	 */
	function _buildResultValue($comment) {
		require_once(R_P . 'require/bbscode.php');//װغ showface
	    if (!S::isArray($comment)) return array();
	    $comment['postdate'] = $comment['postdate'] ? get_date($comment['postdate']) : '-';
	    $frontURL = 'index.php?m=dianpu&id=' . $comment['objectid'] . '&productid=' . $comment['typeid'];
	    $frontURL .= ($comment['typeid'] != 0) ? "&c=product&a=detail" : "&c=info";
	    $comment['frontURL'] = $frontURL;
	    ($comment['icon']) ? list($comment['faceurl']) = showfacedesign($comment['icon'], 1, 'm') : $comment['faceurl'] = "images/face/none.gif";
	    $comment['shortcontent'] = substr_cut($comment['content'], 45, true);
	    ($comment['shortcontent'] == "") && $comment['shortcontent'] = substr_cut($comment['title'], 20);
	    (strpos($comment['content'],'[s:') !== false) && $comment['content'] = showface($comment['content']);
	   	return $comment;
	}
	
	/**
	 * IDбй˳иID(ɾ۵ʱ)
	 * 
	 * @access private
	 * @param array $ids Ҫ˵IDб
	 * @return array иIDб
	 */
	function _filterDeleteRootID($ids) {
		$commentsDB1 = $this->_getCommentsDB();		
		$rootIDs = $commentsDB1->filterDeleteRootID($ids);
		return $this->_filterArray($rootIDs, 'commentid');
	}
	
	/**
	 * ǰ̨ɾĳۼۡ
	 * 
	 * ˼·
	 * ͨȻиø۵IDб
	 * ۼ۵IDкϲõɾIDбɾ
	 * 
	 * @access private
	 * @param array $commentids ID
	 * @param integer $objectid ̣ID
	 * @return integer Ӱ
	 */
	function _deleteByParentids($commentids, $objectid) {
		if (!S::isArray($commentids) || !$objectid) return false;
		$commentsDB1 = $this->_getCommentsDB();
		$commentsDB2 = $this->_getCommentReplysDB();
		$childCommentIDList = $commentsDB2->getCommentidByParentid($commentids);
		$childIDs = $this->_filterArray($childCommentIDList, 'commentid');
		$delIDs = array_merge($commentids, $childIDs);
		$commentsDB2->deletes($delIDs, $objectid);
		return $this->_commentContentsDB->deletes($delIDs, $objectid);
	}
	
	/**
	 * վ̨ݸIDɾӼø
	 * 
	 * @access private
	 * @param array $commentids IDб
	 * @return integer Ӱ
	 */
	function _deleteByParentidsForAdmin($commentids) {
		if (!S::isArray($commentids)) return false;
		$commentsDB1 = $this->_getCommentsDB();
		$commentsDB2 = $this->_getCommentReplysDB();
		$childCommentIDList = $commentsDB2->getCommentidByParentid($commentids);
		$childIDs = $this->_filterArray($childCommentIDList, 'commentid');
		$delIDs = array_merge($commentids, $childIDs);
		$commentsDB2->delsForAdmin($delIDs);
		return $this->_commentContentsDB->delsForAdmin($delIDs);
	}
	
	/**
	 * --ɾۼ
	 * 
	 * ˼·
	 * ݴĸIDµIDID͸IDкϲõҪɾIDб
	 * ֱdeletes ȶӦɾɾ
	 * 
	 * @access private
	 * @param array $rootIDs ID
	 * @param integer $objectid ̣ID
	 * @return integer Ӱ
	 */
	function _deleteByRootids($rootIDs, $objectid) {
		if (!S::isArray($rootIDs) || !$objectid) return false;
		$commentsDB1 = $this->_getCommentsDB();
		$commentsDB2 = $this->_getCommentReplysDB();
		$commentsID = $commentsDB2->getCommentidByRootid($rootIDs);
		$childCommentID = $this->_filterArray($commentsID, 'commentid');
		$commentsDB2->deletesByRootID($rootIDs, $objectid);	
		$commentsDB1->deletes($rootIDs, $objectid);		
		$commentID = array_merge($rootIDs, $childCommentID);
		return $this->_commentContentsDB->deletes($commentID, $objectid);
	}
	
	/**
	 * ̨ͬ
	 * 
	 * @access private
	 * @param array $rootIDs IDб
	 * @return integer Ӱ
	 */
	function _deleteByRootidsForAdmin($rootIDs) {
		if (!S::isArray($rootIDs)) return false;
		$commentsDB1 = $this->_getCommentsDB();		
		$commentsDB2 = $this->_getCommentReplysDB();
		$commentsID = $commentsDB2->getCommentidByRootid($rootIDs);
		$childCommentID = $this->_filterArray($commentsID, 'commentid');
		$commentsDB2->deletesByRootIDForAdmin($rootIDs);	
		$commentsDB1->delsForAdmin($rootIDs);	
		$commentID = array_merge($rootIDs, $childCommentID);
		return $this->_commentContentsDB->delsForAdmin($commentID);
	}
	
	/**
	 * Ĳ
	 * 
	 * @access private
	 * @param array $params   
	 * @param string $key     ҪļֵΪ0)
	 * @param array array('','',) һά飬ּ
	 */
	function _filterArray($params, $key = 0) {
		if (!$params) return array();
		if (!S::isArray($params)) return array();
		$clear = array();
		foreach($params as $value) {
			$clear[] = $value[$key];
		}
		return $clear;
	}
	
	/**
	 * ԲݱݽкϷֶι
	 *  
	 * @access private
	 * @param array $fieldData ݼ
	 * @param string $table array('contents', 'reply1','reply2') ˵ݱ
	 * @return mixed boolean (false:ʧ) | array ع˺ĺϷݼ
	 */
	function _filterInsertData($fieldData, $table = 'contents') {
		if (!S::isArray($fieldData) || !S::inArray($table, array('contents', 'reply1', 'reply2'))) return false;
		$allowField = array();
		$allowField['contents'] = array('commentid', 'title', 'content', 'objectid', 'typeid', 'uid', 'username', 'postdate', 'isanswer', 'state');
		$allowField['reply1'] = array('commentid', 'objectid', 'typeid', 'postdate');
		$allowField['reply2'] = array('commentid', 'parentid', 'rootid', 'postdate', 'objectid');
		$clearData = array();
		foreach ($fieldData as $key => $value) {
			if (in_array($key, $allowField[$table])) $clearData[$key] = $value;
		}
		return $clearData;		
	}
	
	/**
	 * ˲
	 * 
	 * @access private
	 * @param array $info ԲĲй
	 * @return array array('ֶ' => 'ֵ' )
	 */
	function _filterInsertParam($info) {
		$wordsfb = L::loadClass('FilterUtil', 'filter');//дʹ		
		$clean = array();
		if (!$info['uid'])  return array(false, 'Ƿ'); 
		$clean['uid'] = $info['uid'];
		if (!$info['username'])  return array(false, 'Ƿ');
		$clean['username'] = trim($info['username']);
		if (!$info['content'] || $info['content'] == '')  return array(false, '!');
		if (($banword = $wordsfb->comprise($info['content'], false)) !== false) return array(false, "棺ݺзǷ <font color=red>" . $banword . "</font>");
		$_temp = trim(preg_replace('/\[s:\w*\]|(&nbsp;)/', '', $info['content']));//˱鼰htmlոʵ
		if(strlen(trim($_temp)) > 1000 ) return array(false, 'ݲܳ1000ֽڣ');
		$clean['content'] = trim($info['content']);
		if ($info['title'] && $wordsfb->comprise($info['title'], false) !== false) return array(false, "棺۱⺬зǷ <font color=red>" . $banword . "</font>");
		($info['title']) ? $clean['title'] = trim($info['title']) : $clean['title'] = $clean['username'] . ':';//¼û;
		if (!$info['objectid'])  return array(false, 'Ƿ');
		$clean['objectid'] = trim($info['objectid']);
		(!$info['typeid']) ? $clean['typeid'] = 0 : $clean['typeid'] = trim($info['typeid']);
		(!$info['parentid']) ? $clean['parentid'] = 0 : $clean['parentid'] = trim($info['parentid']);
		isset($info['rootid']) ? $clean['rootid'] = intval($info['rootid']) : $clean['rootid'] = 0;
		($clean['parentid'] != 0 && $clean['rootid'] == 0) && $clean['rootid'] = $clean['parentid'];
		($clean['rootid'] !=0 && $clean['parentid'] == 0) && $clean['parentid'] = $clean['rootid'];
		$clean['postdate'] = trim($info['postdate']);
		(!$info['isanswer'] || !in_array($info['isanswer'], array('0', '1'))) ? $clean['isanswer'] = 0 : $clean['isanswer'] = 1;
		return $clean;
	}

	/**
	 * --Ϣ
	 * 
	 * ҪǵĻظʱ޸ĸ۵ĸ۵״̬
	 * @access private 
	 * @param array $data ۵Ϣ
	 * @return boolean ز봦Ľ
	 */
	function _addCommentReply($data) {
		$tempIntoComments = $this->_filterInsertData($data, 'reply2');
		if (!$tempIntoComments) return false;
		$tempDB = $this->_getCommentReplysDB();
		$tempDB->insert($tempIntoComments);
		if ($data['isanswer'] == 1) {
			$this->_commentContentsDB->changeState($data['parentid']);
		}
		return true;
	}
	
	/**
	 * --Ϣ
	 * 
	 * @access private
	 * @param array $data  ۵Ϣ
	 * @return boolean ز봦Ľ
	 */
	function _addRootComment($data) {
		$tempIntoComments = $this->_filterInsertData($data, 'reply1');
		if (!$tempIntoComments) return false;
		$tempDB = $this->_getCommentsDB();
		$tempDB->insert($tempIntoComments);	
		return true;
	}
	
	/**
	 * PW_Dianpu_CommentContentsDBʵ
	 * 
	 * @access private
	 * @return PW_Dianpu_CommentContentsDB 
	 */
	function _getCommentcontentsDB() {
		return DP::LoadDB('dianpu_commentcontents');
	}
	
	/**
	 * PW_Dianpu_CommentsDBʵ
	 * 
	 * @access private
	 * @return PW_Dianpu_CommentsDB 
	 */
	function _getCommentsDB() {
		return DP::LoadDB('dianpu_comments');
	}
	
	/**
	 * PW_Dianpu_CommentReplysDBʵ
	 * 
	 * @access private
	 * @return PW_Dianpu_CommentReplysDB 
	 */
	function _getCommentReplysDB() {
		return DP::LoadDB('dianpu_commentreplys');
	}	
}