<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * ̷Helperʵ
 * @author L.iuHu.I
 */
class PW_StyleHelper extends BaseHelper {
	
	/**
	 * ȫ̷б
	 * @return array
	 */
	function getStyles() {
		$styleService = $this->getStylesService();
		$styleLists = $styleService->getStyles();
		$styles = $this->getUnUserStyle();
		foreach ($styleLists as $list) {
			if (isset($styles[$list['filename']])) unset($styles[$list['filename']]);
		}
		$styles = (is_array($styles)) ? $styles : array();
		$styleLists = array_merge($styleLists, $styles);
		$result = array();
		foreach ($styleLists as $key => $list) {
			$list['state'] = $this->_checkStylePath($list['filename']);
			$result[$list['filename']] = $list;
		}
		ksort($result);
		return $result;
	}
	
	/**
	 * ӵ̷
	 * @param array $fieldDatas
	 * @return boolean
	 */
	function addStyles($fieldDatas) {
		$styleService = $this->getStylesService();
		return $styleService->addStyles($fieldDatas);
	}
	
	/**
	 * ༭̷
	 * @param array $newstyles
	 * @param array $styles
	 * @return boolean
	 */
	function operateStyles($newstyles, $styles) {
		list($filenames, $titles) = array($newstyles['filename'], $newstyles['title']);
		$styleService = $this->getStylesService();
		if (S::isArray($styles)) {
			foreach ($styles as $styleId => $v) {
				$v['title'] = $v['title'] ? $v['title'] : $v['filename'];
				$styleService->updateStyle(array('title' => $v['title']), $styleId);
			}
		}
		return true;
	}
	
	/**
	 * ûδӵеķб
	 * @return array
	 */
	function getUnUserStyle() {
		$styles = $this->getStylesDirectory();
		if (!$styles) return array();
		$tmp = array();
		foreach ($styles as $style) {
			$t = array();
			$t['styleid'] = 0;
			$t['title'] = $style;
			$t['filename'] = $style;
			$tmp[$style] = $t;
		}
		return $tmp;
	}
	
	/**
	 * ݷɾ
	 * @param string $filename
	 * @return array 
	 */
	function deleteStyle($filename) {
		$styleService = $this->getStylesService();
		$style = $styleService->getStyleByFilename($filename);
		if ($style && !$styleService->deleteStyle($style['styleid'])) {return array(false, 'ʧ');}
		$styleDirectory = $this->_getStylePath() . '/' . $filename;
		if (is_dir($styleDirectory)) {
			@rmdir($styleDirectory);
		}
		return array(false, 'ɹ');
	}
	
	/**
	 * ͣõ̷̷
	 * @param string $filename
	 * @return boolean
	 */
	function stopStyle($filename) {
		if (!$filename) return $this->_addError('Ƿ');
		$styleService = $this->getStylesService();
		$style = $styleService->getStyleByFilename($filename);
		if ($style && !$styleService->deleteStyle($style['styleid'])) return $this->_addError('ͣòʧ');
		return true;
	}
	
	/**
	 * õ̷
	 * @param string $filename
	 * @return boolean
	 */
	function startStyle($filename, $title) {
		if (!$filename) return $this->_addError('Ƿ');
		$fieldDatas = array(array('title' => $title, 'filename' => $filename));
		$styleService = $this->getStylesService();
		return $styleService->addStyles($fieldDatas);
	}
	
	/**
	 * ӷļĿ¼лзʽ
	 * @return array
	 */
	function getStylesDirectory() {
		$stylePath = $this->_getStylePath();
		$dirs = array();
		if (!is_dir($stylePath)) {return array();}
		$dh = opendir($stylePath);
		if (!$dh) return array();
		while (($file = readdir($dh)) !== false) {
			if ($file == '.' || $file == '..' || strpos($file, '.') === 0) continue;
			$dirs[] = $file;
		}
		closedir($dh);
		return $dirs;
	}
	
	/**
	 * ·ĺϷ
	 * @param string $filename
	 * @return string
	 */
	function _checkStylePath($filename) {
		$stylePath = $this->_getStylePath() . '/' . $filename;
		if (!is_dir($stylePath)) return 'Ŀ¼';
		if (!is_dir($stylePath . '/images')) return '/images';
		if (!file_exists($stylePath . '/images/style.css')) return 'style.css';
		return '';
	}
	
	/**
	 * ÷ļ·
	 * @return string
	 */
	function _getStylePath() {
		return MODE . '/themes';
	}
}