<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * ҵHelperʵ
 * @author L.iuHu.I
 */
class PW_CategoriesHelper extends BaseHelper {
	
	/**
	 * ҵͷ
	 * @param array $oldCategories ҪµĴ/С
	 * @param array $newParents Ĵ
	 * @param array $newChildren С
	 * @return boolean ز
	 */
	function addCategories($oldCategories, $newParents, $newChildren) {
		$categoriesService = $this->getCategoriesService();
		list($sorts, $names) = array($newParents['sort'], $newParents['name']);
		if (!S::isArray($sorts)) $sorts = array();
		if (!S::isArray($names)) $names = array();
		$tmp = array();
		foreach ($names as $key => $name) {
			if ($name) $tmp[] = array('name' => $name, 'sort' => intval($sorts[$key]));
		}
		$categoriesService->addCategories($tmp);
		
		if (!S::isArray($newChildren)) $newChildren = array();
		$fields = array();
		foreach ($newChildren as $parentId => $childs) {
			list($sorts, $names) = array($childs['sort'], $childs['name']);
			foreach ($names as $key => $name) {
				if ($name) $fields[] = array('parentid' => $parentId, 'name' => $name, 
					'sort' => intval($sorts[$key]));
			}
		}
		$categoriesService->addCategories($fields);
		
		foreach ($oldCategories as $categoryId => $category) {
			$categoryId = intval($categoryId);
			if ($categoryId < 1) continue;
			if ($category['name']) $categoriesService->updateCategory(array('sort' => intval($category['sort']), 
				'name' => $category['name']), $categoryId);
		}
		Error::addError('ɹ');
		return true;
	}
	
	/**
	 * ҵȡ
	 * @param integer $parentId ҵID
	 * @return boolean (false:ȡʧ) | array ҵ
	 */
	function getCategoriesByParentId($parentId) {
		list($categories) = $this->getCategories();
		if (!$categories) return false;
		return isset($categories[$parentId]) ? $categories[$parentId] : false;
	}
	
	/**
	 * ȡȫҵ
	 * @return array
	 */
	function getCategories() {
		$categoriesService = $this->getCategoriesService();
		$categories = $categoriesService->getCategories();
		return $this->_buildCategories($categories);
	}
	
	/**
	 * ȡȫҵ޻
	 * @return array 
	 */
	function getCategoriesNoCache() {
		$categoriesService = $this->getCategoriesService();
		$categories = $categoriesService->getCategoriesNoCache();
		return $this->_buildCategories($categories);
	}
	
	/**
	 * װȫҵ
	 * @param array $categories
	 * @return boolean (false:ʧ) | array 
	 */
	function _buildCategories($categories) {
		if (!$categories) return false;
		$parent = array();
		foreach ($categories as $key => $category) {
			if ($category['parentid'] <= 0) continue;
			$parent[$category['parentid']][] = $category;
			unset($categories[$key]);
		}
		$tmp = array();
		foreach ($categories as $category) {
			if ($parent[$category['categoryid']]) $category['children'] = $parent[$category['categoryid']];
			$tmp[$category['categoryid']] = $category;
		}
		return array($tmp, $categories);
	}
	
	/**
	 * ȡĳϢ
	 * @param integer $categoryId ID
	 * @return mixed integer (0:ʧ) | array طϢ
	 */
	function getCategory($categoryId) {
		$categoryId = intval($categoryId);
		if ($categoryId < 1) return 0;
		$categoriesService = $this->getCategoriesService();
		return $categoriesService->getCategory($categoryId);
	
	}
	
	/**
	 * ȡҵ
	 * @return mixed boolean (false:ʧ) | array ҵϢ
	 */
	function getParentCategories() {
		list($allCategories, $parentCategories) = $this->getCategories();
		if (!$parentCategories) return false;
		return $parentCategories;
	}
	
	/**
	 * ҵȡĬϷ
	 * @return mixed integer (0:ʧ) | array طϢ
	 */
	function getDefaultParentCategory() {
		$categories = $this->getParentCategories();
		if (!$categories) return 0;
		$tmp = array();
		foreach ($categories as $c) {
			$tmp[] = $c['categoryid'];
		}
		return $tmp[0];
	}
	
	/**
	 * ȡҵѡ
	 * @param string $select Ĭѡе
	 * @return string ҵ
	 */
	function getParentOption($select) {
		$parentCategories = $this->getParentCategories();
		if (!$parentCategories) return '';
		$tmp = array();
		foreach ($parentCategories as $c) {
			$tmp[$c['categoryid']] = $c['name'];
		}
		return $this->_buildOption($tmp, $select);
	}
	
	/**
	 * ȡѡ
	 * @param integer $parentId ҵID
	 * @param string $select Ĭѡеķ
	 * @return string ط
	 */
	function getChildOption($parentId, $select) {
		$childCategories = $this->getCategoriesByParentId($parentId);
		if (!S::isArray($childCategories['children'])) return '';
		$tmp = array();
		foreach ($childCategories['children'] as $c) {
			$tmp[$c['categoryid']] = $c['name'];
		}
		return $this->_buildOption($tmp, $select);
	}
	
	/**
	 * ƶ
	 * @param $source
	 * @param $target
	 * @param $sourcechild
	 * @param $targetchild
	 * @return array array(boolean, string) ƶ
	 */
	function moveCategory($source, $target, $sourcechild, $targetchild) {
		if ($source == $target) return array(false, 'ѡͬҵ');
		$source = intval($source);
		$target = intval($target);
		$sourcechild = intval($sourcechild);
		$targetchild = intval($targetchild);
		if ($source < 1 || $target < 1 || $sourcechild < 1 || $targetchild < 1) return array(false, '');
		$categoriesService = $this->getCategoriesService();
		if (!$categoriesService->moveCategory(array('parentid' => $target), $sourcechild)) return array(false, 'ʧ');
		$dianpuService = $this->getDianpuService();
		$dianpuService->moveDianpuCategory(array('parentid' => $target, 'categoryid' => $sourcechild));
		return array(true, 'ɹ');
	}
	
	/**
	 * ɾҵ
	 * @param integer $categoryId ҵID
	 * @return array  array(boolean , string) ز
	 */
	function deleteCategory($categoryId) {
		$categoryId = intval($categoryId);
		if ($categoryId < 1) return array(false, '');
		$categoriesService = $this->getCategoriesService();
		$_tmp = $categoriesService->getCategoriesByParentId($categoryId);
		if ($_tmp) return array(false, 'ɾɾҵ');
		$dianpuService = $this->getDianpuService();
		$_tmp = $dianpuService->getDianpuCountByCategoryid($categoryId);
		if ($_tmp) return array(false, '÷ºеϢɾ');
		$_tmp = $categoriesService->deleteCategory($categoryId);
		if (!($_tmp)) return array(false, 'ɾʧ');
		return array(true, 'ɾɹ');
	}
	
	/*
	* װ
	* @param array $arrays ҪϢ
	* @param string $select ΪĬѡ
	* @param boolean $isEmpty Ƿʹȱʡֵ
	* @return string 
	*/
	function _buildOption($arrays, $select = '', $isEmpty = false) {
		if (!is_array($arrays)) return '';
		$html = '';
		($isEmpty == true) && $html .= '<option value="">ѡҵ</option>';
		foreach ($arrays as $k => $v) {
			$selected = ($select == $k && $select != null) ? 'selected="selected"' : "";
			$html .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
		}
		return $html;
	}
	
	/**
	 * ȡҵ
	 * @return array 
	 */
	function getParentAndChild() {
		$categoriesService = $this->getCategoriesService();
		return $categoriesService->getParentAndChild();
	}
	
	/**
	 * ݷϢͳƵ
	 * @return array
	 */
	function statDianpyCountByCategory() {
		$dianpuService = $this->getDianpuService();
		return $dianpuService->statDianpuByCategory();
	}

}