<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * Helperʵ
 * @author L.iuHu.I
 */
class PW_AreasHelper extends BaseHelper {
	
	/**
	 * ȫ
	 * @return array
	 */
	function getAreas() {
		$areaService = $this->getAreasService();
		return $areaService->getAreas();
	}
	
	/**
	 * ȡȫ򲻾
	 * @return array
	 */
	function getAreasNoCache() {
		$areaService = $this->getAreasService();
		return $areaService->getAreasNoCache();
	}
	
	/**
	 * 
	 * @param array $presence
	 * @param array $sort
	 * @param array $name
	 * @return boolean
	 */
	function addAreas($presence, $sort, $name) {
		$areaService = $this->getAreasService();
		if (!S::isArray($sort) || !S::isArray($name) || !S::isArray($presence)) return $this->_addError('Ƿ');
		$tmp = array();
		foreach ($sort as $k => $v) {
			($name[$k]) && $tmp[] = array('sort' => intval($v), 'name' => $name[$k]);
		}
		$areaService->addAreas($tmp);
		foreach ($presence as $areaId => $area) {
			$areaId = intval($areaId);
			$areaService->updateArea(array('sort' => intval($area['sort']), 'name' => trim($area['name'])), $areaId);
		}
		return true;
	}
	
	/**
	 * IDɾһ
	 * @param int $areaId
	 * @return boolean
	 */
	function deleteArea($areaId) {
		$areaId = intval($areaId);
		if ($areaId < 1) return $this->_addError('Ƿ');
		$dianpuService = $this->getDianpuService();
		if (count($dianpuService->search(array('areaid' => array($areaId, 'eq')), 0, 1))) return $this->_addError('õѾڵ̣ɾ');
		$areaService = $this->getAreasService();
		if (!$areaService->deleteArea($areaId)) return $this->_addError('ɾʧ');
		return true;
	}
}