<?php
!defined('P_W') && exit('Forbidden');
/**
 * ̷DBʵ
 * @author L.iuHu.I
 */
class PW_Dianpu_StylesDB extends BaseDB {
	var $_tableName = 'pw_dianpu_styles';
	var $_primaryKey = 'styleid';
	
	/**
	 * ӵ̷
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * ݵIDµ̷
	 * @param array $fieldData
	 * @param int $id
	 * @return int
	 */
	function update($fieldData, $id) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * ݵ̷IDɾ̷
	 * @param int $id
	 * @return int
	 */
	function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * ݵ̷IDһ̷
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * õ̷б
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * õ̷б
	 * @return array
	 */
	function gets() {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵ̷IDõ̷б
	 * @param array $ids
	 * @return array
	 */
	function getsByIds($ids) {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE styleid in(" . $this->_getImplodeString($ids) . ")");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ӵ̷
	 * @param array $fieldDatas
	 * @return int
	 */
	function addStyles($fieldDatas) {
		$this->_db->update("INSERT INTO " . $this->_tableName . " (title,filename,createdtime) VALUES  " . pwSqlMulti($fieldDatas, FALSE));
		return $this->_db->insert_id();
	}
	
	/**
	 * ļƻõ̷
	 * @param string $filename
	 * @return array
	 */
	function getByFileName($filename) {
		$filename = trim($filename);
		return $this->_db->get_one("SELECT * FROM " . $this->_tableName . " WHERE filename=" . $this->_addSlashes($filename));
	}
	
	/**
	 * õ̷ݱṹ
	 * @return array 
	 */
	function getStruct() {
		return array('styleid', 'title', 'filename', 'status', 'createdtime');
	}
}