<?php
!defined('P_W') && exit('Forbidden');
/**
 * ̼ҵƷDAO
 * @author L.IuHu.I @2010/8/24
 */
class PW_Dianpu_ProductsDB extends BaseDB {
	var $_tableName = 'pw_dianpu_products';
	var $_dianpuTableName = 'pw_dianpu_dianpuindex';
	var $_primaryKey = 'productid';
	
	/**
	 * ӲƷ
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData,$this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * ƷIDƷ
	 * @param array $fieldData
	 * @param int $id
	 * @param int $objectId
	 * @return boolean
	 */
	function update($fieldData, $id, $objectId) {
		$fieldData = $this->_checkAllowField($fieldData,$this->getStruct());
		$id = intval($id);
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($fieldData) || $id < 1) {return false;}
		$this->_db->update("UPDATE " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid = " . $this->_addSlashes($id));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ƷIDɾƷ
	 * @param int $id
	 * @param int $objectId
	 * @return boolean
	 */
	function delete($id, $objectId) {
		$id = intval($id);
		$objectId = intval($objectId);
		if ($objectId < 1 || $id < 1) {return false;}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid = " . $this->_addSlashes($id));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ƷIDһƷ
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * Ʒб
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * ĳһҳƷб
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function gets($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ƷIDƷб
	 * @param array $ids
	 * @return Array
	 */
	function getsByIds($ids) {
		if (!is_array($ids)) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE productid IN( " . $this->_getImplodeString($ids) . ") ");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵIDøõ̷ҳȡƷб
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectId($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵIDȡƷ
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectId($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid));
		return $result['total'];
	}
	
	/**
	 * ݵƷҳб
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByProductWithHits($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) return false;
		$query = $this->_db->query("SELECT p.* FROM " . $this->_tableName . " p LEFT JOIN " . $this->_dianpuTableName . " d ON d.dianpuid=p.objectid WHERE d.state = 1 AND d.ifcheck = 1 AND  p.shelf = 1  ORDER BY p.hits DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵIDҳȡϼƷб
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectIdWithShelf($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND shelf = 1  ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵIDȡ̼Ʒ
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectIdWithShelf($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND shelf = 1  ");
		return $result['total'];
	}
	
	/**
	 * ݵIDҳȡƼƷб
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectIdWithRecommend($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND recommend = 1 AND shelf = 1 ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵIDȡƼƷ
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectIdWithRecommend($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND recommend = 1  AND shelf = 1 ");
		return $result['total'];
	}
	
	/**
	 * ҳȡѾϼܲƼƷб
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsWithRecommend($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE  recommend = 1 AND shelf = 1 ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ϼܲƼƷ
	 * @return int
	 */
	function countWithRecommend() {
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE  recommend = 1  AND shelf = 1 ");
		return $result['total'];
	}
	
	/**
	 * ƷIDƷϢ
	 * @param array $fieldData
	 * @param array $productIds
	 * @param int $objectId
	 * @return array
	 */
	function updates($fieldData, $productIds, $objectId) {
		$fieldData = $this->_checkAllowField($fieldData,$this->getStruct());
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($fieldData) || !is_array($productIds)) {return false;}
		$this->_db->update("UPDATE " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid IN (" . $this->_getImplodeString($productIds) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * ƷIDɾƷ
	 * @param array $productIds
	 * @param int $objectId
	 * @return int
	 */
	function deletes($productIds, $objectId) {
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($productIds)) {return false;}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid IN (" . $this->_getImplodeString($productIds) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * ƷIDɾƷ
	 * @param array $productIds
	 * @return int
	 */
	function deletesForAdmin($productIds) {
		if (!is_array($productIds)) {return false;}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE productid IN (" . $this->_getImplodeString($productIds) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * ƷҳƷϢ
	 * @param string $keyword
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function searchProductsByTitle($keyword, $start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($keyword == '' || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%") . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ƷüƷ
	 * @param string $keyword
	 * @return int
	 */
	function countProductsByTitle($keyword) {
		if ($keyword == '') {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%"));
		return $result['total'];
	}
	
	/**
	 * ݵIDҳȡƷ
	 * @param int $objectIds
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectIds($objectIds, $start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1 || !is_array($objectIds)) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid IN( " . $this->_getImplodeString($objectIds) . ") ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݵIDȡƷ
	 * @param array $objectIds
	 * @return int
	 */
	function countByObjectIds($objectIds) {
		if (!is_array($objectIds)) {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid IN( " . $this->_getImplodeString($objectIds) . ")");
		return $result['total'];
	}
	
	/**
	 * Ʒ¼ԼƷҳƷ
	 * @param int $objectid
	 * @param string $keyword
	 * @param array $shelfs
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function searchByShelfAndTitle($objectid, $keyword, $shelfs, $start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		$objectid = intval($objectid);
		if ($objectid < 1 || $keyword == '' || $offset < 1 || !is_array($shelfs)) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%") . " AND shelf IN (" . $this->_getImplodeString($shelfs) . ") AND objectid = " . $this->_addSlashes($objectid) . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * øƷ¼ѾƷ
	 * @param int $objectid
	 * @param string $keyword
	 * @param array $shelfs
	 * @return int
	 */
	function countByShelfAndTitle($objectid, $keyword, $shelfs) {
		$objectid = intval($objectid);
		if ($objectid < 1 || $keyword == '' || !is_array($shelfs)) {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%") . " AND shelf IN (" . $this->_getImplodeString($shelfs) . ") AND objectid = " . $this->_addSlashes($objectid));
		return $result['total'];
	}
	
	/**
	 * Ʒ¼ҳƷб
	 * @param int $objectid
	 * @param array $shelfs
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function searchByShelf($objectid, $shelfs, $start, $offset) {
		$objectid = intval($objectid);
		if (!is_array($shelfs) || $objectid < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE shelf IN (" . $this->_getImplodeString($shelfs) . ") AND objectid = " . $this->_addSlashes($objectid) . "  ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * øƷ¼Ʒ
	 * @param int $objectId
	 * @param array $shelfs
	 * @return int
	 */
	function countByObjectIdAndShelfs($objectId, $shelfs) {
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($shelfs)) {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectId) . " AND shelf IN (" . $this->_getImplodeString($shelfs) . ")");
		return $result['total'];
	}
	
	/**
	 * ݵIDȡһƷϢ
	 * @param array $objectIds
	 * @return array
	 */
	function getsByRand($objectIds) {
		if (!is_array($objectIds)) return false;
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid in(" . $this->_getImplodeString($objectIds) . ") AND shelf = 1 AND recommend = 1 ORDER BY rand() DESC LIMIT 3");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * Ʒݽṹ
	 * @return array
	 */
	function getStruct() {
		return array('productid', 'objectid', 'title', 'description', 'recommend', 'market_price', 'member_price', 
			'shelf', 'photoid', 'createdtime', 'modifiedtime', 'hits');
	}

}