<?php
!defined('P_W') && exit('Forbidden');
/**
 * ƷͼƬDBʵ
 * @author liuh
 */
class PW_Dianpu_PhotosDB extends BaseDB {
	var $_tableName = 'pw_dianpu_photos';
	var $_primaryKey = 'photoid';
	
	/**
	 * ӵƷͼƬ
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * ƬIDµƷͼƬ
	 * @param array $fieldData
	 * @param int $id
	 * @return int
	 */
	function update($fieldData, $id) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * ƬIDɾƷͼƬ
	 * @param int $id
	 * @return int
	 */
	function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * ƬIDƷͼƬϢ
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * ƷͼƬ
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * ƷͼƬ
	 * @param array $fieldDatas
	 * @return int
	 */
	function addPhotos($fieldDatas) {
		$this->_db->update("INSERT INTO " . $this->_tableName . " (belongid,objectid,typeid,filename,path,createdtime) VALUES  " . pwSqlMulti($fieldDatas, FALSE));
		return $this->_db->insert_id();
	}
	
	/**
	 * ƷͼƬIDƷIDɾƷͼƬ
	 * @param int $photoId
	 * @param int $belongId
	 * @return int
	 */
	function deleteByPhotoIdAndBelongId($photoId, $belongId) {
		$photoId = intval($photoId);
		$belongId = intval($belongId);
		if ($photoId < 1 || $belongId < 1) {
			return false;
		}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE photoid= " . $this->_addSlashes($photoId) . " AND belongid = " . $this->_addSlashes($belongId));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ƷIDƷͼƬID
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return Array
	 */
	function getsByObjectId($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {
			return false;
		}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ͼƬIDȡƷͼƬϢ
	 * @param array $photoIds
	 * @return array
	 */
	function getPhotosByIds($photoIds) {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE photoid IN ( " . $this->_getImplodeString($photoIds) . " )");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ƷIDõǰƷϴͼƬ
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectId($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid));
		return $result['total'];
	}
	
	/**
	 * õƷͼƬݽṹϢ
	 * @return array()
	 */
	function getStruct() {
		return array('photoid', 'objectid', 'belongid', 'typeid', 'filename', 'path', 'createdtime');
	}

}