<?php
!defined('M_P') && exit('Forbidden');
/**
 * û۶ۻظDBʵ
 * @author xiaoxia.xuxx
 */
class PW_Dianpu_CommentReplysDB extends BaseDB {
	var $_tableName = 'pw_dianpu_commentreplys';
	var $_primaryKey = 'commentid';
	
	/**
	 * ۵Ϣ
	 * @param array $fieldData Ϣ
	 * @return integer زID
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * Ӻ̨IDɾϢ
	 * @param array $commentid  ۵IDб
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delForAdmin($commentid) {
		if (!$commentid) return false;
		return $this->_delete($commentid);
	}
	
	/**
	 * Ӻ̨IDбɾϢ
	 * (Ŀǰֻʵֵļɾ)
	 * @param array $commentid IDб
	 * @return integer ɾӰ¼
	 */
	function delsForAdmin($commentid) {
		if (!$commentid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$_sql = "DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ") OR parentid IN (" . $this->_getImplodeString($commentid) . ")";
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * ԱrootIDɾϢ
	 * @param integer $rootid ID
	 * @return integer ɾӰ¼
	 */
	function deletesByRootIDForAdmin($rootid) {
		if (!$rootid) return false;
		if (!S::isArray($rootid)) $rootid = array($rootid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE rootid IN (" . $this->_getImplodeString($rootid) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * ǰ̨ɾϢ,Ҫ뱻ɾڵĵϢɾID
	 * @param array $commentid  ۵IDб
	 * @param integer $objectid IDǶID
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delete($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid = " . $this->_addSlashes($commentid) . " AND objectid= " . $this->_addSlashes($objectid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ɾϢ  (Ŀǰֻʵֵļɾ),Ҫ뱻ɾڵĵIDɾIDб
	 * @param array $commentid IDб
	 * @param integer $objectid ID߶ID
	 * @return integer ɾӰ¼
	 */
	function deletes($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$_sql = "DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ") OR parentid IN (" . $this->_getImplodeString($commentid) . ") AND objectid=" . $this->_addSlashes($objectid);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * ǰ̨rootIDɾϢ,Ҫ뱻ɾڵĵϢID
	 * @param integer $rootid ID
	 * @param integer $objectid ID (ǶID
	 * @return integer ɾӰ¼
	 */
	function deletesByRootID($rootid, $objectid) {
		if (!$rootid || !$objectid) return false;
		if (!S::isArray($rootid)) $rootid = array($rootid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE rootid IN (" . $this->_getImplodeString($rootid) . ") AND objectid=" . $this->_addSlashes($objectid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ͨIDø۵ĸID
	 * @param integer $commentid ID
	 * @return array array('rootid) ظID
	 */
	function getRootidByCommentid($commentid) {
		if (!$commentid) return false;
		return $this->_db->get_one("SELECT rootid FROM " . $this->_tableName . ' WHERE commentid = ' . $this->_addSlashes($commentid));
	}
	
	/**
	 * ݸID͸IDеӼID
	 * Ϊȫɾ伶µۣҪȲҳصID
	 * ˴ΪȷбɾIDиIDб
	 * @param integer $rootid ۵ID
	 * @param integer $parentid ۵ID
	 * @return mixed boolean (false:ʧ) | array array(array(commentid,parentid),array(commentid,parentid),...) طID
	 */
	function getCommentidByRootid($rootid, $parentid = 0) {
		if (!$rootid) return false;
		$_where = '';
		if (intval($parentid) != 0) $_where .= ' AND parentid = ' . $this->_addSlashes($parentid);
		$query = $this->_db->query("SELECT commentid,parentid FROM " . $this->_tableName . ' WHERE rootid IN ( ' . $this->_getImplodeString($rootid) . ')' . $_where);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݸIDøøµӼ
	 * ɾ۵ʱ۵IDݸID(۵ɾ
	 * @param integer $parentid
	 * @return mixed boolean (false: ʧ) | array array(array(commentid, rootid),array(commentid, rootid)...) طб
	 */
	function getCommentidByParentid($parentid) {
		if (!$parentid) return false;
		$query = $this->_db->query("SELECT commentid,rootid FROM " . $this->_tableName . ' WHERE parentid IN ( ' . $this->_getImplodeString($parentid) . ')');
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * õpw_dianpu_commentreplysݿṹ
	 * @return array ݿݽṹ
	 */
	function getStruct() {
		return array('commentid', 'parentid', 'rootid', 'postdate', 'objectid');
	}
}
?>