<?php
!defined('M_P') && exit('Forbidden');
/**
 * ̼ҵ-ûݱ
 * @author xiaoxia.xuxx@2010-09-20
 * 
 */
class PW_Dianpu_CommentContentsDB extends BaseDB {
	var $_tableName = "pw_dianpu_commentcontents";
	var $_commentReplysTable = 'pw_dianpu_commentreplys';
	var $_commentsTable = 'pw_dianpu_comments';
	var $_memebrsTable = 'pw_members';
	var $_primaryKey = 'commentid';
	
	/**
	 * 
	 * @param array $fieldData Ϣ
	 * @return integer زID
	 */
	function insert($fieldData) {
		$insertData = $this->_clearFieldData($fieldData);
		return $this->_insert($insertData);
	}
	
	/**
	 * 
	 * @param array $fieldData ۵Ҫµ
	 * @param integer $commentid ۵ID
	 * @return integer ظӰ
	 */
	function update($fieldData, $commentid) {
		$fieldData = $this->_clearFieldData($fieldData);
		return $this->_update($fieldData, $commentid);
	}
	
	/**
	 * ۵״̬
	 * @param integer $commentid Ҫ״̬ID
	 * @param integer $states Ҫĵ״̬0Ϊδظ,1Ϊѻظ
	 * @return integer Ӱ
	 */
	function changeState($commentid, $states = 1) {
		if (!$commentid) return false;
		$commentid = intval($commentid);
		$this->_db->update("UPDATE " . $this->_tableName . ' SET state = ' . $this->_addSlashes($states) . ' WHERE commentid = ' . $this->_addSlashes($commentid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * վ̨ɾһ
	 * @param array $commentid  ۵IDб
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delForAdmin($commentid) {
		if (!$commentid) return false;
		return $this->_delete($commentid);
	}
	
	/**
	 * վ̨ɾ
	 * @param array $commentIDs IDб
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delsForAdmin($commentIDs) {
		if (!S::isArray($commentIDs)) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentIDs) . ") ");
		return $this->_db->affected_rows();
	}
	
	/**
	 * ǰִ̨ɾһۣҪжϵ̣ID
	 * @param array $commentid  ۵IDб
	 * @param integer $objectid  ۶Ӧĵ̣󣩵ID
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delete($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid = " . $this->_addSlashes($commentid) . " AND objectid= " . $this->_addSlashes($objectid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ǰ̨ɾۣҪжϵ̣ID
	 * @param array $commentIDs IDб
	 * @param integer $objectid ɾӦĵ̣߶󣩵ID
	 * @return integer ɾӰ쵽ļ¼
	 */
	function deletes($commentIDs, $objectid) {
		if (!S::isArray($commentIDs) || !$objectid) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentIDs) . ") AND objectid= " . $this->_addSlashes($objectid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * ɾһ̵ɾһƷʱҪͬʱɾ̵Ʒµ
	 * @param integer $objectid ̵ID
	 * @param integer $typeid ƷID
	 * @return integer Ӱ
	 */
	function deleteByObject($objectid, $typeid = 0) {
		if (!$objectid) return false;
		$_where = '';
		if (intval($typeid) != 0) $_where .= ' AND typeid = ' . $this->_addSlashes($typeid);
		$this->_db->update("DELETE commentid FROM " . $this->_tableName . ' WHERE objectid = ' . $this->_addSlashes($objectid) . $_where);
		return $this->_db->affected_rows();
	}
	
	/**
	 * (̨)
	 * @param array $paramsкеĲ
	 * array('content' => '',  
	 * 'username' => '۷',  
	 * 'startdate' => 'ѯ۵Ŀʼʱ ', 
	 * 'enddate' => 'ѯ۵Ľʱ' ,
	 * 'isanswer' = > 'Ƿǻظ1ǻظ',
	 * 'state' => 'ǷѾظ1ΪѾظ',
	 * 'objectid' => 'ɸѡбĵ̣Ƕ󣩵ID',
	 * 'typeid' => 'ɸѡбƷID',
	 * )
	 * @param integer $start ѯҳĿʼλ
	 * @param integer $perpage ѯÿҳʾ
	 * @return array array(array(),array()...) زѯĽ
	 */
	function search($params, $start = 0, $perpage = 20) {
		$_where = $this->_filterCondition($params);
		$order = ' ORDER BY postdate DESC , commentid';
		$limit = $this->_Limit($start, $perpage);
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE 1 " . $_where . $order . $limit);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * õ۵
	 * @param array $params ӦҪѯɸѡ
	 * array('content' => '',  
	 * 'username' => '۷',  
	 * 'startdate' => 'ѯ۵Ŀʼʱ ', 
	 * 'enddate' => 'ѯ۵Ľʱ' ,
	 * 'isanswer' = > 'Ƿǻظ1ǻظ',
	 * 'state' => 'ǷѾظ1ΪѾظ',
	 * 'objectid' => 'ɸѡбĵ̣Ƕ󣩵ID',
	 * 'typeid' => 'ɸѡбƷID',
	 * )
	 * @return integer ۵
	 */
	function count($params) {
		$_where = $this->_filterCondition($params);
		$rt = $this->_db->get_one("SELECT COUNT(*) AS count FROM " . $this->_tableName . " WHERE 1 " . $_where);
		return $rt['count'];
	}
	
	/**
	 * ɸѡй˲װwhereѯ
	 * @param array $params ɸѡ
	 * array('content' => '',  
	 * 'username' => '۷',  
	 * 'startdate' => 'ѯ۵Ŀʼʱ ', 
	 * 'enddate' => 'ѯ۵Ľʱ' ,
	 * 'isanswer' = > 'Ƿǻظ1ǻظ',
	 * 'state' => 'ǷѾظ1ΪѾظ',
	 * 'objectid' => 'ɸѡбĵ̣Ƕ󣩵ID',
	 * 'typeid' => 'ɸѡбƷID',
	 * )
	 * @return  string װsqlѯ
	 */
	function _filterCondition($params) {
		$_where = '';
		if (!is_array($params)) $params = array($params);
		if (isset($params['isanswer']) && is_numeric($params['isanswer'])) $_where = ' AND isanswer = ' . $this->_addSlashes(intval($params['isanswer']));
		if (!empty($params['content'])) $_where .= " AND content LIKE " . $this->_addSlashes('%' . $params['content'] . '%');
		if (!empty($params['username'])) $_where .= " AND username LIKE " . $this->_addSlashes('%' . $params['username'] . '%');
		if (!empty($params['startdate'])) {
			$startdate = strtotime(trim($params['startdate'] . ' 00:00:00'));
			$_where .= ' AND postdate >= ' . $this->_addSlashes($startdate);
		}
		if (!empty($params['enddate'])) {
			$enddate = strtotime(trim($params['enddate']) . ' 23:59:59');
			$_where .= ' AND postdate <= ' . $this->_addSlashes($enddate);
		}
		if (in_array($params['state'], array('y', 'n'))) {
			$_temp = array('y' => '1', 'n' => '0');
			$_where .= ' AND state = ' . $this->_addSlashes($_temp[$params['state']]);
		}
		if ($params['objectid']) $_where .= ' AND objectid = ' . $this->_addSlashes(intval($params['objectid']));
		if ($params['typeid']) $_where .= ' AND typeid = ' . $this->_addSlashes(intval($params['typeid']));
		return $_where;
	}
	
	/**
	 * ݵIDƷIDøиcommentID
	 * @param integer $objectid IDǶIDҪ۵Դ
	 * @param integer $typeid ƷID  ----Ʒҳϵбʵ
	 * @param integer $start  ʼļ¼λãڷҳ
	 * @param integer $perpage Ҫļ¼ڷҳ
	 * @return array array(array(),array()...)  б
	 */
	function getRootidByObject($objectid, $typeid = 0, $start = 0, $perpage = 0) {
		if (!$objectid) return array();
		$_where = '';
		if (intval($typeid) != 0) $_where .= ' AND typeid = ' . $this->_addSlashes(intval($typeid));
		$_limit = $this->_Limit($start, $perpage);
		$_order = " ORDER BY postdate DESC";
		$_result = $this->_db->query("SELECT commentid FROM " . $this->_commentsTable . ' WHERE objectid = ' . $this->_addSlashes($objectid) . $_where . $_order . $_limit);
		return $this->_getAllResultFromQuery($_result);
	}
	
	/**
	 * ݵIDƷIDøи۵
	 * @param integer $objectid IDǶIDҪ۵Դ
	 * @param integer $typeid ƷID  ----Ʒҳϵбʵ
	 * @return integer ط
	 */
	function getFrontCount($objectid, $typeid) {
		if (!$objectid) return array();
		$_where = '';
		if (intval($typeid) != 0) $_where .= ' AND typeid = ' . $this->_addSlashes(intval($typeid));
		$rt = $this->_db->get_one("SELECT COUNT(*) AS count FROM " . $this->_commentsTable . ' WHERE objectid = ' . $this->_addSlashes($objectid) . $_where);
		return $rt['count'];
	}
	
	/**
	 * IDб۵Ϣбʱ䵹 ۵ϸϢ
	 * @param array $ids IDб
	 * @return array array('commentid1' => array(), 'commentid2' => array()....) ظIDϸϢ
	 */
	function getFrontCommentsInfoList($ids) {
		if (empty($ids)) return array();
		$sql = "SELECT cn.*, re.parentid as parentid, re.rootid as rootid, m.icon as icon " . "FROM " . $this->_tableName . ' cn ' . 'LEFT JOIN ' . $this->_commentReplysTable . ' re ON cn.commentid = re.commentid  ' . 'LEFT JOIN ' . $this->_memebrsTable . ' m ON m.uid = cn.uid ' . 'WHERE cn.commentid IN (' . $this->_getImplodeString($ids) . ') ORDER BY postdate DESC';
		$result = $this->_db->query($sql);
		return $this->_getAllResultFromQuery($result, 'commentid');
	}
	
	/**
	 * ۵IDбȡ۵ӼϸϢʱ
	 * @param array $rootIds ҪȡӼ۵ĸID
	 * @return array array(array(),array()...) ظøĿ¼µӼ۵Ϣ
	 */
	function getChildCommentInfoList($rootIds) {
		if (!S::isArray($rootIds)) return array();
		$sql = "SELECT cn.*, re.parentid as parentid, re.rootid as rootid, m.icon as icon " . "FROM " . $this->_tableName . ' cn ' . 'LEFT JOIN ' . $this->_commentReplysTable . ' re ON cn.commentid = re.commentid ' . 'LEFT JOIN ' . $this->_memebrsTable . ' m ON m.uid = cn.uid ' . 'WHERE re.rootid IN (' . $this->_getImplodeString($rootIds) . ')' . ' ORDER BY cn.postdate ASC';
		return $this->_getAllResultFromQuery($this->_db->query($sql));
	}
	
	/**
	 * ݶIDƷIDøеĵظ(ʱ)
	 * keyֵparentid
	 * @param int $objectid ID
	 * @param int $typeid ƷID
	 * @param int $start ʼλ
	 * @param int $perpage ѯ
	 * @return array  array(array(),array()...) ظøĿ¼µлظ۵۵Ϣ
	 */
	function getReplyCommentList($objectid, $typeid = 0) {
		if (!$objectid) return array();
		$_where = '';
		if (intval($typeid) != 0) $_where .= ' AND typeid = ' . $this->_addSlashes(intval($typeid));
		$_order = " ORDER BY postdate ASC";
		$_sql = "SELECT cn.*, re.parentid as parentid, re.rootid as rootid, m.icon as icon " . "FROM " . $this->_tableName . ' cn ' . 'LEFT JOIN ' . $this->_commentReplysTable . ' re ON cn.commentid = re.commentid ' . 'LEFT JOIN ' . $this->_memebrsTable . ' m ON m.uid = cn.uid ' . 'WHERE cn.isanswer = 1 AND re.parentid != 0 AND cn.objectid = ' . $this->_addSlashes($objectid) . $_where . $_order;
		$_result = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($_result);
	}
	
	/**
	 * ݺϷ
	 * @param array $fieldData 
	 * @return array طϵݼ
	 */
	function _clearFieldData($fieldData) {
		$clearData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $clearData;
	}
	
	/**
	 * ȡ pw_dianpu_commentcontentsݿṹ
	 * @return array ݿݽṹ
	 */
	function getStruct() {
		return array('commentid', 'title', 'content', 'objectid', 'typeid', 'uid', 'username', 'postdate', 'isanswer', 
			'state');
	}
}