<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/frontcontroller.php';
class manageController extends FrontController {
	var $_dianpu;
	var $_baseName;
	
	function _before(){
		parent::_before();
		$this->_dianpuHelper = DP::loadClass('dianpuhelper', 'helper');
		$this->_getDianpu();
		$this->_checkLevel();
		$this->_viewer->dianpuinfo = $this->_dianpu;
		$this->_viewer->baseName = BASEURL;
		$this->_viewer->title = $this->_dianpu->title;
		$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
		$this->_viewer->mode = $this->_getGlobal('db_mode');
		$this->_viewer->siteName = $this->_getGlobal($this->_viewer->mode.'_sitename');
		setDianpuStyle($this->_controller);
		return true; 
	}
	
	function _checkLevel(){
		if(!$this->_isAdmin()){
			Error::showError('ûȨ');
		}
	}
	
	/**
	 * @return PW_DianpuModule
	 */
	function _getDianpu(){
		list($dianpuid,$username) = $this->_gp(array('dianpuid','u'));
		if ($dianpuid){
			$this->_viewer->dianpuid = $dianpuid;
			if (!$dianpu = $this->_dianpuHelper->getDianpuInfo($dianpuid)){Error::checkError(1);} 
		} elseif ($username) {
			if (!$dianpu = $this->_dianpuHelper->getDianpuInfoByUser($username)){Error::checkError(1);} 
		} else {
			if (!$dianpu = $this->_dianpuHelper->getDianpuInfoByUser()){Error::checkError(1);}
		}
		if (!$dianpu) Error::showError('ȡϢʧ');
		if (!$dianpu->state) Error::showError('õδͨʧ');
		if (!$dianpu->ifcheck) Error::showError('õδͨʧ');
		$this->_dianpu = $dianpu;
		dianpuSeoSettings('index','','̹',$dianpu->title);
	}
	
	function _isAdmin(){
		return ($this->_getGlobal('groupid') == 3 || $this->_dianpu->username == $this->_getGlobal('windid'));
	}

}