<?php
!defined('P_W') && exit('Forbidden');
require_once R_P . 'lib/framework/helper.php';

/**
 * @author L.iuHu.I
 */
class BaseHelper extends Helper {
	var $_message = array();
	
	/**
	 * @return PW_ProductsService
	 */
	function getProductService() {
		return DP::loadClass("ProductsService", "service");
	}
	
	/**
	 * @return PW_GroupService
	 */
	function getGroupsService() {
		return DP::loadClass("groupservice", "service");
	}
	
	/**
	 * @return PW_DianpuService
	 */
	function getDianpuService() {
		return DP::loadClass("dianpuservice", "service");
	}
	
	/**
	 * @return PW_CategoriesService
	 */
	function getCategoriesService() {
		return DP::loadClass("categoriesservice", "service");
	}
	
	/**
	 * @return PW_CommentService
	 */
	function getCommentService() {
		return DP::loadClass("commentservice", "service");
	}
	
	/**
	 * @return PW_AreasService
	 */
	function getAreasService() {
		return DP::loadClass("areasservice", "service");
	}
	
	/**
	 * @return PW_StylesService
	 */
	function getStylesService() {
		return DP::loadClass("stylesservice", "service");
	}
	
	/**
	 * @return PW_PhotosService
	 */
	function getPhotossService() {
		return DP::loadClass("photosservice", "service");
	}
	
	/**
	 * ֤pageĺϷ
	 * @param int $total
	 * @param int $page
	 * @param int $perpage
	 * @return int
	 */
	function _validePage($total, $page, $perpage) {
		$total = intval($total);
		$page = (intval($page) > 0) ? intval($page) : 1;
		$perpage = (intval($perpage) > 0) ? intval($perpage) : 20;
		$totalPage = ceil($total / $perpage);
		$page = ($page > $totalPage) ? $totalPage : $page;
		return $page;
	}
	
	/**
	 * URL
	 * @param string $action
	 * @return string
	 */
	function _buildAdminURL($action) {
		return $this->_getGlobal('basename') . '&action=' . $action;
	}
	
	/**
	 * ӴϢError
	 * @param string $message
	 * @return boolean
	 */
	function _addError($message) {
		Error::addError($message);
		$this->_message[] = $message;
		return false;
	}
	
	/**
	 * HelperгֵĴϢ
	 * @return array
	 */
	function getMessage() {
		return $this->_message;
	}

}