<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/dianpucontroller.php';

/**
 * ҳ Action Controller
 * @author yishuo
 * 2010-09-21
 */
class InfoController extends DianpuController {
	var $_perpage = 10;
	
	function _before() {
		parent::_before();
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		$this->_viewer->current['dianpu'] = 'current';
		return true;
	}
	
	/**
	 * ϸϢҳ
	 */
	function run() {
		list($contentid) = $this->_gp(array('contentid'));
		if (!$this->_dianpu) Error::showError($this->_getErrorMessage(1));
		$dianpuService = DP::loadClass('dianpuservice', 'service'); /* @var $dianpuService PW_DianpuService */
		$this->_viewer->dianpuinfo = $this->_dianpu;
		$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
		
		/* Ϣ */
		$this->_viewer->groupinfo = $this->_dianpu->group;
		
		/* ƼƷ */
		$productHelper = DP::loadClass('producthelper', 'helper'); /* @var $productService PW_ProductsService */
		$products = $productHelper->getProductsByObjectIdWithRecommend($this->_dianpu->dianpuid, 1, 30);
		$this->_viewer->products = $products;
		$this->_viewer->proCount = count($products);
		
		/* Ȩ޻ȡ */
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$this->_viewer->commentRight = $commentHelper->getRight($this->_dianpu->uid);
		
		/* ¼ */
		$dids = $this->getBrowse('dianpu', $this->_dianpu->dianpuid);
		$this->_viewer->browse = $dianpuService->getDianpuListByIds($dids, true);
		
		/* վ */
		$dianpuHitsService = DP::loadClass('dianpuhitsservice', 'service'); /* @var $dianpuHitsService pw_dianpuhitsservice */
		$dianpuHitsService->updateDianpuHits($this->_dianpu->dianpuid);
	}
	
	function content() {
		list($contentid) = $this->_gp(array('contentid'));
		if (!$this->_dianpu) Error::showError($this->_getErrorMessage(1));
		$dianpuService = DP::loadClass('dianpuservice', 'service'); 
		/* @var $dianpuService PW_DianpuService */
		$this->_viewer->dianpuinfo = $this->_dianpu;
		
		/* Ȩ޻ȡ */
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$this->_viewer->commentRight = $commentHelper->getRight($this->_dianpu->uid);
		
		/* ݻȡ  */
		$this->_viewer->tabs = $this->_dianpu->getPageTitles();
		if (!$contentid) {
			$contentid = array_keys($this->_viewer->tabs);
			$contentid = $contentid[0];
		}
		$contents = $dianpuService->getDianpuContent($contentid);
		$this->_viewer->contents = $this->_filterContent($contents['contents']);
		$this->_viewer->currentTab[$contentid] = 'current';
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * ̵绰ͼƬ
	 */
	function getphone() {
		list($phonenumber, $color) = $this->_gp(array('pn', 'color'));
		if (!$phonenumber || $phonenumber == '-') $phonenumber = '0000-00000000';
		header('Content-type: image/png');
		$font = M_P . 'images/fonts/Arial.ttf';
		$im = imagecreatetruecolor(120, 14);
		$white = imagecolorallocate($im, 255, 255, 255);
		$fontColor = imagecolorallocate($im, 0, 0, 0);
		if ($color == 'red') {
			$fontColor = imagecolorallocate($im, 255, 0, 0);
		}
		imagefilledrectangle($im, 0, 0, 399, 29, $white);
		imagettftext($im, 11, 0, 0, 11, $fontColor, $font, $phonenumber);
		imagepng($im);
		imagedestroy($im);
		exit();
	}
	
	/**
	 * б
	 * ajax
	 */
	function commentlist() {
		$this->_viewer->groupinfo = $this->_dianpu->group;
		if (!$this->_viewer->groupinfo['configinfo']['comments']) {
			echo 'õڵĵ鲻ṩ۹!';
		} else {
			list($productId) = $this->_gp(array('productid'));
			list($page) = $this->_gp(array('page'));
			(!$page) && $page = 1;
			$commentHelper = DP::loadClass('commenthelper', 'helper');
			list($count, $page, $totalpage, $rootList, $childList) = $commentHelper->getFrontCommentList($this->_dianpu->dianpuid, $productId, $page, 8);
			$url = $this->_viewer->baseName . '&c=info&a=commentlist&id=' . $this->_dianpu->dianpuid . '&productid=' . $productId;
			$this->_viewer->backurl = $this->_viewer->baseUrl . '&page=' . $page;
			$this->_viewer->pager = PW_CommentHelper::NumOfPage($count, $page, $totalpage, "$url&", null, "commentAjax.getComment");
			$this->_viewer->right = $commentHelper->getRight($this->_dianpu->uid);
			$this->_viewer->rootList = $rootList;
			$this->_viewer->childList = $childList;
			$this->_viewer->page = $page;
			$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
			$this->_viewer->productid = $productId;
			$this->_viewer->mode = $this->_getGlobal('m');
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * ظ
	 * Ȩ޼---  Ա   ͨԱ
	 * ûǷѾ¼
	 */
	function replycomment() {
		$temp = array();
		$temp['uid'] = $this->_getGlobal('winduid');
		list($temp['objectid']) = $this->_gp(array('id'));
		$_right = $this->_checkright($temp['uid'], $this->_dianpu->uid, $temp['objectid'], 'add', $this->_dianpu->group['configinfo']['comments']);
		if (S::isArray($_right)) {
			echo pwJsonEncode($_right);
		} else {
			$commentHelper = DP::loadClass('commenthelper', 'helper');
			list($page, $temp['typeid'], $temp['parentid'], $temp['rootid'], $temp['content'], $temp['title']) = $this->_gp(array(
				'page', 'productid', 'parentid', 'rootid', 'content', 'title'));
			$temp['username'] = $this->_getGlobal('windid');
			$temp['postdate'] = $this->_getGlobal('timestamp');
			($this->_dianpu->username == $temp['username'] && $temp['rootid']) ? $temp['isanswer'] = 1 : $temp['isanswer'] = 0;
			list($result['flag'], $result['message']) = $commentHelper->addComment($temp);
			($result['flag']) ? $result['flag'] = 'success' : $result['flag'] = 'error';
			$result['url'] = $this->_viewer->baseName . '&c=info&a=commentlist&page=' . $page . '&id=' . $temp['objectid'] . '&productid=' . $temp['typeid'];
			echo pwJsonEncode($result);
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * ɾ
	 */
	function delcomment() {
		$_winduid = $this->_getGlobal('winduid');
		list($commentid, $dianpuid, $productid) = $this->_gp(array('commentid', 'id', 'productid'));
		$_right = $this->_checkright($_winduid, $this->_dianpu->uid, $dianpuid, 'del', $this->_dianpu->group['configinfo']['comments'], $commentid);
		if (S::isArray($_right)) {
			echo pwJsonEncode($_right);
		} else {
			$commentHelper = DP::loadClass('commenthelper', 'helper');
			list($page) = $this->_gp(array('page'));
			list($result['flag'], $result['message']) = $commentHelper->deleteComment($commentid, $dianpuid);
			($result['flag']) ? $result['flag'] = 'success' : $result['flag'] = 'error';
			$result['url'] = $this->_viewer->baseName . '&c=info&a=commentlist&page=' . $page . '&id=' . $dianpuid . '&productid=' . $productid;
			echo pwJsonEncode($result);
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * жȨ
	 * @param $uid  ǰ¼ûID
	 * @param $dianpuUid  ǰ̵ĵID
	 * @param $dianpuid ̵IDǷд
	 * @param $commentid Ƿдcommentid  ----    delĲʱ
	 * @param $step   жǷȷĲԴ
	 * @param $flag Ȩ޵       'add' or 'del'
	 */
	function _checkright($uid, $dianpuUid, $dianpuid, $flag, $groupRight, $commentid = '') {
		list($step) = $this->_gp(array('step'));
		if (!$uid) return array('flag' => 'error', 'message' => 'ûе¼ȵ¼', 'login' => 'login.php'); //ûвȨ
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$right = $commentHelper->getRight($dianpuUid);
		if ($flag === 'add') {
			if ($step != 2 || !$dianpuid) return array('flag' => 'error', 'message' => 'Ƿ');
			if (!$right['reply'] && !$right['comment']) return array('flag' => 'error', 'message' => 'ûвȨ'); //ûвȨ
			if (!$groupRight) return array('flag' => 'error', 'message' => 'õڵĵ鲻ṩ۷'); 
		} elseif ($flag === 'del') {
			if ($step != 3 || !$dianpuid || !$commentid) return array('flag' => 'error', 'message' => 'Ƿ');
			if (!$right['del']) return array('flag' => 'error', 'message' => 'ûвȨ');
			if (!$groupRight) return array('flag' => 'error', 'message' => 'õڵĵ鲻ṩ۷'); 
		}
		return array();
	}
	/**
	 * ݹ
	 * @param string $contents
	 * @return string
	 */
	function _filterContent($contents) {
		include_once R_P . 'require/bbscode.php';
		$contents = showface($contents);
		$contents = str_replace(array("\n", "\r\n"), '<br>', trim($contents, "\r\n \n \r"));
		$contents = convert($contents, $this->_getGlobal('db_windpost'));
		return $contents;
	}

}
?>