<?php
!defined('M_P') && exit('Forbidden');
/**
 * Ʒ
 * @author L.IuHu.I@2010/8/24
 *
 */
class PW_ProductsService {
	
	/**
	 * ƷDAO
	 * @access private
	 * @var PW_Dianpu_ProductsDB
	 */
	var $_productsDao;
	
	/**
	 * 캯PHP4
	 */
	function PW_ProductsService() {
		$this->__construct();
	}
	
	/**
	 * 캯,(PHP5)
	 */
	function __construct() {
		$this->_productsDao = $this->_getProductsDao();
	}
	
	/**
	 * һƷ
	 * @param array $fieldData array('ֶ' => 'ֵ')ҪӵƷϢ
	 * @return mixed boolean (false:ʧ) | integer زID
	 */
	function addProduct($fieldData) {
		$fieldData = $this->_checkProduct($fieldData);
		if (!$fieldData) return false;
		$fieldData['createdtime'] = $fieldData['modifiedtime'] = $GLOBALS['timestamp'];
		return $this->_productsDao->insert($fieldData);
	}
	
	/**
	 * ƷIDȡһƷ
	 * @param integer $productId ƷID
	 * @return mixed boolean (false:ʧ) | array array('ֶ' => 'ֵ')زѯõƷϢ
	 */
	function getProduct($productId) {
		$productId = intval($productId);
		if (!$productId) return false;
		return $this->_productsDao->get($productId);
	}
	
	/**
	 * ͨƷIDбƷϢб
	 * @param array $productIds ƷIDб
	 * @param boolean $order Ƿ
	 * @return mixed boolean (false:ʧ) | array array(array('ֶ' => 'ֵ'),...)ƷϢб
	 */
	function getProductsByProductIds($productIds, $order = false) {
		if (!S::isArray($productIds)) return false;
		$result = $this->_productsDao->getsByIds($productIds);
		if ($order) return $this->_orderResult($productIds, $this->_bindPhotos($result));
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ƷID͵IDɾһƷ
	 * @param integer $productId ƷID
	 * @param integer $objectId ƷڵĵID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteProduct($productId, $objectId) {
		$objectId = intval($objectId);
		$productId = intval($productId);
		if (!$productId || !$objectId) return false;
		return $this->_productsDao->delete($productId, $objectId);
	}
	
	/**
	 * һƷ
	 * @param array $fieldData µƷϢ
	 * @param integer $productId µƷID
	 * @param integer $objectId µƷڵĵID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function updateProduct($fieldData, $productId, $objectId) {
		$fieldData = $this->_checkProduct($fieldData);
		$objectId = intval($objectId);
		$productId = intval($productId);
		if (!$productId || !S::isArray($fieldData) || !$objectId) return false;
		$fieldData['modifiedtime'] = $GLOBALS['timestamp'];
		return $this->_productsDao->update($fieldData, $productId, $objectId);
	}
	
	/**
	 * ȡƷ
	 * @param integer $page ʼҳ
	 * @param integer $perpage 
	 * @return array array(array('ֶ' => 'ֵ'),...) װзͼƬƷϢб
	 */
	function getProducts($page, $perpage) {
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->gets($start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ͳƷ
	 * @return integer ͳƽ
	 */
	function countProducts() {
		return $this->_productsDao->count();
	}
	
	/**
	 * ȡƷ
	 * @param integer $objectid ҪȡƷڵĵID
	 * @param integer $page ҪȡƷбҳλ
	 * @param integer $perpage ҪȡƷбʾ
	 * @return mixed boolean (false:ʧ) | array array(array('ֶ' => 'ֵ'),...) ƷϢб
	 */
	function getProductsByObjectId($objectid, $page, $perpage) {
		$objectid = intval($objectid);
		if (!$objectid) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->getsByObjectId($objectid, $start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ͳƵƷ
	 * @param integer $objectid ҪͳƷĵID
	 * @return mixed boolean (false:ʧ) | integer ͳƵĽ
	 */
	function countProductsByObjectId($objectid) {
		$objectid = intval($objectid);
		if (!$objectid) return false;
		return $this->_productsDao->countByObjectId($objectid);
	}
	
	/**
	 * ȡƼƷ
	 * @param integer $objectid ҪȡƷڵĵID
	 * @param integer $page ҪȡƷбҳλ
	 * @param integer $perpage ҪȡƷбʾ
	 * @return mixed boolean (false:ʧ) | array array(array('ֶ' => 'ֵ'),...) ƷϢб
	 */
	function getProductsByObjectIdWithRecommend($objectid, $page, $perpage) {
		$objectid = intval($objectid);
		if (!$objectid) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->getsByObjectIdWithRecommend($objectid, $start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ͳƵƼƷ
	 * @param integer $objectid ҪͳƵĵID
	 * @return mixed boolean (false:ʧ) | integer ͳƵĽ
	 */
	function countProductsByObjectIdWithRecommend($objectid) {
		$objectid = intval($objectid);
		if (!$objectid) return false;
		return $this->_productsDao->countByObjectIdWithRecommend($objectid);
	}
	
	/**
	 * ƼƷҳб
	 * @param integer $page ҵķҳ
	 * @param integer $perpage ҵ
	 * @return array array(array('ֶ' => 'ֵ'),...) غзͼƬƷб
	 */
	function getProductsWithRecommend($page, $perpage) {
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->getsWithRecommend($start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ͳƼƷ
	 * @return integer ͳƽ
	 */
	function countProductsWithRecommend() {
		return $this->_productsDao->countWithRecommend();
	}
	
	/**
	 * ƷʻȡƷ
	 * @param integer $page ѯķҳ
	 * @param integer $perpage ѯ
	 * @return array array(array('ֶ' => 'ֵ'),...) ƷϢб
	 */
	function getProductsWithHits($page, $perpage) {
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$products = $this->_productsDao->getsByProductWithHits($start, $perpage);
		return $this->_bindPhotos($products);
	}
	
	/**
	 * ȡϼƷб
	 * @param integer $objectid ҪȡƷڵĵID
	 * @param integer $page ҪȡĲѯҳ
	 * @param integer $perpage Ҫȡ
	 * @return mixed boolean (falseʧ) | array array(array('ֶ' => 'ֵ'),...) ƷϢб
	 */
	function getsByObjectIdWithShelf($objectid, $page, $perpage) {
		$objectid = intval($objectid);
		if (!$objectid) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->getsByObjectIdWithShelf($objectid, $start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ͳƵϼƷ
	 * @param integer $objectid ҪͳƵĵID
	 * @return mixed boolean (false:ʧ) | integer ͳƽ
	 */
	function countByObjectIdWithShelf($objectid) {
		$objectid = intval($objectid);
		if (!$objectid) return false;
		return $this->_productsDao->countByObjectIdWithShelf($objectid);
	}
	
	/**
	 * 駵IDsͳƷ
	 * @param array $objectIds ҪͳƵĵIDб
	 * @return mixed boolean (false:ʧ) | integer ͳ
	 */
	function countByObjectIds($objectIds) {
		return $this->_productsDao->countByObjectIds($objectIds);
	}
	
	/**
	 * 駵IDsȡƷ
	 * @param array $objectIds IDб
	 * @param integer $page ʼȡҳ
	 * @param integer $perpage  õ
	 * @return array array(array('ֶ' => 'ֵ'),...) Ϣ
	 */
	function getsByObjectIds($objectIds, $page, $perpage) {
		list($start, $offset) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->getsByObjectIds($objectIds, $start, $offset);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ƷID͵IDɾƷ
	 * @param array $productIds ҪɾƷIDб
	 * @param integer $objectId ID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteProducts($productIds, $objectId) {
		if (!$productIds || !$objectId) return false;
		return $this->_productsDao->deletes($productIds, $objectId);
	}
	
	/**
	 * ƷID͵ID¶Ʒ
	 * @param array $fieldData array('ֶ' => 'ֵ') ҪµϢ
	 * @param array $productIds ҪµƷIDб
	 * @param integer $objectId ҪµƷڵID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function updateProducts($fieldData, $productIds, $objectId) {
		$fieldData = $this->_checkProduct($fieldData);
		if (!$fieldData || !$productIds || !$objectId) return false;
		$fieldData['modifiedtime'] = $GLOBALS['modifiedtime'];
		return $this->_productsDao->updates($fieldData, $productIds, $objectId);
	}
	
	/**
	 * ͨƷƹؼƷ
	 * @param string $keyword Ĺؼ
	 * @param integer $page ʼҳ
	 * @param integer $perpage 
	 * @return mixed boolean (false:ʧ) | array array(array('ֶ' => 'ֵ'),...) Ʒб
	 */
	function searchProductsByTitle($keyword, $page, $perpage) {
		if ($keyword == '') return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->searchProductsByTitle($keyword, $start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ƷƹؼͳƷ
	 * @param string $keyword
	 * @return mixed boolean (false:ʧ) | integer ͳƽ
	 */
	function countProductsByTitle($keyword) {
		if ($keyword == '') return false;
		return $this->_productsDao->countProductsByTitle($keyword);
	}
	
	/**
	 * ؼֺ¼Ʒ
	 * @param integer $objectid ID
	 * @param string $keyword Ʒؼ
	 * @param array $shelfs  array(0) ¼   array(1) ϼ   array(0,1) ȫ
	 * @param integer $page ҳҳ룬ڼҳʼλ
	 * @param integer $perpage ҳ
	 * @return mixed boolean (false:ʧ) | array  array(array('ֶ' => 'ֵ'),...) б
	 */
	function searchByShelfAndTitle($objectid, $keyword, $shelfs, $page, $perpage) {
		$objectid = intval($objectid);
		if ($keyword == '' || $objectid < 1) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->searchByShelfAndTitle($objectid, $keyword, $shelfs, $start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ؼֺ¼ͳƷ
	 * @param integer $objectid ID
	 * @param string $keyword Ʒؼ
	 * @param array $shelfs  array(0) ¼    array(1) ϼ    array(0,1) ȫ
	 * @return mixed boolean (false:ʧ) | integer ͳƵƷ
	 */
	function countByShelfAndTitle($objectid, $keyword, $shelfs) {
		$objectid = intval($objectid);
		if ($keyword == '' || $objectid < 1) return false;
		return $this->_productsDao->countByShelfAndTitle($objectid, $keyword, $shelfs);
	}
	
	/**
	 * ¼ܻȡƷ
	 * @param integer $objectid ID
	 * @param array $shelfs  array(0) ¼     array(1) ϼ     array(0,1) ȫ
	 * @param integer $page  ִзҳѯҳ
	 * @param integer $perpage ִвѯ
	 * @return mixed boolean (false:ʧ) | array  array(array('ֶ' => 'ֵ'),...) б
	 */
	function searchByShelf($objectid, $shelfs, $page, $perpage) {
		$objectid = intval($objectid);
		if ($objectid < 1) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		$result = $this->_productsDao->searchByShelf($objectid, $shelfs, $start, $perpage);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ID¼ͳƷ
	 * @param integer $objectId ID ˴ΪID
	 * @param array $shelfs array(0) ¼    array(1) ϼ    array(0,1) ȫ
	 * @return mixed boolean (false:ʧ) | integer ͳƵƷ
	 */
	function countByObjectIdAndShelfs($objectId, $shelfs) {
		$objectId = intval($objectId);
		if ($objectId < 1) return false;
		return $this->_productsDao->countByObjectIdAndShelfs($objectId, $shelfs);
	}
	
	/**
	 * ˲ѯҳ
	 * @param integer $page   ѯҳ
	 * @param integer $perpage ѯ
	 * @return array  array(start,//ѯʼλ<br/>
	 * 						perpage,//ѯ<br/>
	 * 						page,//Ҫѯҳ<br/>
	 * 					)
	 */
	function _filterPage($page, $perpage) {
		$page = intval($page) ? intval($page) : 1;
		$start = ($page - 1) * $perpage;
		$start = intval($start);
		$perpage = intval($perpage);
		return array($start, $perpage, $page);
	}
	
	/**
	 * ԱɾƷ
	 * @attention Ϊ̨ṩ
	 * @param array $productIds  ҪɾƷIDб
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deletesForAdmin($productIds) {
		if (!S::isArray($productIds)) return false;
		return $this->_productsDao->deletesForAdmin($productIds);
	}
	
	
	/**
	 * Ʒֵֶ
	 * @access private
	 * @param array $fieldData array('ֶ' => 'ֵ') Ҫ˵ƷϢ
	 * @return mixed boolean (false:ʧ) | array array('ֶ' => 'ֵ');
	 */
	function _checkProduct($fieldData) {
		if (!S::isArray($fieldData)) return false;
		$fields = array();
		(isset($fieldData['hits'])) && $fields['hits'] = intval($fieldData['hits']);
		(isset($fieldData['objectid'])) && $fields['objectid'] = intval($fieldData['objectid']);
		(isset($fieldData['title'])) && $fields['title'] = trim($fieldData['title']);
		(isset($fieldData['description'])) && $fields['description'] = $fieldData['description'];
		(isset($fieldData['recommend'])) && $fields['recommend'] = intval($fieldData['recommend']);
		(isset($fieldData['market_price'])) && $fields['market_price'] = trim($fieldData['market_price']);
		(isset($fieldData['member_price'])) && $fields['member_price'] = trim($fieldData['member_price']);
		(isset($fieldData['shelf'])) && $fields['shelf'] = intval($fieldData['shelf']);
		(isset($fieldData['photoid'])) && $fields['photoid'] = intval($fieldData['photoid']);
		return $fields;
	}
	
	/**
	 * ƷҳͼƬƷ
	 * @access private
	 * @param array $products array(array('ֶ' => 'ֵ')) ȴƷͼƬƷб
	 * @return array array(array('ֶ' => 'ֵ')) ذƷͼƬĵƷб
	 */
	function _bindPhotos($products) {
		if (!S::isArray($products)) return array();
		$photoIds = array();
		foreach ($products as $v) {
			($v['photoid']) && $photoIds[] = $v['photoid'];
		}
		$photoService = $this->getPhotossService();
		$photos = $photoService->getPhotosByIds($photoIds);
		$tmp = array();
		foreach ($products as $v) {
			if (isset($photos[$v['photoid']])) {
				$v['photopath'] = $GLOBALS['db_attachname'] . '/' . $photos[$v['photoid']]['path'];
			} else {
				$v['photopath'] = 'mode/dianpu/images/default.jpg'; //default info
			}
			$tmp[] = $v;
		}
		return $tmp;
	}
	
	/**
	 * $ids˳б
	 * @access private
	 * @param array $ids ҪĲ
	 * @param array $result ݼ
	 * @return array array('productid' => array('ֶ' => 'ֵ'),...) ذ$idsĽ
	 */
	function _orderResult($ids, $result) {
		$_result = array();
		foreach ($ids as $key => $value) {
			$_result[$value] = array();
		}
		foreach ($result as $key => $value) {
			$_result[$value['productid']] = $value;
		}
		foreach ($_result as $key => $value) {
			if (empty($value)) unset($_result[$key]);
		}
		return $_result;
	}
	
	/**
	 * ݵIDƼƷ
	 * @param array $objectIds ID
	 * @return mixed boolean (false:ʧ) | array array(array('ֶ' => 'ֵ'),...) Ʒб
	 */
	function getRandRecommentProduct($objectIds) {
		if (!S::isArray($objectIds)) return false;
		$result = $this->_productsDao->getsByRand($objectIds);
		return $this->_bindPhotos($result);
	}
	
	/**
	 * ƷͼƬDAO
	 * @return PW_Dianpu_PhotosDB 
	 */
	function getPhotossService() {
		return DP::loadClass("photosservice", "service");
	}
	
	/**
	 * ƷĵʵDAO
	 * @return PW_ProducthitsService 
	 */
	function getProducthitsService() {
		return DP::loadClass("producthitsservice", "service");
	}
	
	/**
	 * ȡƷDAO
	 * @return PW_Dianpu_ProductsDB 
	 */
	function _getProductsDao() {
		return DP::loadDB("dianpu_products");
	}
}