<?php
!defined('M_P') && exit('Forbidden');
/**
 * ƷͼƬ
 * @author L.IuHu.I@2010/8/24
 *
 */
class PW_PhotosService {
	
	/**
	 * ƷͼƬDAO
	 * @access private
	 * @var PW_Dianpu_PhotosDB
	 */
	var $_photosDao;
	
	/**
	 * 캯PHP4
	 */
	function PW_PhotosService() {
		$this->__construct();
	}
	
	/**
	 * 캯PHP5
	 */
	function __construct() {
		$this->_photosDao = $this->_getPhotosDao();
	}
	
	/**
	 * ƷͼƬ
	 * @param array $fieldData ӵƷͼƬ
	 * @return integer زID
	 */
	function addPhoto($fieldData){
		if (!S::isArray($fieldData)) return false;
		return $this->_photosDao->insert($fieldData);
	}
	
	/**
	 * ƷIDͼƬ
	 * @param integer $objectid   ƷID
	 * @param integer $page       ͼƬҳǰҪҳ
	 * @param integer $perpage    ͼƬҳÿҳʾ
	 * @return mixed boolean (false:ʧ) | array  array(array('ֶ' => 'ֵ'),...)ƷͼƬб 
	 */
	function getPhotosByObjectId($objectid, $page = 1, $perpage = 20){
		$objectid = intval($objectid);
		if ($objectid < 1) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		return $this->_photosDao->getsByObjectId($objectid, $start, $perpage);
	}
	
	/**
	 * ƷͼƬIDɾƷͼƬ
	 * @param integer $photoId ҪɾƷͼƬID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deletePhoto($photoId){
		$photoId = intval($photoId);
		if ($photoId < 1) return false;
		return $this->_photosDao->delete($photoId);
	}
	
	/**
	 * ƷͼƬIDͼƬIDɾͼƬ
	 * @param integer $photoId ƷͼƬID
	 * @param integer $belongId ID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteByPhotoIdAndBelongId($photoId, $belongId){
		$photoId = intval($photoId);
		$belongId = intval($belongId);
		if ($photoId < 1 || $belongId < 1 ) return false;
		return $this->_photosDao->deleteByPhotoIdAndBelongId($photoId, $belongId);
	}
	
	/**
	 * ƷͼƬIDƷͼƬϢ
	 * @param integer $photoId ƷͼƬID
	 * @return mixed boolean (false:ʧ) | array array('ֶ' => 'ֵ')ظƷͼƬϢ
	 */
	function getPhoto($photoId){
		$photoId = intval($photoId);
		if ($photoId < 1) return false;
		return $this->_photosDao->get($photoId);
	}
	
	/**
	 * ƷͼƬIDбƷͼƬϢб
	 * @param array $photoIds ƷͼƬIDб
	 * @return array array('photoid'=>array('ֶ' => 'ֵ'),...) зϵƷͼƬϢб
	 */
	function getPhotosByIds($photoIds){
		if (!S::isArray($photoIds)) return array();
		$result =  $this->_photosDao->getPhotosByIds($photoIds);
		if (!$result) return array();
		$tmp = array();
		foreach ($result as $p) {
			$tmp[$p['photoid']] = $p;
		}
		return $tmp;
	}
	
	/**
	 * ƷͼƬ
	 * @param array $fieldDatas array(array('ֶ' => 'ֵ'),...) ȴӵƷͼƬϢ
	 * @return mixed boolean (false:ʧ) | integer زID
	 */
	function addPhotos($fieldDatas){
		if (!S::isArray($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['belongid'] = intval($v['belongid']);
			$tmp['objectid'] = intval($v['objectid']);
			$tmp['typeid'] = intval($v['typeid']);
			$tmp['filename'] = trim($v['filename']);
			$tmp['path'] = trim($v['path']);
			$tmp['createdtime'] = $v['createdtime'];
			$fields[] = $tmp;
		}
		return $this->_photosDao->addPhotos($fields);
	}
	
	/**
	 * ˲ѯҳҳҪѯ
	 * @access private
	 * @param integer $page Ҫѯҳ
	 * @param integer $perpage Ҫѯ
	 * @return array array(start,//ѯĿʼλ<br/> 
	 * 					    perpage,//ѯ<br/> 
	 * 					    page //ѯҳ<br/>)
	 */
	function _filterPage($page, $perpage) {
		$page = intval($page);
		$page = ($page) ? $page : 1;
		$start = ($page - 1) * $perpage;
		$start = intval($start);
		$perpage = intval($perpage);
		return array($start,$perpage,$page);
	}
	
	/**
	 * ȡƷͼƬDAO
	 * @access private
	 * @return PW_Dianpu_PhotosDB 
	 */
	function _getPhotosDao() {
		return DP::loadDB("dianpu_photos");
	}

}