<?php
!defined('M_P') && exit('Forbidden');

/**
 * ط
 * @author yishuo
 * 
 */
class PW_GroupService {
	
	/**
	 * ӵ
	 * @param array $data ҪӵĵϢ
	 * @return mixed boolean (false :ʧ) | integer زID
	 */
	function insertDianpuGroup($data) {
		if (!is_array($data) || empty($data)) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->insertGroup($data);
	}
	
	/**
	 * ֱӴݿȡݵIDõϢ
	 * @param integer $gid ID
	 * @return mixed boolean (falseʧ) | array  array('ֶ' => 'ֵ')صĵϢ
	 */
	function getGroupInfo($gid) {
		if (!$gid) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->getGroupById($gid);
	}
	
	/**
	 * ݵIDµ
	 * @param array $data ҪµĵϢ
	 * @param integer $id ҪµĵID
	 * @return mixed boolean (false: ʧ) | integer Ӱ
	 */
	function updateDianpuGroup($data, $id) {
		if (empty($id)) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->updateGroup($data, $id);
	}
	
	/**
	 * ݵIDɾ
	 * @param integer $gid ҪɾĵID
	 * @return mixed boolean (false:ɾʧ) | integer ɾӰ
	 */
	function deleteDianpuGroup($gid) {
		if (empty($gid)) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->deleteGroupById($gid);
	}
	
	/**
	 * еб
	 * @param integer $start ʼλ
	 * @param integer $perpage 
	 * @return array array(array('ֶ' => 'ֵ'),...) طϵĽ
	 */
	function getDianpuGroupsByPages($start = '0', $perpage = '0') {
		$_groupDB = $this->_getGroupsDB();
		$_tmp = $_groupDB->getGroupsByPages($start, $perpage);
		return $this->_buildResultList($_tmp);
	}
	
	/**
	 * ͳƵ
	 * @return integer ͳƽ
	 */
	function getDianpuGroupsCount() {
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->getGroupCount();
	}
	
	/**
	 * ݵIDӻļлõϢ
	 * @param integer $gid ҪõϢĵID
	 * @return array array('ֶ' => 'ֵ') زѯĵϢ
	 */
	function getGroupById($gid = '') {
		if (!$groups = L::config('dianpuGroups', 'dianpu_groups')) $this->updateDianpuGroupCache();
		return $gid ? $groups[$gid] : $groups;
	}
	
	/**
	 * ȫվҳչʾƼб
	 * @param string $type ȫվҳչʾĵ
	 * @return array array('groupid',...) Ƽб  
	 */
	function getDianpushowGroups($type = 'dianpushow') {
		$groups = L::config('dianpuGroups', 'dianpu_groups');
		$_result = array();
		foreach ($groups as $key => $value) {
			if (array_key_exists($type, $value['configinfo']) && $value['configinfo'][$type]) $_result[] = $key;
		}
		return $_result;
	}
	
	/**
	 * µ黺
	 * @return void
	 */
	function updateDianpuGroupCache() {
		$_groupDB = $this->_getGroupsDB();
		$_data = $_groupDB->getGroupsByPages();
		$this->_updateCache($this->_buildResultList($_data));
	}
	
	/**
	 * µ黺
	 * @access private
	 * @param array $data array(array('ֶ' => 'ֵ'),...) ĵϢµ黺ļ
	 * @return void
	 */
	function _updateCache($data) {
		$_cachefile = D_P . "data/bbscache/dianpu_groups.php";
		writeover($_cachefile, "<?php\r\n\$dianpuGroups=" . pw_var_export($data) . "\r\n?>");
	}
	
	/**
	 * 췵صĽб
	 * @access private
	 * @param array $result array(array('ֶ' => 'ֵ'),...) ҪĽ
	 * @return mixed boolean (false:ʧ) | array(array('ֶ' => 'ֵ'),...)
	 */
	function _buildResultList($result) {
		if (!is_array($result) || empty($result)) return false;
		$_tmp = array();
		foreach ($result as $key => $value) {
			if ($value['createtime']) $value['createtime'] = get_date($value['createtime'], 'Y-m-d');
			$_tmp[$key] = $value;
		}
		return $_tmp;
	}
	
	/**
	 * õDAO
	 * @access private
	 * @return PW_Dianpu_GroupsDB 
	 */
	function _getGroupsDB() {
		return DP::loadDB('dianpu_groups');
	}
}
?>