<?php
!defined('M_P') && exit('Forbidden');
/**
 * ҵ
 * @author L.IuHu.I@2010/8/26
 *
 */
class PW_CategoriesService {
	
	/**
	 * ҵDAO
	 * @access private
	 * @var PW_Dianpu_categoriesDB
	 */
	var $_categoriesDao;
	
	/**
	 * 캯PHP4ݣ
	 */
	function PW_CategoriesService() {
		$this->__construct();
	}
	
	/**
	 * 캯PHP5ݣ
	 */
	function __construct() {
		global $timestamp;
		$this->_categoriesDao = $this->_getCategoriesDao();
		$this->_timestamp = $timestamp;
	}
	
	/**
	 * ҵ
	 * @param array $fieldData array('ֶ' => 'ֵ')
	 * @return mixed boolean (false:ʧ) | integer زID
	 */
	function addCategory($fieldData) {
		if (!S::isArray($fieldData)) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		return $this->_categoriesDao->insert($fieldData);
	}
	
	/**
	 * ҵ
	 * @param array $fieldDatas array(array('ֶ' => 'ֵ'),...)
	 * @return mixed boolean (false:ʧ) | integer һID
	 */
	function addCategories($fieldDatas) {
		if (!S::isArray($fieldDatas)) return false;
		if (!$this->_filterParams($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['parentid'] = ($v['parentid'] > 0) ? intval($v['parentid']) : 0;
			$tmp['name'] = $v['name'];
			$tmp['sort'] = $v['sort'];
			$tmp['createdtime'] = $this->_timestamp;
			$fields[] = $tmp;
		}
		$result = $this->_categoriesDao->addCategories($fields);
		if ($result) $this->refreshCategoryCache();
		return $result;
	}
	
	/**
	 * ·Ϣ
	 * @param array $fieldData array('ֶ' => 'ֵ')
	 * @param integer $id ҪµID
	 * @return mixed boolean (false: ʧ) | integer Ӱ
	 */
	function updateCategory($fieldData, $id) {
		$id = intval($id);
		if (!S::isArray($fieldData) || $id < 1) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		$result = $this->_categoriesDao->update($fieldData, $id);
		if ($result) $this->refreshCategoryCache();
		return $result;
	}
	
	/**
	 * ƶϢ
	 * @param array $fieldData array('ֶ' => 'ֵ')
	 * @param integer $id ҪתƵID
	 * @return mixed boolean (false: ʧ) | integer Ӱ
	 */
	function moveCategory($fieldData, $id) {
		$id = intval($id);
		if (!S::isArray($fieldData) || $id < 1) return false;
		if (!$fieldData['parentid']) return false;
		$result = $this->_categoriesDao->update($fieldData, $id);
		if ($result) $this->refreshCategoryCache();
		return $result;
	}
	
	/**
	 * ҵID·Ϣ
	 * @param array $fieldData  array('ֶ' => 'ֵ')
	 * @param integer $parentId ҵID
	 * @return mixed boolean (false:ʧϢ) | integer Ӱ
	 */
	function updateByParentId($fieldData, $parentId) {
		$parentId = intval($parentId);
		if (!S::isArray($fieldData) || $parentId < 1) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		$result =  $this->_categoriesDao->updateByParentId($fieldData, $parentId);
		if ($result) $this->refreshCategoryCache();
		return $result;
	}
	
	/**
	 * ȫϢ Ƿļ 
	 * @return array array(array('ֶ' => 'ֵ'),...)
	 */
	function getCategories() {
		$dianpu_category_cache = L::config($dianpu_category_cache, 'dianpu_category_cache');
		if (!$dianpu_category_cache) $soruceCategories = $this->refreshCategoryCache();
		return ($dianpu_category_cache) ? $dianpu_category_cache['dianpu_category_cache'] : $soruceCategories;
	}
	
	/**
	 * ˢ·ļ
	 * @return array array(array('ֶ' => 'ֵ'),...)
	 */
	function refreshCategoryCache() {
		$categories = $this->getCategoriesNoCache();
		if (S::isArray($categories)) {
			writeover(D_P . 'data/bbscache/dianpu_category_cache.php', "<?php\r\n\$dianpu_category_cache=" . pw_var_export($categories) . ";\r\n?>");
		}
		return $categories;
	}
	
	/**
	 * ݷID÷Ϣ
	 * @param integer $categoryId ID
	 * @return array array('ֶ' => 'ֵ')
	 */
	function getCategory($categoryId) {
		$categories = $this->getCategories();
		if (!$categories) return $this->_categoriesDao->get($categoryId);
		foreach($categories as $category) {
			if ($category['categoryid'] == $categoryId) return $category;
		}
	}
	
	/**
	 * ݷIDɾϢ
	 * @param integer $categoryId  ID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteCategory($categoryId) {
		$categoryId = intval($categoryId);
		if ($categoryId < 1) return false;
		$result = $this->_categoriesDao->delete($categoryId);
		if ($result) $this->refreshCategoryCache();
		return $result;
	}
	
	/**
	 * ҵIDøҵµķб
	 * @param integer $parentId ҵID
	 * @return mixed boolean (falseʧ) | array  طб  array(array('ֶ' => 'ֵ'),...)
	 */
	function getCategoriesByParentId($parentId) {
		$parentId = intval($parentId);
		if ($parentId < 1) return false;
		$categories = $this->getCategories();
		if (!$categories) return $this->_categoriesDao->getsByParentid($parentId);
		$_categories = array();
		foreach($categories as $category) {
			if ($category['parentid'] == $parentId) $_categories[] = $category;
		}
		return $_categories;
	}
	
	/**
	 * ݱжȡҵб
	 * @return array  array(array('ֶ' => 'ֵ'),...)طб  
	 */
	function getCategoriesNoCache() {
		return $this->_categoriesDao->gets();
	}
	
	/**
	 * 駷IDsȡҵ
	 * @param array $categoryIds ID
	 * @return mixed boolean (false:ʧ) | array array('categoryid' => array('parentName','childName'),...)ҵϢб
	 */
	function linkCategories($categoryIds) {
		if (!S::isArray($categoryIds)) $categoryIds = array($categoryIds);
		$categories = $this->getCategories();
		if (!$categories) return false;
		$children = $parent = array();
		foreach ($categories as $key => $category) {
			if ($category['parentid'] > 0) {
				$children[] = $category;
			} else {
				$parent[$category['categoryid']] = $category;
			}
		}
		$tmp = array();
		foreach ($children as $c) {
			if ($parent[$c['parentid']] && in_array($c['categoryid'], $categoryIds)) {
				$tmp[$c['categoryid']] = array('parent' => $parent[$c['parentid']]['name'],'child' => $c['name']);
			}
		}
		return $tmp;
	}
	/**
	 * ȡҵ
	 * @return mixed boolean (false:ʧ) <br/> array('0' => array('categoryid' => array('ֶ'=>'ֵ'),...),//ҵб <br/>
	 * 										      '1' => array('parentid' => array(array('ֶ'=>'ֵ'),...),...),//ҵµб<br/>
	 * 										      '2' => array('categoryid' => array('ֶ'=>'ֵ'),...)//ҵҵ·б<br/>
	 * 										 )
	 */
	function getParentAndChild(){
		$categories = $this->getCategories();
		if (!$categories) return false;
		$children = $parent = $all =  array();
		foreach ($categories as $key => $category) {
			if ($category['parentid'] > 0) {
				$children[$category['parentid']][] = $category;
			} else {
				$parent[$category['categoryid']] = $category;
			}
			$all[$category['categoryid']] = $category;
		}
		return array($parent,$children,$all);
	}
	
	/**
	 * Ĳ
	 * @access private
	 * @param array $params array(array('ֶ' => 'ֵ'),...) Ҫ˵Ĳб
	 * @return array array(array('ֶ' => 'ֵ'),...) ˺Ĳб
	 */
	function _filterParams($params) {
		$temp = array();
		foreach( $params as $key => $one) {
			$_tmp = $this->_cleanParam($one);
			if (!$_tmp) return $temp;
			$temp[$key] = $_tmp;
		}
		return $temp;
	}
	
	/**
	 * ĵ
	 * @access private
	 * @param array $param  array('ֶ' => 'ֵ') Ҫ˵Ĳб 
	 * @return array array('ֶ' => 'ֵ') ˺Ĳб
	 */
	function _cleanParam($param) {
		if (!$param['name']) {
			Error::addError('ƣ');
			return false;
		}
		if (strlen($param['name']) > 20) {
			Error::addError('"<font color="red">' . $param['name'] . '</font>"󣬳Ȳܳ20ֽڣ');
			return false;
		}
		return $param;
	}
	
	/**
	 * ȡҵDAO
	 * @access private
	 * @return PW_Dianpu_categoriesDB 
	 */
	function _getCategoriesDao() {
		return DP::loadDB("dianpu_categories");
	}
}