<?php
!defined('M_P') && exit('Forbidden');
/**
 * 
 * @author L.IuHu.I@2010/8/26
 *
 */
class PW_AreasService {
	
	/**
	 * DAO
	 * @access private
	 * @var PW_Dianpu_areasDB
	 */
	var $_areasDao;
	
	/**
	 * 캯(PHP4)
	 */
	function PW_AreasService() {
		$this->__construct();
	}
	
	/**
	 * 캯PHP5
	 */
	function __construct() {
		global $timestamp;
		$this->_areasDao = $this->_getAreasDao();
		$this->_timestamp = $timestamp;
	}
	
	/**
	 * ӵ
	 * @param array $fieldData array('ֶ'=>'ֵ')
	 * @return integer ID
	 */
	function addArea($fieldData) {
		if (!S::isArray($fieldData)) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		$result = $this->_areasDao->insert($fieldData);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * ӵ
	 * @param array $fieldDatas array(array('ֶ'=>'ֵ'),...)
	 * @return integer ID
	 */
	function addAreas($fieldDatas) {
		if (!S::isArray($fieldDatas)) return false;
		if (!$this->_filterParams($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['name'] = $v['name'];
			$tmp['sort'] = intval($v['sort']);
			$tmp['createdtime'] = $this->_timestamp;
			$fields[] = $tmp;
			unset($tmp);
		}
		$result = $this->_areasDao->addAreas($fields);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * µ
	 * @param array $fieldData array('ֶ'=>'ֵ') ҪµֶϢ
	 * @param integer $areaId µĵID
	 * @return integer Ӱ
	 */
	function updateArea($fieldData, $areaId) {
		$areaId = intval($areaId);
		if (!S::isArray($fieldData) || $areaId < 0) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		$result = $this->_areasDao->update($fieldData, $areaId);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * ݵIDõϢ
	 * @param integer $areaId ID
	 * @return mixed boolean (false:ʧ) | array ('ֶ'=>'ֵ')
	 */
	function getArea($areaId) {
		$areaId = intval($areaId);
		if ($areaId < 0) return false;
		$areas = $this->getAreas();
		if (!$areas) return $this->_areasDao->get($areaId);
		foreach ($areas as $area) {
			if ($area['areaid'] == $areaId) return $area;
		}
	}
	
	/**
	 * ӻļлõб
	 * @return array array(array('ֶ'=>'ֵ')...)
	 */
	function getAreas() {
		$dianpu_area_cache = L::config($dianpu_area_cache, 'dianpu_area_cache');
		if (!$dianpu_area_cache) $soruceAreas = $this->refreshAreaCache();
		return ($dianpu_area_cache) ? $dianpu_area_cache['dianpu_area_cache'] : $soruceAreas;
	}
	
	/**
	 * ˢµбĻļ
	 * @return array array(array('ֶ'=>'ֵ')...)
	 */
	function refreshAreaCache() {
		$areas = $this->getAreasNoCache();
		if (S::isArray($areas)) {
			writeover(D_P . 'data/bbscache/dianpu_area_cache.php', "<?php\r\n\$dianpu_area_cache=" . pw_var_export($areas) . ";\r\n?>");
		}
		return $areas;
	}
	
	/**
	 * ݿлõб
	 * @return array array(array('ֶ'=>'ֵ')...)
	 */
	function getAreasNoCache() {
		return $this->_areasDao->gets();
	}
	
	/**
	 * ͨIDеб
	 * @param array $ids array(id1,id2...); IDб
	 * @return mixed boolean (false:ʧ) | array('areaid'=>'areaname'...)
	 */
	function getAreasByIds($ids) {
		if (!S::isArray($ids)) return false;
		$result = $this->_getAreas($ids);
		if (!$result) return false;
		$tmp = array();
		foreach ($result as $v) {
			$tmp[$v['areaid']] = $v['name'];
		}
		return $tmp;
	}
	
	/**
	 * ݿ߻ļлõб
	 * @access private
	 * @param array array('areaid'...) ѯĵIDб
	 * @return array array(array('ֶ'=>'ֵ')...)
	 */
	function _getAreas($ids) {
		$areas = $this->getAreas();
		if (!$areas) return $this->_areasDao->getsByIds($ids);
		$result = array();
		foreach ($areas as $area) {
			if (in_array($area['areaid'], $ids)) $result[] = $area;
		}
		return $result;
	}
	
	/**
	 * ݵIDɾ
	 * @param integer $areaId ID
	 * @return mixed boolean (false:ʧ) | integer Ӱ
	 */
	function deleteArea($areaId) {
		$areaId = intval($areaId);
		if ($areaId < 0) return false;
		$result = $this->_areasDao->delete($areaId);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * Ĳйˣ룩
	 * @access private
	 * @param array $params array(array('ֶ' => 'ֵ')...)
	 * @return array array(array('ֶ' => 'ֵ')
	 */
	function _filterParams($params) {
		$temp = array();
		foreach ($params as $key => $one) {
			$_tmp = $this->_cleanParam($one);
			if (!$_tmp) return $temp;
			$temp[$key] = $_tmp;
		}
		return $temp;
	}
	
	/**
	 * Ĳйˣ룩
	 * @access private
	 * @param array $param array('ֶ' => 'ֵ')
	 * @return mixed boolean (false: ʧ) | array array('ֶ' => 'ֵ')
	 */
	function _cleanParam($param) {
		if (!$param['name']) {
			Error::addError('');
			return false;
		}
		if (strlen($param['name']) > 20) {
			Error::addError('"<font color="red">' . $param['name'] . '</font>"󣬳Ȳܳ20ֽڣ');
			return false;
		}
		return $param;
	}
	
	/**
	 * ȡDAO
	 * @access private
	 * @return PW_Dianpu_areasDB 
	 */
	function _getAreasDao() {
		return DP::loadDB("dianpu_areas");
	}
}