<?php
!function_exists('readover') && exit('Forbidden');
define("M_P", dirname(dirname(dirname(__FILE__))));
require_once R_P . 'mode/dianpu/require/core.php';
require_once R_P . 'lib/search/extend/extendabstract.class.php';
/**
 * ȫվչ֧ʵ
 * @author Liuhui
 */
class PW_dianpuSearcher extends PW_ExtendSearcherAbstract {
	
	/**
	 * 
	 * @see lib/search/extend/PW_ExtendSearcherAbstract#getSearchResult()
	 * @return array
	 */
	function getSearchResult() {
		if (!($htmlFile = $this->_getHtmlFile(dirname(__FILE__), 'dianpu.htm'))) return '';
		$params['dianpu'] = $this->_getRecommendDianpu();
		$this->_overdueDianpu($params['dianpu']);
		$params['products'] = $this->_getRecommendProducts();
		return $this->_outputHtml($htmlFile, $params);
	}
	
	/**
	 * ƼƷ
	 * @return array
	 */
	function _getRecommendProducts() {
		$dianpuIds = array();
		$productService = $this->_getProductService();
		$dianpuService = $this->_getDianpuService();
		$randDianpus = $dianpuService->getDianpuByRand('productshow');
		foreach ($randDianpus as $dianpu) {
			$dianpuIds[] = $dianpu['dianpuid'];
		}
		return $productService->getRandRecommentProduct($dianpuIds);
	}
	
	/**
	 * Ƽ
	 * @return array
	 */
	function _getRecommendDianpu() {
		$dianpuService = $this->_getDianpuService();
		return $dianpuService->getDianpuByRand('dianpushow', 1);
	}
	
	/**
	 * @access prviate
	 * @return PW_DianpuService
	 */
	function _getDianpuService() {
		return DP::loadClass('dianpuservice', 'service');
	}
	
	/**
	 * @access private
	 * @return PW_ProductsService
	 */
	function _getProductService() {
		return DP::loadClass('productsservice', 'service');
	}
	
	/**
	 * 鲢Ƽ̹ʱ
	 * @param array $dianpus
	 * @return boolean
	 */
	function _overdueDianpu($dianpus) {
		global $timestamp;
		if (!$dianpus) return false;
		$overDianpus = array();
		foreach ($dianpus as $key => $value) {
			if ($value['overtime'] && PwStrtoTime($value['overtime']) <= $timestamp) $overDianpus[] = $value['dianpuid'];
		}
		if (!$overDianpus) return false;
		$service = DP::loadClass('dianpuservice', 'service'); /* @var $service PW_Dianpuservice */
		$service->setOverdueDianpu($overDianpus);
	}
}