<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basemodule.php';
/**
 * Ʒҵģʵ
 * @author yishuo
 */
class PW_ProductModule extends BaseModule {
	
	var $productid = null;
	var $objectid = null;
	var $title = null;
	var $description = null;
	var $recommend = null;
	var $market_price = null;
	var $member_price = null;
	var $shelf = null;
	var $photoid = null;
	var $modifiedtime = null;
	var $createdtime = null;
	var $attach = array();
	
	/**
	 * Ʒĸ
	 * @return void 
	 */
	function setAttach() {
		global $db_allowupload, $_G;
		DP::loadClass('productupload', '', false);
		$uploaddb = array();
		if ($db_allowupload && (PwUpload::getUploadNum()) && (PwUpload::getUploadNum() < 6)) {
			$dianpupload = new PW_ProductUpload();
			$uploaddb = PwUpload::upload($dianpupload, false);
		}
		$this->attach = (array) $uploaddb;
	}

	/**
	 * ƷID
	 * @param integer $productid ƷID
	 * @return void 
	 */
	function setProductId($productid) {
		$objectId = intval($objectId);
		if ($objectId < 1) $this->_addError('ѡƷID');
		$this->productid = $productid;
	}
	
	/**
	 * ọ̃߶ID
	 * @param integer $objectId ID
	 * @return void 
	 */
	function setObjectId($objectId) {
		$objectId = intval($objectId);
		if ($objectId < 1)  $this->_addError('ѡID');
		$this->objectid = $objectId;
	}
	
	/**
	 * Ʒ
	 * @param string $title Ʒ
	 * @return void 
	 */
	function setTitle($title) {
		$title = trim($title);
		if ($title == '') $this->_addError('ƷƲΪ');
		$this->_validationFieldLenght($title, 0, 200, 'ƷƳȲܴ200ֽ');
		$this->_filterWordsfb($title, 'Ʒ');
		$this->title = $title;
	}
	
	/**
	 * Ʒ
	 * @param string $description Ʒ
	 * @return void 
	 */
	function setDescription($description) {
		$this->_filterWordsfb($description, 'Ʒ');
		$this->description = $this->_filterContent($description);
	}
	
	/**
	 * ƷǷƼ
	 * @param integer $recommend ƷǷƼ
	 * @return void 
	 */
	function setRecommend($recommend) {
		$this->recommend = intval($recommend);
	}
	
	/**
	 * Ʒг۸
	 * @param string $marketPrice  г۸
	 * @return void 
	 */
	function setMarketPrice($marketPrice) {
		if ($marketPrice == '') $this->_addError('Ʒг۸Ϊ');
		$this->_filterWordsfb($marketPrice, 'Ʒг۸');
		$this->market_price = $this->_formatPrice($marketPrice);
	}
	
	/**
	 * ƷԱ۸
	 * @param string $memberPrice Ա۸
	 * @return void 
	 */
	function setMemberPrice($memberPrice) {
		if ($memberPrice == '') $this->_addError('ƷԱ۸Ϊ');
		$this->_filterWordsfb($memberPrice, 'ƷԱ۸');
		$this->member_price = $this->_formatPrice($memberPrice);
	}
	
	/**
	 * ƷǷϼ¼
	 * @param integer $shelf ¼ (ĬΪ0δϼܣ1Ϊϼܣ
	 * @return void 
	 */
	function setShelf($shelf) {
		$this->shelf = (in_array($shelf, array(0, 1))) ? $shelf : 1;
	}
	
	/**
	 * ƷĬϵͼƬID
	 * @param integer $photoId ƷĬͼƬID
	 * @return void 
	 */
	function setPhotoId($photoId) {
		$this->photoid = intval($photoId);
	}
	
	/**
	 * Ʒĵʱ
	 * @param string $modifiedTime Ʒµʱ
	 * @return void 
	 */
	function setModifiedTime($modifiedTime) {
		$this->modifiedtime = $modifiedTime;
	}
	
	/**
	 * Ʒʱ
	 * @param string $createdtime Ʒʱ
	 * @return void 
	 */
	function setCreatedTime($createdtime) {
		$this->createdtime = $createdtime;
	}

	/**
	 * ݵĺ
	 * @access private
	 * @param string $content Ҫ˵
	 * @return string ˺
	 */
	function _filterContent($content) {
		$filterUitil = L::loadClass('FilterUtil', 'filter');
		$content = $filterUitil->convert($content);
		foreach (array('wmv', 'rm', 'flash') as $key => $value) {
			if (strpos(",{$GLOBALS['_G']['media']},", ",$value,") === false) {
				$content = preg_replace("/(\[$value=([0-9]{1,3}\,[0-9]{1,3}\,)?)1(\].+?\[\/$value\])/is", "\${1}0\\3", $content);
			}
		}
		$content = preg_replace(array("/<script.*>.*<\/script>/is", "/<(([^\"']|\"[^\"]*\"|'[^']*')*?)>/eis", 
			"/javascript/i"), array("", "\$this->_jscv('\\1')", "java script"), str_replace('.', '&#46;', $content));
		return $content;
	}
}
?>