<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basemodule.php';
/**
 * ҵģʵ
 * @author papa0924@gmail.com
 */
class PW_DianpuModule extends BaseModule {
	
	var $dianpuid = null;
	var $state = null;
	var $contents = null;
	var $titles = null;
	var $uid = null;
	var $username = null;
	var $url = null;
	var $operator = null;
	var $operatorphone = null;
	var $groupid = null;
	var $group = null;
	var $businfo = null;
	var $tempstyle = null;
	var $title = null;
	var $checktime = null;
	var $address = null;
	var $qq = null;
	var $msn = null;
	var $wangwang = null;
	var $email = null;
	var $phone = null;
	var $areanumber = null;
	var $map_x = null;
	var $map_y = null;
	var $map_z = null;
	var $logo = null;
	var $bulletin = null;
	var $ifattach = null;
	var $createtime = null;
	var $modifytime = null;
	var $overtime = null;
	var $shangjiaid = null;
	var $company = null;
	var $delegate = null;
	var $delegatephone = null;
	var $companyaddress = null;
	var $companyphone = null;
	var $companyfax = null;
	var $companyzipcode = null;
	var $contentorder = null;
	var $areaid = null;
	var $area = null;
	var $categoryid = null;
	var $category = null;
	var $parentid = null;
	var $parent = null;
	var $ifcheck = null;
	var $checkway = null;
	var $recommendlevel = null;
	var $hit = null;
	var $checkwayhtml = null;
	
	/**
	 * ָ˳õ˵tabҳ
	 * @return array array(contentid => array(), ...)
	 */
	function getPageTitles() {
		if (!$this->contentorder) return array();
		$_tmp = $_result = array();
		foreach ($this->contentorder as $key => $value) {
			$_tmp[$key] = (int) $value['o'];
		}
		asort($_tmp);
		foreach ($_tmp as $key => $value) {
			$_result[$key] = $this->contentorder[$key];
		}
		return $_result;
	}
	
	/**
	 * õID
	 * @param integer $dianpuid ҪõĵID
	 * @return void 
	 */
	function setDianpuid($dianpuid) {
		$this->dianpuid = $dianpuid;
	}
	
	/**
	 * õ̵״̬
	 * @param integer $state ״̬(1Ϊ״̬ĬΪ0رգ
	 * @return void 
	 */
	function setState($state) {
		$this->state = $state;
	}
	
	/**
	 * õ̵˵
	 * @param string $contents ˵
	 * @return void 
	 */
	function setContents($contents) {
		$this->_filterWordsfb($contents, '˵');
		$this->contents = $this->_filterContent($contents);
	}
	
	/**
	 * õ̵ĵ̳ID
	 * @param integer $uid ̳ID
	 * @return void 
	 */
	function setUid($uid) {
		$this->uid = $uid;
	}
	
	/**
	 * õ̵ĵû
	 * @param string $username û
	 * @return void 
	 */
	function setUsername($username) {
		$this->_validationRequired($username, 'ûΪ');
		$this->_filterWordsfb($username, '');
		$userService = L::loadClass('userservice', 'user');
		/* @var $userService PW_UserService */
		if (!$userid = $userService->getUserIdByUserName($username)) {
			$this->_addError("û");
		}
		$this->setUid($userid);
		$this->username = $username;
	}
	
	/**
	 * õ̵ַ
	 * @param string $url ̵ַ
	 * @return void 
	 */
	function setUrl($url) {
		$this->_validationIntAndLetter($url, 'ַֻ֧Ӣĺ');
		$this->_filterWordsfb($url, 'ַ');
		$this->url = $url;
	}
	
	/**
	 * õ̵ľӪ
	 * @param string $operator ̾Ӫ
	 * @return void 
	 */
	function setOperator($operator) {
		$this->_validationRequired($operator, '̾Ӫ߲Ϊ');
		$this->_filterWordsfb($operator, '̾Ӫ');
		$this->_validationFieldLenght($operator, 0, 15, '̾ӪȲܴ15ֽ');
		$this->operator = $operator;
	}
	
	/**
	 * õ̵ľӪߵ绰
	 * @param string $operatorphone ̾Ӫߵ绰
	 * @return void 
	 */
	function setOperatorphone($operatorphone) {
		$this->_validationRequired($operatorphone, '̾Ӫߵ绰Ϊ');
		$this->_filterWordsfb($operatorphone, '̾Ӫߵ绰');
		$this->_validationFieldLenght($operatorphone, 0, 30, '̾Ӫߵ绰Ȳܴ30ֽ');
		$this->operatorphone = $operatorphone;
	}
	
	/**
	 * õ̵ĵID
	 * @param integer $groupid ID
	 * @return void 
	 */
	function setGroupid($groupid) {
		$this->_validationRequired($groupid, 'ѡ');
		$this->groupid = $groupid;
	}
	
	/**
	 * õ̵ĹϢ
	 * @param string $businfo ̹·
	 * @return void 
	 */
	function setBusinfo($businfo) {
		if ($businfo) {
			$this->_validationFieldLenght($businfo, 0, 255, '̹·Ȳܴ255ֽ');
			$this->_filterWordsfb($businfo, '̹·');
		}
		$this->businfo = $businfo;
	}
	
	/**
	 * õ̵ķ
	 * @param string $tempstyle 
	 * @return void 
	 */
	function setTempstyle($tempstyle) {
		$this->tempstyle = $tempstyle;
	}
	
	/**
	 * õ̵
	 * @param string $title 
	 * @return void 
	 */
	function setTitle($title) {
		$this->_validationRequired($title, 'ƲΪ');
		$this->_filterWordsfb($title, '');
		$this->_validationFieldLenght($title, 0, 30, 'ƳȲܴ30ֽ');
		$this->title = trim($title);
	}
	
	/**
	 * õ̵֤ʱ
	 * @param string $checktime ֤ʱ
	 * @return void 
	 */
	function setChecktime($checktime) {
		$this->checktime = $checktime;
	}
	
	/**
	 * õ̵ʵַ
	 * @param string $address ʵַ
	 * @return void 
	 */
	function setAddress($address) {
		$this->_validationRequired($address, 'ʵַΪ');
		$this->_filterWordsfb($address, 'ʵַ');
		$this->_validationFieldLenght($address, 0, 255, 'ʵַȲܴ255ֽ');
		$this->address = trim($address);
	}
	
	/**
	 * õ̵ĵ绰
	 * @param string $phone ̵绰
	 * @return void 
	 */
	function setPhone($phone) {
		$this->_validationRequired($phone, '̵绰벻Ϊ');
		$this->_validationFieldLenght($phone, 5, 11, '绰ڳΪ5-11λ');
		$this->_filterWordsfb($phone, '̵绰');
		$this->phone = trim($phone);
	}
	
	/**
	 * õ̵ĵ绰
	 * @param integer $areanumber ̵ĵ绰
	 * @return void 
	 */
	function setAreanumber($areanumber) {
		$this->_validationRequired($areanumber, '̵绰ŲΪ');
		$this->_validationFieldInt($areanumber, 'дȷĵ̵绰ţ');
		$this->_validationFieldLenght($areanumber, 2, 4, '绰ڳΪ2-4λ');
		$this->_filterWordsfb($areanumber, '̵绰');
		$this->areanumber = trim($areanumber);
	}
	
	/**
	 * õ̵ĵͼXֵ
	 * @param string $map_x ̵ͼXֵ
	 * @return void 
	 */
	function setMap_x($map_x) {
		$this->map_x = $map_x;
	}
	
	/**
	 * õ̵ĵͼYֵ
	 * @param string $map_y ̵ͼYֵ
	 * @return void 
	 */
	function setMap_y($map_y) {
		$this->map_y = $map_y;
	}
	
	/**
	 * õ̵ĵͼZֵ
	 * @param string $map_z ̵ͼZֵ
	 * @return void 
	 */
	function setMap_z($map_z) {
		$this->map_z = $map_z;
	}
	
	/**
	 * õ̵LOGO
	 * @param string $logo Logo
	 * @return void 
	 */
	function setLogo($logo) {
		$this->logo = $logo;
	}
	
	/**
	 * õ̵Ĺ
	 * @param string $bulletin ̵Ĺ
	 * @return void 
	 */
	function setBulletin($bulletin) {
		if ($bulletin) {
			$this->_validationFieldLenght($bulletin, 0, 1000, '̹泤Ȳܳ1000ֽ');
			$this->_filterWordsfb($bulletin, '̹');
		}		
		$this->bulletin = $bulletin;
	}
	
	/**
	 * õ̵Ĵʱ
	 * @param string $createtime ̵Ĵʱ
	 * @return void 
	 */
	function setCreatetime($createtime) {
		$this->createtime = $createtime;
	}
	
	/**
	 * õ̵޸ʱ
	 * @param string $modifytime ̵޸ʱ
	 * @return void 
	 */
	function setModifytime($modifytime) {
		$this->modifytime = $modifytime;
	}
	
	/**
	 * õ̵Ĺʱ
	 * @param string $overtime ̵Ĺʱ
	 * @return void 
	 */
	function setOvertime($overtime) {
		if ($overtime) $this->_validateOvertime(PwStrtoTime($overtime));
		$this->overtime = $overtime;
	}
	
	/**
	 * õ̵ĵID
	 * @param integer $areaid ̵ID
	 * @return void 
	 */
	function setAreaid($areaid) {
		$this->_validationRequired($areaid, 'ѡڵ');
		$this->areaid = $areaid;
	}
	
	/**
	 * õ̵ĵ
	 * @param string $area ̵
	 * @return void 
	 */
	function setArea($area) {
		$this->area = $area;
	}
	
	/**
	 * õ̵ҵID
	 * @param integer $parentid ҵID
	 * @return void 
	 */
	function setParentid($parentid) {
		$this->parentid = $parentid;
	}
	
	/**
	 * õ̵ҵ
	 * @param string $parent ҵ
	 * @return void 
	 */
	function setParent($parent) {
		$this->parent = $parent;
	}
	
	/**
	 * õ̵ķID
	 * @param integer $categoryid ̷ID
	 * @return void 
	 */
	function setCategoryid($categoryid) {
		$this->_validationRequired($categoryid, 'ѡһҵ');
		$this->categoryid = $categoryid;
	}
	
	/**
	 * õ̷
	 * @param string $category ̷
	 * @return void 
	 */
	function setCategory($category) {
		$this->category = $category;
	}
	
	/**
	 * õ̵Ƿ֤(1:Ϊ֤
	 * @param integer $ifcheck ̱֤״̬
	 * @return void 
	 */
	function setIfcheck($ifcheck) {
		$this->ifcheck = $ifcheck;
	}
	
	/**
	 * õ֤ʽ
	 * @param string $checkway ֤ķʽ
	 * @return void 
	 */
	function setCheckway($checkway) {
		$this->checkway = $checkway;
	}
	
	/**
	 * ʾĵ̵֤ʽ
	 * @param string $checkwayhtml ֤ʽʾ
	 * @return void 
	 */
	function setCheckwayhtml($checkwayhtml) {
		$this->checkwayhtml = $checkwayhtml;
	}
	
	/**
	 * õƼ
	 * @param string $recommendlevel ̵Ƽ
	 * @return void 
	 */
	function setRecommendlevel($recommendlevel) {
		$this->recommendlevel = $recommendlevel;
	}
	
	/**
	 * õ̵
	 * @param integer $hit ̵ĵ
	 * @return void 
	 */
	function setHit($hit) {
		$this->hit = $hit;
	}
	
	/**
	 * õ˵
	 * @param string $titles ˵ı
	 * @return void 
	 */
	function setTitles($titles) {
		$this->_validationRequired($titles, '˵ⲻΪ');
		$this->_validationFieldLenght($titles, 0, 20, '˵ĳȲܳ20ֽ');
		$this->_filterWordsfb($titles, '˵');
		$this->titles = trim($titles);
	}
	
	/**
	 * õ̵˵
	 * @param array $contentorder ('contentid' => array(),..) ̵˵
	 * @return void 
	 */
	function setContentorder($contentorder) {
		$this->contentorder = $contentorder;
	}
	
	/**
	 * õ̵ϵQQ
	 * @param string $qq ̵ϵQQ
	 * @return void 
	 */
	function setQq($qq) {
		if ($qq) {
			$this->_validationFieldInt($qq, 'ȷдQQţ');
			$this->_validationFieldLenght($qq, 5, 15, 'дQQӦ5-15λ֮');
			$this->_filterWordsfb($qq, 'QQ');
		}
		$this->qq = $qq;
	}
	
	/**
	 * õ̵ϵMSN
	 * @param string $msn ϵMSN
	 * @return void 
	 */
	function setMsn($msn) {
		if ($msn) {
			$this->_validationFieldEmail($msn, 'дMSNʽ');
			$this->_validationFieldLenght($msn, 0, 100, 'дMSNȲܴ100ֽ');
			$this->_filterWordsfb($msn, 'MSN');
		}		
		$this->msn = $msn;
	}
	
	/**
	 * õ̵ϵ
	 * @param string $wangwang ϵ
	 * @return void 
	 */
	function setWangwang($wangwang) {
		if ($wangwang) {
			$this->_validationFieldLenght($wangwang, 0, 100, 'дʺųڲܴ100ֽ');
			$this->_filterWordsfb($wangwang, '');
		}
		$this->wangwang = $wangwang;
	}
	
	/**
	 * õ̵ϵEmail
	 * @param string $email ̵ϵEmail
	 * @return void 
	 */
	function setEmail($email) {
		if ($email) {
			$this->_validationFieldEmail($email, 'дEmailʽ');
			$this->_validationFieldLenght($email, 0, 100, 'дEmailȲܴ100ֽ');
			$this->_filterWordsfb($email, 'Email');
		}		
		$this->email = $email;
	}

	/**
	 * õ̼ID
	 * @param integer $shangjiaid ̼ID
	 * @return void 
	 */
	function setShangjiaid($shangjiaid) {
		$this->shangjiaid = $shangjiaid;
	}
	
	/**
	 * õ̵̼ҹ˾
	 * @param string $company ̼ҹ˾
	 * @return void 
	 */
	function setCompany($company) {
		if ($company) {
			$this->_validationFieldLenght($company, 0, 100, '˾Ʋܳ100ֽ');
			$this->_filterWordsfb($company, '˾');
		}		
		$this->company = trim($company);
	}
	
	/**
	 * õ̵̼ҹ˾
	 * @param string $delegate ̼ҹ˾
	 * @return void 
	 */
	function setDelegate($delegate) {
		if ($delegate) {
			$this->_validationFieldLenght($delegate, 0, 15, '˴ܳ15ֽ');
			$this->_filterWordsfb($delegate, '˴');
		}		
		$this->delegate = trim($delegate);
	}
	
	/**
	 * õ̵̼ҹ˾ֻ
	 * @param string $delegatephone  ̼ҹ˾ֻ
	 * @return void 
	 */
	function setDelegatephone($delegatephone) {
		if ($delegatephone) {
			$this->_validationFieldLenght($delegatephone, 0, 30, 'ȷдֻ룡');
			$this->_filterWordsfb($delegatephone, 'ֻ');
		}		
		$this->delegatephone = trim($delegatephone);
	}
	
	/**
	 * õ̵Ĺ˾ַ
	 * @param string $companyaddress ̹˾ַ
	 * @return void 
	 */
	function setCompanyaddress($companyaddress) {
		if ($companyaddress) {
			$this->_validationFieldLenght($companyaddress, 0, 100, '˾ַȲܳ100ֽ');
			$this->_filterWordsfb($companyaddress, '˾ַ');
		}		
		$this->companyaddress = trim($companyaddress);
	}
	
	/**
	 * õ̵Ĺ˾绰
	 * @param string $companyphone ̵̼ҹ˾绰
	 * @return void 
	 */
	function setCompanyphone($companyphone) {
		if ($companyphone) {
			$this->_validationFieldLenght($companyphone, 0, 30, 'дȷĹ˾绰');
			$this->_filterWordsfb($companyphone, '˾绰');
		}		
		$this->companyphone = trim($companyphone);
	}
	
	/**
	 * õ̵̼ҹ˾Ĵ
	 * @param string $companyfax ̵̼ҹ˾
	 * @return void 
	 */
	function setCompanyfax($companyfax) {
		if ($companyfax) {
			$this->_validationFieldLenght($companyfax, 0, 30, 'дȷĴ');
			$this->_filterWordsfb($companyfax, '');
		}		
		$this->companyfax = trim($companyfax);
	}
	
	/**
	 * õ̵̼ҹ˾ʱ
	 * @param string $companyzipcode ̵̼ҹ˾ʱ
	 * @return void 
	 */
	function setCompanyzipcode($companyzipcode) {
		if ($companyzipcode) {
			$this->_validationFieldInt($companyzipcode, 'ʱΪ');
			$this->_validationFieldLenght($companyzipcode, 6, 8, 'ʱĳΪ6-8');
			$this->_filterWordsfb($companyzipcode, 'ʱ');
		}
		$this->companyzipcode = trim($companyzipcode);
	}
	
	/**
	 * ˵
	 * @access private
	 * @param string $content Ҫ˵ֵ
	 * @return string  ֵ֮
	 */
	function _filterContent($content) {
		$content = $this->_filterConvert($content);
		foreach (array('wmv', 'rm', 'flash') as $key => $value) {
			if (strpos(",{$GLOBALS['_G']['media']},", ",$value,") === false) {
				$content = preg_replace("/(\[$value=([0-9]{1,3}\,[0-9]{1,3}\,)?)1(\].+?\[\/$value\])/is", "\${1}0\\3", $content);
			}
		}
		$content = preg_replace(array("/<script.*>.*<\/script>/is", "/<(([^\"']|\"[^\"]*\"|'[^']*')*?)>/eis", 
			"/javascript/i"), array("", "\$this->_jscv('\\1')", "java script"), str_replace('.', '&#46;', $content));
		return $content;
	}
}
?>