<?php
/**
 * ļ
 * Ҫṩҵбװ
 * @author qiong.wuq
 * @author xiaoxia.xuxx
 * date 2010-09-20
 */
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';
/**
 * ࣬Ҫ̼פṩбװ
 * @method public createCategoryForAjax() ҵб
 * @method public createAreaLink() бб
 * @method private _getParentList()
 *
 */
class PW_ToolsHelper extends BaseHelper {
	/**
	 * ҵб
	 * @author xiaoxia.xuxx
	 * @param int $parentId ҪصҵĵĸIDҴصǸбIDΪĬ
	 * @param int $childId  ҪصҵбIDҴصбIDΪĬ
	 * @param boolean $isParent ÷صǸбб
	 * @param boolean $isEmpty  ÷صбǷҪȱʡѡֵ
	 * @return string عõб
	 */
	function createCategoryForAjax($parentId = '', $childId = '', $isParent = true, $isEmpty = true) {
		$categoriesService = $this->getCategoriesService();
		$categories = $categoriesService->getCategories();
		if (!$categories) {return false;}
		$_outputCategories = $_allHtml = '';
		if ($isParent) {
			$mode = $this->_getGlobal('m');
			$url = "'index.php?m=$mode&c=checkin&a=categorychildlist'";
			$_outputCategories = $this->_getParentList($categories, $parentId);
			$_allHtml = $this->_buildSelect($_outputCategories, 'categoryid', 'categoryid', $parentId, $isEmpty, 'onchange="tools.getChildCategory(' . $url . ', this);"', 'select_wa mr5');
		} else {
			$_outputCategories = $this->_getChildListByParentid($categories, $parentId);
			$_allHtml = $this->_buildSelect($_outputCategories, 'childid', 'childid', $childId, $isEmpty);
		}
		return trim($_allHtml);
	}

	/**
	 * ҵеи
	 * @author xiaoxia.xuxx
	 * @param array $categories  еҵ
	 * @return array array("id" => "value") طķ
	 */
	function _getParentList($categories) {
		if (!$categories) {return false;}
		$parent = array();
		foreach ($categories as $key => $category) {
			($category['parentid'] == 0) && $parent[$category['categoryid']] = $category['name'];
		}
		unset($categories);
		return $parent;
	}

	/**
	 * ҵеĳ
	 * @author xiaoxia.xuxx
	 * @param array $categories  ҵ
	 * @param integer $parentId    ҪĸID
	 * @return array array("id" => "value") طķ
	 */
	function _getChildListByParentid($categories, $parentId) {
		if (!$categories || !$parentId) {return false;}
		$childList = array();
		foreach ($categories as $key => $category) {
			($category['parentid'] == $parentId) &&  $childList[$category['categoryid']] = $category['name'];
		}
		unset($categories);
		return $childList;
	}

	/**
	 * 
	 * @author qiong.wuq
	 * @param int $areaId ID
	 * @param boolean $isEmpty ǷҪĬֵtrueΪҪ
	 * @return string װõб
	 */
	function createAreaLink($areaId = '',$isEmpty = false){
		$areaService = $this->getAreasService();
		$areas =  $areaService->getAreas();
		if(!$areas) return '';
		$tmp = array();
		foreach($areas as $a){
			$tmp[$a['areaid']] = $a['name'];
		}
		return $this->_buildSelect($tmp,'areaid','areaid',$areaId,$isEmpty);
	}

   /**
	* װ
	* @author qiong.wuq
	* @param array $arrays Ҫװ
	* @param string $name װselectname
	* @param string $id װselect ID
	* @param string $select Ĭϵѡ
	* @param boolean $isEmpty Ƿȱʡѡֵ
	* @param string $event װselectӦ¼
	* @param string $class װselectcssʽ
	* @return string װõб
	*/
	function _buildSelect($arrays, $name, $id, $select = '', $isEmpty = false,$event = '',$class = 'select_wa') {
		if (!is_array($arrays)) return '';
		if($name == 'childid') {
			$_default = "";
		}elseif($name == 'areaid') {
			$_default = "";
		}else{
			$_default = "ҵ";
		}
		$html = '<select title="' . $_default . '" name="' . $name . '" id="' . $id . '" class="'.$class.'" '.$event.'>';
		($isEmpty == true) && $html .= '<option value="">' . 'ѡ' .$_default . '</option>';
		foreach ($arrays as $k => $v) {
			$selected = ($select == $k && $select != null) ? 'selected="selected"' : "";
			$html .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
}