<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * ƷHelperʵ
 * @author L.iuHu.I
 */
class PW_ProductHelper extends BaseHelper {
	
	/**
	 * ӵƷ
	 * @param array $fieldData
	 * @return boolean
	 */
	function insertProduct($fieldData) {
		$productService = $this->getProductService();
		return $productService->addProduct($fieldData);
	}
	
	/**
	 * ƷIDƷ
	 * @param array $fieldData
	 * @param int $productId
	 * @return boolean
	 */
	function updateProduct($fieldData, $productId, $objectId) {
		$productService = $this->getProductService();
		return $productService->updateProduct($fieldData, $productId, $objectId);
	}
	
	/**
	 * Ʒ
	 * @param array $params
	 * @return boolean
	 */
	function addProducts($params) {
		if (!$this->_checkProducts($params['objectid'])) return false; //array(false, $message);
		$module = $this->_setProductModule($params);
		if ($module->get_error()) return false;
		$module->setAttach();
		$module->setCreatedTime($this->_getGlobal('timestamp'));
		$filedData = $this->_setProductParams($module);
		if (!($productId = $this->insertProduct($filedData))) return $this->_addError('Ʒʧ');
		$photoId = $this->addPhotos($module->attach, $productId, $params['objectid']);
		$photoId && $this->updateProduct(array('photoid' => $photoId), $productId, $params['objectid']);
		return true;
	}
	
	/**
	 * Ʒ
	 * @param int $dianpuId
	 * @return boolean
	 */
	function _checkProducts($dianpuId) {
		$dianpuService = $this->getDianpuService();
		if (!($dianpu = $dianpuService->getDianpu($dianpuId))) return $this->_addError('̲');
		$groupHelper = DP::loadClass('groupshelper', 'helper');
		$group = $groupHelper->getGroupInfo($dianpu->groupid);
		if (!$group) return $this->_addError('ûз');
		if (!isset($group['configinfo']['maxproduct'])) return true;
		$productService = $this->getProductService();
		$total = $productService->countProductsByObjectId($dianpuId);
		if ($group['configinfo']['maxproduct'] && ($total + 1) > $group['configinfo']['maxproduct']) return $this->_addError('ƷΪ' . $group['configinfo']['maxproduct']);
		return true;
	}
	
	/**
	 * ༭Ʒ
	 * @param array $params
	 * @param int $productId
	 * @param int $objectId
	 * @return boolean
	 */
	function editProducts($params, $productId, $objectId) {
		$productId = intval($productId);
		$objectId = intval($objectId);
		$cover = ($params['cover'] > 0) ? intval($params['cover']) : 0;
		$module = $this->_setProductModule($params);
		if (!$productId || $module->get_error() || !$objectId) return false; //return array(true, '');
		$module->setAttach();
		$filedData = $this->_setProductParams($module);
		if (!$this->updateProduct($filedData, $productId, $objectId)) return $this->_addError('Ʒ༭ʧ');
		$photoId = $this->addPhotos($module->attach, $productId, $objectId);
		if (!$cover) $cover = $photoId;
		($cover > 0) && $this->updateProduct(array('photoid' => $cover), $productId, $objectId);
		return true;
	}
	
	/**
	 * ƷͼƬ
	 * @param array $attach
	 * @param int $objectId
	 * @return boolean
	 */
	function addPhotos($attach, $objectId, $belongId) {
		$objectId = intval($objectId);
		$belongId = intval($belongId);
		if (!$attach || !S::isArray($attach) || $objectId < 1 || $belongId < 1) return $this->_addError('ƷͼƬʧ');
		$fieldDatas = array();
		foreach ($attach as $a) {
			$tmp['belongid'] = $belongId;
			$tmp['objectid'] = $objectId;
			$tmp['typeid'] = 1;
			$tmp['filename'] = trim($a['name']);
			$tmp['path'] = trim($a['fileuploadurl']);
			$tmp['createdtime'] = $this->_getGlobal('timestamp');
			$fieldDatas[] = $tmp;
		}
		$service = $this->getPhotossService();
		return $service->addPhotos($fieldDatas);
	}
	
	/**
	 * ɾƷͼƬ
	 * @param int $photoId
	 * @return boolean
	 */
	function deletephoto($photoId, $belongId) {
		$photoId = intval($photoId);
		$belongId = intval($belongId);
		if (!$photoId || !$belongId) {return array(false, 'ѡͼƬ');}
		$service = $this->getPhotossService();
		$photo = $service->getPhoto($photoId);
		if (!$photo) {return array(false, 'ͼƬ');}
		$photoPath = $this->_getGlobal('db_attachname') . '/' . $photo['path'];
		if (is_file($photoPath)) {
			@unlink($photoPath);
		}
		if (!$service->deleteByPhotoIdAndBelongId($photoId, $belongId)) {return array(false, 'ɾͼƬʧ');}
		return array(true, 'ɾͼƬɹ');
	}
	/**
	 * ˲ҷƷģ
	 * @param array $params
	 * @return PW_ProductModule
	 */
	function _setProductModule($params) {
		DP::loadClass('productmodule', 'module', false);
		$module = new PW_ProductModule();
		isset($params['productid']) && $module->setProductId($params['productid']);
		isset($params['objectid']) && $module->setObjectId($params['objectid']);
		isset($params['title']) && $module->setTitle($params['title']);
		isset($params['description']) && $module->setDescription($params['description']);
		isset($params['market_price']) && $module->setMarketPrice($params['market_price']);
		isset($params['member_price']) && $module->setMemberPrice($params['member_price']);
		isset($params['photoid']) && $module->setPhotoId($params['photoid']);
		isset($params['shelf']) && $module->setShelf($params['shelf']);
		isset($params['recommend']) && $module->setRecommend($params['recommend']);
		$module->setModifiedTime($this->_getGlobal('timestamp'));
		return $module;
	}
	
	/**
	 * Ʒṹ
	 * @param PW_ProductModule $module
	 * @return array
	 */
	function _setProductParams($module) {
		$params = array();
		(!is_null($module->productid)) && $params['productid'] = $module->productid;
		(!is_null($module->objectid)) && $params['objectid'] = $module->objectid;
		(!is_null($module->title)) && $params['title'] = $module->title;
		(!is_null($module->description)) && $params['description'] = $module->description;
		(!is_null($module->market_price)) && $params['market_price'] = $module->market_price;
		(!is_null($module->member_price)) && $params['member_price'] = $module->member_price;
		(!is_null($module->photoid)) && $params['photoid'] = $module->photoid;
		(!is_null($module->shelf)) && $params['shelf'] = $module->shelf;
		(!is_null($module->recommend)) && $params['recommend'] = $module->recommend;
		(!is_null($module->modifiedtime)) && $params['modifiedtime'] = $module->modifiedtime;
		(!is_null($module->createdtime)) && $params['createdtime'] = $module->createdtime;
		return $params;
	}
	
	/**
	 * ҳȡƷб
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getProducts($page, $perpage = 20) {
		$page = intval($page);
		$page = ($page > 0) ? $page : 1;
		$productService = $this->getProductService();
		$products = $productService->getProducts($page, $perpage);
		if (!$products) {return array();}
		return $this->_buildProducts($products);
	}
	
	/**
	 * ͳƷ
	 * @return int
	 */
	function countProducts() {
		$productService = $this->getProductService();
		return $productService->countProducts();
	}
	
	/**
	 * 駹ؼ¼Ʒ
	 * @param int $dianpuid
	 * @param string $keyword
	 * @param int $shelf (-1/1/0)
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function searchProductsByShelf($dianpuid, $keyword, $shelf, $page, $perpage = 20) {
		$shelf = $this->_checkShelf($shelf);
		$productService = $this->getProductService();
		if ($keyword == '') {
			$total = $productService->countByObjectIdAndShelfs($dianpuid, $shelf);
			$page = $this->_validePage($total, $page, $perpage);
			$total && $products = $productService->searchByShelf($dianpuid, $shelf, $page, $perpage);
		} else {
			$total = $productService->countByShelfAndTitle($dianpuid, $keyword, $shelf);
			$page = $this->_validePage($total, $page, $perpage);
			$total && $products = $productService->searchByShelfAndTitle($dianpuid, $keyword, $shelf, $page, $perpage);
		}
		return ($total) ? array($total, $this->_buildProducts($products)) : array(0, array());
	}
	
	/**
	 * ֤¼ܵĺϷ
	 * @param int $shelf
	 * @return array 
	 */
	function _checkShelf($shelf) {
		$shelf = in_array($shelf, array('-1', '1', '0')) ? $shelf : 1;
		if ($shelf == '-1') {
			$shelf = array(0, 1);
		} else {
			$shelf = array($shelf);
		}
		return $shelf;
	}
	
	/**
	 * ȡƷϢ
	 * @param int $productId
	 * @return boolean
	 */
	function getProduct($productId) {
		$productId = intval($productId);
		if (!$productId) {return false;}
		$productService = $this->getProductService();
		$product = $productService->getProduct($productId);
		if (!$product) {return false;}
		return $this->_buildProduct($product);
	}
	
	/**
	 * ƷжϸƷǷϼܲظƷϢ
	 * @param int $productId
	 * @return array(result,message) 
	 */
	function getProductWithShelf($productId) {
		$productId = intval($productId);
		if (!$productId) {return array(false, 'ѡƷ', '');}
		$productService = $this->getProductService();
		$product = $productService->getProduct($productId);
		if (!$product) {return array(false, 'Ʒ', '');}
		if (!$product['shelf']) {return array(false, 'ƷѾ¼', '');}
		return array(true, '', $this->_buildProduct($product));
	}
	
	/**
	 * Ʒ
	 * @param array $product
	 * @return array
	 */
	function _buildProduct($product) {
		if (!S::isArray($product)) return array();
		$service = $this->getPhotossService();
		$photos = $service->getPhotosByObjectId($product['productid']);
		$photonum = ($photos) ? count($photos) : 0;
		$product['photoadd'] = intval(5 - $photonum);
		$product['photonum'] = $photonum;
		$tmp = array();
		foreach ($photos as $photo) {
			$photo['path'] = $this->_getGlobal('db_attachname') . '/' . $photo['path'];
			$tmp[] = $photo;
		}
		$product['photos'] = $tmp;
		return $product;
	}
	
	/**
	 * Ʒ
	 * 1,ؼΪ.2,ӵ.3,Ʒ
	 * @param string $keyword
	 * @param string $type
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function searchProducts($keyword, $type, $page, $perpage) {
		if ($keyword == "") {
			list($total, $products) = $this->_searchProductsByNormal($page, $perpage);
		} elseif ($type == 1) {
			list($total, $products) = $this->_searchProductsByDianpu($keyword, $page, $perpage);
		} elseif ($type == 2) {
			list($total, $products) = $this->_searchProductsByTitle($keyword, $page, $perpage);
		}
		return ($total) ? array($total, $this->_buildProducts($products)) : array(0, array());
	}
	
	/**
	 * Ʒ
	 * @access private
	 * @param int $page
	 * @param int $perpage
	 * @return array 
	 */
	function _searchProductsByNormal($page, $perpage) {
		$products = array();
		$productService = $this->getProductService();
		$total = $productService->countProducts();
		$page = $this->_validePage($total, $page, $perpage);
		$total && $products = $this->getProducts($page, $perpage);
		return array($total, $products);
	}
	
	/**
	 * ݵƼƷ
	 * @param string $keyword
	 * @param int $page
	 * @param int $perpage
	 * @return array 
	 */
	function _searchProductsByDianpu($keyword, $page, $perpage) {
		$products = array();
		$dianpuService = $this->getDianpuService();
		$productService = $this->getProductService();
		$result = $dianpuService->searchForAdmin($keyword);
		if (!$result) return array(0, $products);
		$objectIds = array();
		foreach ($result as $dianpu) {
			$objectIds[] = $dianpu['dianpuid'];
		}
		$total = $productService->countByObjectIds($objectIds);
		$page = $this->_validePage($total, $page, $perpage);
		$total && $products = $productService->getsByObjectIds($objectIds, $page, $perpage);
		return array($total, $products);
	}
	
	/**
	 * ƷƷ
	 * @param string $keyword
	 * @param int $page
	 * @param int $perpage
	 * @return array 
	 */
	function _searchProductsByTitle($keyword, $page, $perpage) {
		$products = array();
		$productService = $this->getProductService();
		$total = $productService->countProductsByTitle($keyword);
		$page = $this->_validePage($total, $page, $perpage);
		$total && $products = $productService->searchProductsByTitle($keyword, $page, $perpage);
		return array($total, $products);
	}
	
	/**
	 * װƷ
	 * @param array $products
	 * @return array
	 */
	function _buildProducts($products) {
		if (!S::isArray($products)) {return array();}
		$objectIds = array();
		foreach ($products as $product) {
			$objectIds[] = $product['objectid'];
		}
		$dianpuService = $this->getDianpuService();
		$dianpus = $dianpuService->getDianpuListByIds($objectIds);
		$dianpuArray = array();
		foreach ($dianpus as $dianpu) {
			$dianpuArray[$dianpu['dianpuid']] = $dianpu['title'];
		}
		$tmp = array();
		foreach ($products as $product) {
			$product['format_createdtime'] = get_date($product['createdtime'], 'Y-m-d H:i');
			$product['dianpu'] = isset($dianpuArray[$product['objectid']]) ? $dianpuArray[$product['objectid']] : 'ĩ';
			$tmp[] = $product;
		}
		return $tmp;
	}
	
	/**
	 * Ʒ¼ܻɾƷ
	 * @param array $productIds
	 * @param string $doing
	 * @param int $objectId
	 * @return array
	 */
	function opereateProducts($productIds, $doing, $objectId) {
		if (!($productIds = $this->_checkProductIds($productIds))) {return array(false, 'ѡҪƷ');}
		if ($doing == 'shelf') {return $this->shelfProducts(array('shelf' => 0), $productIds, $objectId);}
		if ($doing == 'delete') {return $this->deleteProducts($productIds, $objectId);}
	}
	
	/**
	 * ƷIDĺϷ
	 * @param array $productIds
	 * @return array
	 */
	function _checkProductIds($productIds) {
		if (!S::isArray($productIds)) {return false;}
		$ids = array();
		foreach ($productIds as $productId) {
			$productId = intval($productId);
			($productId > 0) && $ids[] = $productId;
		}
		return $ids;
	}
	
	/**
	 * ƷIDϼ/¼Ʒ
	 * @param int $shelf (0/1) /¼״̬
	 * @param int $productId
	 * @param int $objectId
	 * @return array
	 */
	function shelfProduct($shelf, $productId, $objectId) {
		$objectId = intval($objectId);
		$productId = intval($productId);
		$shelf = in_array($shelf, array(0, 1)) ? $shelf : 0;
		if ($productId < 1) {return array(false, 'ѡҪƷ');}
		return $this->shelfProducts(array('shelf' => $shelf), array($productId), $objectId);
	}
	
	/**
	 * ƷIDϼƷ
	 * @param array $fieldData
	 * @param array $productIds
	 * @param int $objectId
	 * @return array 
	 */
	function shelfProducts($fieldData, $productIds, $objectId) {
		if (!S::isArray($productIds)) {return array(false, 'ѡҪɾƷ');}
		$productService = $this->getProductService();
		if (!$productService->updateProducts($fieldData, $productIds, $objectId)) {return array(false, 'Ʒʧ');}
		return array(true, 'Ʒɹ');
	}
	
	/**
	 * ƷIDɾƷ
	 * @param int $productId
	 * @param int $objectId
	 * @return array
	 */
	function deleteProduct($productId, $objectId) {
		$objectId = intval($objectId);
		$productId = intval($productId);
		if ($productId < 1 || $objectId < 1) {return array(false, 'ѡҪƷ');}
		return $this->deleteProducts(array($productId), $objectId);
	}
	
	/**
	 * ƷIDɾƷ
	 * @param array $productIds
	 * @param int $objectId
	 * @return array
	 */
	function deleteProducts($productIds, $objectId) {
		if (!S::isArray($productIds) || !$objectId) {return array(false, 'ѡҪɾƷ');}
		$productService = $this->getProductService();
		if (!($productService->deleteProducts($productIds, $objectId))) {return array(false, 'Ʒɾʧ');}
		return array(true, 'Ʒɾɹ');
	}
	
	/**
	 * ΪԱ̨ṩ
	 * @param array $productIds
	 * @return array
	 */
	function deletesForAdmin($productIds) {
		if (!S::isArray($productIds)) {return array(false, 'ѡҪɾƷ');}
		$productService = $this->getProductService();
		if (!($productService->deletesForAdmin($productIds))) {return array(false, 'Ʒɾʧ');}
		return array(true, 'Ʒɾɹ');
	}
	
	/**
	 * 駵IDȡƷ
	 * @param int $dianpuId
	 * @param int $page
	 * @param int $perpage
	 * @return array(total,products)
	 */
	function getProductsByDianpuId($dianpuId, $page, $perpage) {
		$dianpuId = intval($dianpuId);
		$page = intval($page);
		$productService = $this->getProductService();
		$total = $productService->countProductsByObjectId($dianpuId);
		if ($total) {
			$page = $this->_validePage($total, $page, $perpage);
			$result = $productService->getProductsByObjectId($dianpuId, $page, $perpage);
		}
		return ($total) ? array($total, $this->_buildProducts($result), $page) : array(0, array(), 0);
	}
	
	/**
	 * ҳĳ̼Ʒб
	 * @param int $dianpuId
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getProductsByDianpuIdWithShelf($dianpuId, $page, $perpage) {
		$dianpuId = intval($dianpuId);
		$page = intval($page);
		$productService = $this->getProductService();
		$total = $productService->countByObjectIdWithShelf($dianpuId);
		if ($total) {
			$page = $this->_validePage($total, $page, $perpage);
			$result = $productService->getsByObjectIdWithShelf($dianpuId, $page, $perpage);
		}
		return ($total) ? array($total, $this->_buildProducts($result), $page) : array(0, array(), 0);
	}
	
	/**
	 * ƷIDȡƷͼƬ
	 * @param int $productId
	 * @return array
	 */
	function getPhotosByProductId($productId) {
		$photoService = $this->getPhotossService();
		$photos = $photoService->getPhotosByObjectId($productId);
		if (!$photos) return array();
		$tmp = array();
		foreach ($photos as $v) {
			$v['path'] = $GLOBALS['db_attachname'] . '/' . $v['path'];
			$tmp[] = $v;
		}
		return $tmp;
	}
	
	/**
	 * װĬͼƬ
	 * @return array
	 */
	function getDefaultPhotos() {
		return array(array('path' => $this->_getDefaultPhoto()));
	}
	
	/**
	 * ȡĬͼƬ
	 * @return string
	 */
	function _getDefaultPhoto() {
		return 'mode/dianpu/images/default.jpg';
	}
	
	/**
	 * ƷIDȡƷб
	 * @param array $productIds
	 * @return array
	 */
	function getProductsByProductIds($productIds) {
		$productService = $this->getProductService();
		return $productService->getProductsByProductIds($productIds, true);
	}
	
	/**
	 * ȡƼƷ
	 * @param int $objectid
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getProductsByObjectIdWithRecommend($objectid, $page, $perpage) {
		$productService = $this->getProductService();
		return $productService->getProductsByObjectIdWithRecommend($objectid, $page, $perpage);
	}
	
	/**
	 * ͳƼƷ
	 * @param int $objectid
	 * @return int
	 */
	function countProductsByObjectIdWithRecommend($objectid) {
		$productService = $this->getProductService();
		return $productService->countProductsByObjectIdWithRecommend($objectid);
	}
	
	/**
	 * ҳõƼƷ
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getProductsWithRecommend($page, $perpage) {
		$productService = $this->getProductService();
		return $productService->getProductsWithRecommend($page, $perpage);
	}
	
	/**
	 * ͳƵƷ
	 * @return int
	 */
	function countProductsWithRecommend() {
		$productService = $this->getProductService();
		return $productService->countProductsWithRecommend();
	}
	
	/**
	 * ͨͳƻȡƷ
	 * @param $page
	 * @param $perpage
	 * @return array
	 */
	function getProductsWithHits($page, $perpage) {
		$productService = $this->getProductService();
		return $productService->getProductsWithHits($page, $perpage);
	}
	
	/**
	 * ͨͳͳƵƷ
	 * @return int
	 */
	function countProductsWithHits() {
		$productService = $this->getProductService();
		return $productService->countProductsWithHits();
	}
	
	/**
	 * Ʒ˵תƹ
	 * @param PW_DianpuModule $dianpu
	 * @return string
	 */
	function _filterContent($contents) {
		include_once R_P . 'require/bbscode.php';
		$contents = showface($contents);
		$contents = str_replace(array("\n", "\r\n"), '<br>', trim($contents, "\r\n \n \r"));
		$contents = convert($contents, $this->_getGlobal('db_windpost'));
		return $contents;
	}

}