<?php
!defined('M_P') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * Helperʵ
 * @author qiong
 */
class PW_GroupsHelper extends BaseHelper {
	
	/**
	 * õҳб
	 * @param integer $page ҳȡҳ
	 * @param integer $perpage ҳÿҳʾ
	 * @return array array(list, pages, start) طҳϢбҳʼλ)
	 */
	function getGroupsList($page, $perpage) {
		$service = $this->getGroupsService();
		$count = $service->getDianpuGroupsCount();
		list($page, $start) = $this->_validationPage($page, $count, $perpage);
		$list = $service->getDianpuGroupsByPages($start, $perpage);
		$pages = numofpage($count, $page, ceil($count / $perpage), $this->_getGlobal('basename') . '&action=groups&');
		return array($list, $pages, $start);
	}
	
	/**
	 * ӱ༭
	 * @param string $title 
	 * @param array $config Ϣ
	 * @param array $style 
	 * @param int $groupid ID
	 * @return boolean صǷɹ
	 */
	function insertGroup($title, $config, $style, $defaultstyle, $groupid = 0) {
		$service = $this->getGroupsService();
		if (empty($title)) return $this->_addError('ƲΪ');
		if (!is_array($config) || empty($config)) return $this->_addError('ϢΪ');
		if (!is_array($style) || empty($style)) return $this->_addError('ѡһ');
		$_styleData = array();
		foreach ($style as $key => $value) {
			if ($value == $defaultstyle) {
				$_styleData['default'] = $value;
			} else {
				$_styleData[] = $value;
			}
		}
		$config['maxproduct'] = str_replace(array('-'), '', (int) $config['maxproduct']);
		$config['maxexplain'] = str_replace(array('-'), '', (int) $config['maxexplain']);
		$_fieldData = array('title' => $title, 'configinfo' => $config, 'styles' => $_styleData, 'state' => '1');
		if (!$groupid) {
			$_fieldData['createtime'] = $this->_getGlobal('timestamp');
			$service->insertDianpuGroup($_fieldData);
			$service->updateDianpuGroupCache();
			return true;
		} else {
			$service->updateDianpuGroup($_fieldData, $groupid);
			$service->updateDianpuGroupCache();
			return true;
		}
		return false;
	}
	
	/**
	 * ݵIDõϢ
	 * @param integer $gid ID
	 * @return mixed  boolean(false:ȡʧ) | array array('ֶ' => 'ֵ') صϢ
	 */
	function getGroupInfo($gid) {
		if (!$gid) return $this->_addError('ѡһûб༭');
		$service = $this->getGroupsService();
		$group = $service->getGroupInfo($gid);
		if ($group) return $group;
		return $this->_addError('ûϢʧܣ');
	}
	
	/**
	 * ݵIDɾϢ
	 * @param integer $gid ҪɾĵID
	 * @return boolean ɾ
	 */
	function delete($gid) {
		if (!$gid) return $this->_addError('ѡҪɾĵ飡');  
		$dianpuService = $this->getDianpuService();
		if ($dianpuService->search(array('groupid' => array($gid, 'eq')))) return $this->_addError('õеݣɾõ飡');
		$service = $this->getGroupsService();
		if ($service->deleteDianpuGroup($gid)) return true;
		return $this->_addError('ɾʧ');  
	}
	
	/**
	 * пõķб
	 * @return array ؿõķб
	 */
	function getStylesList() {
		$service = $this->getStylesService();
		return $service->getStyles();
	}
	
	/**
	 * ķҳҳÿҳ
	 * @access private
	 * @param integer $page ҳ
	 * @param integer $count 
	 * @param integer $perpage ÿҳʾ
	 * @return array array(ҳʼλ)
	 */
	function _validationPage($page, $count, $perpage) {
		$page = $page > ceil($count / $perpage) ? ceil($count / $perpage) : $page;
		$page = (int) $page <= 0 ? 1 : $page;
		$start = ($page - 1) * $perpage;
		return array($page, $start);
	}
	
	/**
	 * õ̷ĬϷ
	 * @access private
	 * @param array $allStyles пõĵ̷
	 * @param array $groupstyles еķ
	 * @return array array(пõĵ̷Ĭϵĵ̷
	 */
	function _getStyles($allStyles, $groupstyles = array()) {
		if (!$allStyles) return array(array(), '');
		foreach ($allStyles as $key => $value) {
			unset($allStyles[$key]);
			$allStyles[$value['styleid']] = $value;
		}
		$_styles = array();
		//Ĭϵ̷
		$_default = '';
		if (is_array($groupstyles)) $_default = $groupstyles['default'];
		if (!$_default || !array_key_exists($_default, $allStyles)) {
			$_any = array_slice($allStyles, 0, 1);
			$_default = $_any[0]['styleid'];
		}
		if ($_default) $allStyles[$_default]['checked_default'] = '1';
		return array($allStyles, $_default);
	}
	
	/**
	 * õǰʹõķ
	 * @param array $allStyles пõĵ̷
	 * @param array $groupstyles еķ
	 * @param array $current ǰõķ
	 * @return array õǰӦ÷
	 */
	function getCurrentStyle($allStyles, $groupstyles = array(), $current = '') {
		if (!$allStyles) return '';
		list($allStyles, $_default) = $this->_getStyles($allStyles, $groupstyles);
		if (!$current || !array_key_exists($current, $allStyles)) $current = $_default;
		return $allStyles[$current];
	}
	
	/**
	 * пõķ
	 * @param array $allStyles
	 * @param array $groupstyles
	 * @return array  зϢעѱѡķϢ
	 */
	function getAllStyles($allStyles, $groupstyles = array()) {
		list($allStyles, $_default) = $this->_getStyles($allStyles, $groupstyles);
		$flag = false;
		foreach ($allStyles as $key => $value) {
			if (in_array($key, $groupstyles)) {
				$allStyles[$key]['checked'] = '1';
				$flag = true;
			}
		}
		if (!$flag && $_default) $allStyles[$_default]['checked'] = '1';
		return $allStyles;
	}
	
	/**
	 * õķ
	 * @param array $allStyles
	 * @param array $groupstyles
	 * @param string $current
	 * @return array 
	 */
	function getGroupStyle($allStyles, $groupstyles = array(), $current = '') {
		list($allStyles, $_default) = $this->_getStyles($allStyles, $groupstyles);
		if (!$current || !array_key_exists($current, $allStyles)) $current = $_default;
		$_result = array();
		foreach ($groupstyles as $key => $value) {
			if (array_key_exists($value, $allStyles)) $_result[$value] = $allStyles[$value];
		}
		if (!$_result && $_default) $_result = array($_default => $allStyles[$_default]);
		if (array_key_exists($current, $_result)) $_result[$current]['checked'] = '1';
		return $_result;
	}
	
	/**
	 * ĬϵĵϢ
	 * @return array ĬϵϢ
	 */
	function getDefaultGroupConfig() {
		return array('dianpushow' => '1', 'uploadlogo' => '1', 'comments' => '1', 'productshow' => '1', 
			'wangwang' => '1', 'qq' => '1', 'maxproduct' => '12', 'maxexplain' => '5', 'recommendshow' => '1', 
			'styleid' => '1');
	}
	
	/**
	 * õϢ
	 * @param array $configinfo Ϣ
	 * @return stdClass  õϢĶ
	 */
	function getDianpuGroupsConfig($configinfo) {
		$_config = new stdClass();
		ifcheck($configinfo['dianpushow'], 'dianpushow');
		ifcheck($configinfo['comments'], 'comments');
		ifcheck($configinfo['wangwang'], 'wangwang');
		ifcheck($configinfo['qq'], 'qq');
		ifcheck($configinfo['uploadlogo'], 'uploadlogo');
		ifcheck($configinfo['productshow'], 'productshow');
		ifcheck($configinfo['recommendshow'], 'recommendshow');
		$_config->uploadlogo_Y = $this->_getGlobal('uploadlogo_Y');
		$_config->uploadlogo_N = $this->_getGlobal('uploadlogo_N');
		$_config->comments_Y = $this->_getGlobal('comments_Y');
		$_config->comments_N = $this->_getGlobal('comments_N');
		$_config->wangwang_Y = $this->_getGlobal('wangwang_Y');
		$_config->wangwang_N = $this->_getGlobal('wangwang_N');
		$_config->qq_Y = $this->_getGlobal('qq_Y');
		$_config->qq_N = $this->_getGlobal('qq_N');
		$_config->dianpushow_Y = $this->_getGlobal('dianpushow_Y');
		$_config->dianpushow_N = $this->_getGlobal('dianpushow_N');
		$_config->productshow_Y = $this->_getGlobal('productshow_Y');
		$_config->productshow_N = $this->_getGlobal('productshow_N');
		$_config->recommendshow_Y = $this->_getGlobal('recommendshow_Y');
		$_config->recommendshow_N = $this->_getGlobal('recommendshow_N');
		return $_config;
	}
}
?>