<?php
!defined('M_P') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * Helperʵ
 * @author qiong
 */
class PW_DianpuHelper extends BaseHelper {
	
	/**
	 * бʵ
	 * @param string $title Ĺؼ
	 * @param integer $type  ownerΪdianpuΪ
	 * @param integer $areaid ̵ID
	 * @param integer $categoryid ̷ID
	 * @param integer $page ̷ҳҳ
	 * @param integer $perpage ̷ҳÿҳʾ
	 * @return array صϢб
	 */
	function getDianpuList($title, $type, $areaid, $parentid, $categoryid, $page, $perpage = 20) {
		$_dianpuService = $this->getDianpuService();
		$_dianpus = array();
		$pageUrl = $this->_getGlobal('basename') . "&act_title=" . urlencode(stripslashes($title)) . '&areaid=' . $areaid . '&categoryid=' . $parentid . '&childid=' . $categoryid . '&type=' . trim($type);
		$owner = "";
		if ($type == 'owner') {
			$owner = $title;
			$title = "";
		}
		if (($count = $_dianpuService->getCount($title, $owner, $areaid, $categoryid, $parentid)) > 0) {
			list($page, $start) = $this->_validationPage($page, $count, $perpage);
			$_dianpus = $_dianpuService->searchForAdmin($title, $owner, $areaid, $categoryid, $parentid, $start, $perpage);
			$_pages = numofpage($count, $page, ceil($count / $perpage), $pageUrl . '&');
		}
		return array($this->_buildDianpu($_dianpus), $_pages);
	}
	
	/**
	 * ̨ͨ
	 * @param $title
	 * @param $type
	 * @param $page
	 * @param $perpage
	 */
	function searchForVerify($title, $type, $page, $perpage = 20) {
		$_dianpuService = $this->getDianpuService();
		$_dianpus = array();
		$pageUrl = $this->_getGlobal('basename') . '&act_title=' . urlencode(stripslashes($title)) . '&action=searchverify&step=2&type=' . urlencode(trim($type));
		$owner = "";
		if ($type == 'owner') {
			$owner = $title;
			$title = "";
		}
		if (($count = $_dianpuService->getCountByVerify($title, $owner)) > 0) {
			list($page, $start) = $this->_validationPage($page, $count, $perpage);
			$_dianpus = $_dianpuService->searchForVerify($title, $owner, $start, $perpage);
			$_pages = numofpage($count, $page, ceil($count / $perpage), $pageUrl . '&');
		}
		return array($this->_buildDianpu($_dianpus), $_pages);
	}
	
	/**
	 * ǰ̨
	 * @modified xiaoxia.xuxx@2010-09-25 
	 * @modified reason: ǰ̨бҳҳȷԭʧcategoryidֵ
	 * @param integer $areaid ID
	 * @param integer $parentid ҵID
	 * @param integer $categoryid ID
	 * @param intger $checkway ֤ʽ
	 * @param string $orderby ʽ
	 * @param string $title ̵ı
	 * @param string $baseUrl ҳURL
	 * @param integer $page Ҫҳҳ
	 * @param integer $perpage ÿҳʾ
	 * @return array(dianpulist, pager) 
	 **/
	function searchForDianpu($areaid = '', $parentid = '', $categoryid = '', $checkway = '', $orderby = '', $title = '', $baseUrl, $page, $perpage = 20) {
		$areaid = intval($areaid);
		$parentid = (intval($parentid) > 0) ? intval($parentid) : 0;
		$categoryid = (intval($categoryid) > 0) ? intval($categoryid) : 0;
		$page = intval($page);
		$childid = ($categoryid == 0) ? $parentid : $categoryid; //parentidcategoryidͳһΪcategoryidcategoryidΪ0ʾɸѡparentidҵµзеĵ̣ҳݵʱֻҪcategoryidһֵ
		$checkWayStr = (S::isArray($checkway)) ? implode('|', $checkway) : ''; //֤ɸѡķҳ
		$pageurl = $baseUrl . '&categoryid=' . $childid . '&areaid=' . $areaid . '&verify=' . $checkWayStr . '&orderby=' . $orderby . '&atc_title=' . urlencode(stripslashes($title)) . '&'; //ҳurl
		$orderby = ($orderby == 1) ? 'recommendlevel' : 'hit'; //òѯ
		$checkway = $this->_getCheckWay($checkway); //òѯ 
		$_dianpuService = $this->getDianpuService();
		$count = $_dianpuService->getCountForList($areaid, $parentid, $categoryid, $checkway, addslashes($title), $orderby);
		if ($count) {
			list($page, $start) = $this->_validationPage($page, $count, $perpage);
			$_dianpus = $_dianpuService->searchForList($areaid, $parentid, $categoryid, $checkway, addslashes($title), $orderby, '', $start, $perpage);
			$_pages = numofpage($count, $page, ceil($count / $perpage), $pageurl);
		}
		return array($this->_buildDianpu($_dianpus), $_pages);
	}
	
	/**
	 * õ̵֤ʽ
	 * @access private 
	 * @param array $checkway ֤ʽ
	 */
	function _getCheckWay($checkway) {
		if (!S::isArray($checkway)) return array();
		$maps = array(1 => 'vip', 2 => 'verify', 3 => 'mobile');
		$tmp = array();
		foreach ($checkway as $c) {
			isset($maps[$c]) && $tmp[] = $maps[$c];
		}
		return $tmp;
	}
	
	/**
	 * ״̬ı
	 * @param array $ids
	 * @param int $state
	 * @return array
	 */
	function stateDianpu($ids, $state) {
		if (empty($ids)) return array(false, "ѡҪĵ̣");
		if (!is_array($ids)) $ids = array($ids);
		$result = $this->getDianpuService()->closeDianpuMulit($ids, $state);
		if ($result) return array(true, "ɹ");
		return array(false, "ʧܣ");
	}
	
	/**
	 * ӵʵ
	 * @param array $params
	 * array('username','groupid','title','areaid',
	 * 'categoryid','address','phone','logo',
	 * 'businfo','bulletin')
	 * @return array
	 */
	function addDianpu($params) {
		$service = $this->getDianpuService();
		$dianpu = $this->_setDianpu($params);
		if (count($service->searchForAdmin('', $dianpu->username, '', '', '', 0, 1))) {
			Error::addError("õѾڵ̣");
			return false;
		}
		if ($dianpu->url && count($service->search(array('url' => array($dianpu->url, 'eq'))))) {
			Error::addError("ĵַѾڣ");
			return false;
		}
		if ($service->searchForAdmin($dianpu->title, '', '', '', '', 0, 1)) {
			Error::addError("ĵѾڣ");
			return false;
		}
		$dianpu->setCreatetime($this->_getGlobal('timestamp'));
		if ($dianpu->get_error()) return false;
		$did = $service->insertDianpu($dianpu);
		if ($did && $this->setDianpuLogo($did)) return $did;
		Error::addError("ӵʧ");
		return false;
	}
	
	/**
	 * ༭ʵ
	 * @param array $params
	 * array('username','groupid','title','areaid',
	 * 'categoryid','address','phone','logo',
	 * 'businfo','bulletin')
	 * @return array
	 */
	function editDianpu($params, $id) {
		$service = $this->getDianpuService();
		$conditions['username'] = array($params['username'], 'eq');
		if ($params['username'] && $params['old_username'] != $params['username'] && count($service->search($conditions, 0, 1))) return $this->_addError('õѾڵ');
		if ($params['url'] && $params['old_url'] != $params['url'] && count($service->search(array(
			'url' => array($params['url'], 'eq'))))) return $this->_addError('ĵַѾ');
		$_dianpus = $service->search(array('title' => array($params['title'], 'eq')));
		foreach ($_dianpus as $key => $value) {
			if ($value['dianpuid'] != $id) return $this->_addError('ĵѾ');
		}
		$dianpu = $this->_setDianpu($params);
		$dianpu->setDianpuid($id);
		if (isset($params['orders'])) {
			list($orders, $dels) = $this->_setDianpuOrders($params['orders'], $params['contentorder']);
			$dianpu->setContentorder($orders);
		}
		if ($dianpu->get_error()) return false;
		if ($dels && !$service->deleteDianpuContents($dels)) return false;
		if ($service->updateDianpu($dianpu) && $this->setDianpuLogo($id)) return true;
		Error::addError("༭ʧ");
		return false;
	}
	
	/**
	 * 
	 * @access private
	 * @param array $orders
	 * @param array $contentOrders
	 * @return array
	 */
	function _setDianpuOrders($orders, $contentOrders) {
		$_temp = $_del = array();
		foreach ((array) $contentOrders as $key => $value) {
			if (array_key_exists($key, (array) $orders)) {
				$_temp[$key]['o'] = (int) $orders[$key];
				$_temp[$key]['t'] = $contentOrders[$key]['t'] ? $contentOrders[$key]['t'] : '';
			} else {
				$_del[] = $key;
			}
		}
		return array($_temp, $_del);
	}
	
	/**
	 * ӵ
	 * @param array $params
	 * @return boolean
	 */
	function addContents($params) {
		if (($titleorder = $this->_validationForDianpuContents($params)) === false) return false;
		$service = $this->getDianpuService();
		$dianpu = $this->_setDianpu($params);
		$dianpu = $this->_paramsMapping($params);
		$dianpu->titlesorder = ($titleorder + 1);
		if ($dianpu->_error) return false;
		if ($service->insertDianpuContent($dianpu)) return true;
		Error::addError('ӵʧ');
		return false;
	}
	
	/**
	 * ༭
	 * @param array $params
	 * @return boolean
	 */
	function editContents($params) {
		if (($this->_validationForDianpuContents($params)) === false) return false;
		$service = $this->getDianpuService();
		$dianpu = $this->_paramsMapping($params);
		if ($dianpu->_error) return false;
		if ($service->updateDianpuContent($dianpu, $params['contentid'])) return true;
		Error::addError('༭ʧ');
		return false;
	}
	
	/**
	 * IDȡ
	 * @param unknown_type $contentid
	 * @return boolean | array
	 */
	function getDianpuContent($contentid) {
		if (!$contentid) return $this->_addError('Ƿ');
		$service = $this->getDianpuService();
		if (!$dianpu = $service->getDianpuContent($contentid)) return $this->_addError('ȡʧ');
		return $dianpu;
	}
	
	/**
	 * ˲ص̶
	 * @access private
	 * @param array $params
	 * @return PW_DianpuModule
	 */
	function _paramsMapping($params) {
		DP::loadClass('dianpumodule', 'module', false); /* @var $dianpu PW_DianpuModule */
		$dianpu = new PW_DianpuModule();
		isset($params['dianpuid']) && $dianpu->setDianpuid($params['dianpuid']);
		isset($params['atc_content']) && $dianpu->setContents($params['atc_content']);
		isset($params['titles']) && $dianpu->setTitles($params['titles']);
		isset($params['contentorder']) && $dianpu->setContentorder($params['contentorder']);
		return $dianpu;
	}
	
	/**
	 * ɾ˵ҳ
	 * @param int $dianpuid
	 * @param int $contentid
	 * @return boolean
	 */
	function deletePage($dianpuid, $contentid) {
		$service = $this->getDianpuService();
		if (!$service->deleteDianpuContentByCid($contentid)) return $this->_addError('ɾݲʧ');
		$dianpu = $service->getDianpu($dianpuid);
		$contentorder = $dianpu->contentorder;
		foreach ((array) $contentorder as $key => $value) {
			if ($contentid == $key) unset($contentorder[$key]);
		}
		if (!$service->updateDianpu($this->_paramsMapping(array('dianpuid' => $dianpuid, 
			'contentorder' => $contentorder)))) return $this->_addError('µʧ');
		return true;
	}
	
	/**
	 * ɾlogo
	 * @param int $id
	 * @return boolean
	 */
	function deleteLogo($id) {
		$service = $this->getDianpuService();
		DP::loadClass('dianpumodule', 'module', false); /* @var $dianpu PW_DianpuModule */
		$dianpu = new PW_DianpuModule();
		$dianpu->setDianpuid($id);
		$dianpu->setLogo('');
		if ($service->updateDianpu($dianpu)) return true;
		return false;
	}
	
	/**
	 * õlogo
	 * @param int $did
	 * @return boolean
	 */
	function setDianpuLogo($did) {
		DP::loadClass('dianpulogoupload', '', false);
		if (!PwUpload::getUploadNum()) return true;
		$logoimg = new PW_DianpuLogoUpload($did);
		PwUpload::upload($logoimg);
		if (!$logo = $logoimg->getLogo()) return $this->_addError('ϴLogoʧܣǳߴ߸ʽ֧');
		DP::loadClass('dianpumodule', 'module', false);
		$dianpu = new PW_DianpuModule(); /* @var $dianpu PW_DianpuModule */
		$dianpu->setLogo($logo);
		$dianpu->setDianpuid($did);
		$service = $this->getDianpuService();
		$service->updateDianpu($dianpu);
		return true;
	}
	
	/**
	 * õϢ
	 * @access private
	 * @param array $params
	 * @return PW_DianpuModule 
	 */
	function _setDianpu($params) {
		DP::loadClass('dianpumodule', 'module', false); /* @var $dianpu PW_DianpuModule */
		$dianpu = new PW_DianpuModule();
		isset($params['username']) && $dianpu->setUsername($params['username']);
		isset($params['groupid']) && $dianpu->setGroupid($params['groupid']);
		isset($params['title']) && $dianpu->setTitle($params['title']);
		isset($params['areaid']) && $dianpu->setAreaid($params['areaid']);
		isset($params['categoryid']) && $dianpu->setCategoryid($params['categoryid']);
		isset($params['parentid']) && $dianpu->setParentid($params['parentid']);
		isset($params['address']) && $dianpu->setAddress($params['address']);
		isset($params['phone']) && $dianpu->setPhone($params['phone']);
		isset($params['areanumber']) && $dianpu->setAreanumber($params['areanumber']);
		isset($params['businfo']) && $dianpu->setBusinfo($params['businfo']);
		isset($params['bulletin']) && $dianpu->setBulletin($params['bulletin']);
		isset($params['titles']) && $dianpu->setTitles($params['titles']);
		isset($params['recommendlevel']) && $dianpu->setRecommendlevel($params['recommendlevel']);
		isset($params['url']) && $dianpu->setUrl($params['url']);
		isset($params['mapx']) && $dianpu->setMap_x($params['mapx']);
		isset($params['mapy']) && $dianpu->setMap_y($params['mapy']);
		isset($params['mapz']) && $dianpu->setMap_z($params['mapz']);
		isset($params['style']) && $dianpu->setTempstyle($params['style']);
		isset($params['operator']) && $dianpu->setOperator($params['operator']);
		isset($params['operatorphone']) && $dianpu->setOperatorphone($params['operatorphone']);
		isset($params['shangjiaid']) && $dianpu->setShangjiaid($params['shangjiaid']);
		isset($params['company']) && $dianpu->setCompany($params['company']);
		isset($params['delegate']) && $dianpu->setDelegate($params['delegate']);
		isset($params['delegatephone']) && $dianpu->setDelegatephone($params['delegatephone']);
		isset($params['companyaddress']) && $dianpu->setCompanyaddress($params['companyaddress']);
		isset($params['companyphone']) && $dianpu->setCompanyphone($params['companyphone']);
		isset($params['companyfax']) && $dianpu->setCompanyfax($params['companyfax']);
		isset($params['companyzipcode']) && $dianpu->setCompanyzipcode($params['companyzipcode']);
		isset($params['checkway']) && $dianpu->setCheckway(implode(',', (array) $params['checkway']));
		isset($params['ifcheck']) && $dianpu->setIfcheck($params['ifcheck']);
		isset($params['state']) && $dianpu->setState($params['state']);
		isset($params['qq']) && $dianpu->setQq($params['qq']);
		isset($params['msn']) && $dianpu->setMsn($params['msn']);
		isset($params['wangwang']) && $dianpu->setWangwang($params['wangwang']);
		isset($params['email']) && $dianpu->setEmail($params['email']);
		isset($params['overtime']) && $dianpu->setOvertime($params['overtime']);
		$dianpu->setModifytime($this->_getGlobal('timestamp'));
		return $dianpu;
	}
	
	/**
	 * ݵIDõϢ
	 * @param integer $id ID
	 * @return PW_DianpuModule
	 */
	function getDianpuInfo($id) {
		if (empty($id)) return $this->_addError('ѡҪ༭ĵ̣');
		$service = $this->getDianpuService();
		$dianpu = $service->getDianpu($id);
		return $dianpu;
	}
	
	/**
	 * ݵ̵ֻõϢ
	 * @param string $userName 
	 * @return mixed boolean (false:ʧ) | PW_DianpuModule
	 */
	function getDianpuInfoByUser($userName = '') {
		if (!$userName) $userName = $this->_getGlobal('windid');
		$service = $this->getDianpuService();
		if (!$dianpu = $service->getDianpuByUser($userName)) return $this->_addError('δͨκε');
		return $dianpu;
	}
	
	/**
	 * ϴļ
	 * @return array
	 */
	function getUploadFileType() {
		$db_uploadfiletype = $this->_getGlobal('db_uploadfiletype');
		$uploadfiletype = ($db_uploadfiletype) ? unserialize($db_uploadfiletype) : '';
		$filetypeinfo = $filetype = '';
		if ($uploadfiletype) {
			foreach ($uploadfiletype as $type => $size) {
				$filetype .= ' ' . $type . ' ';
				$filetypeinfo .= $type . ":" . $size . "KB; ";
			}
		}
		return array($filetype, $filetypeinfo);
	}
	
	/** 
	 * ˷ҳѯĿʼλúͲѯ
	 * @param integer $page 
	 * @param integer $count
	 * @param integer $perpage
	 * @return array
	 */
	function _validationPage($page, $count, $perpage) {
		$page = $page > ceil($count / $perpage) ? ceil($count / $perpage) : $page;
		$page = (int) $page <= 0 ? 1 : $page;
		$start = ($page - 1) * $perpage;
		return array($page, $start);
	}
	
	/**
	 * ȡĩ˵ĵ
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getUnVerifyDianpus($page, $perpage) {
		$page = intval($page);
		$start = ($page - 1) * $perpage;
		$service = $this->getDianpuService();
		$count = $service->countUncheckDianpuList();
		if (!$count) return array(array(), '');
		list($page, $start) = $this->_validationPage($page, $count, $perpage);
		$lists = $service->getUncheckDianpuList($start, $perpage);
		$pager = numofpage($count, $page, ceil($count / $perpage), $this->_getGlobal('basename') . '&action=verify&');
		return array($this->_buildDianpu($lists), $pager);
	}
	
	/**
	 * װ
	 * @param array $lists
	 * @return array
	 */
	function _buildDianpu($lists) {
		if (!S::isArray($lists)) return array();
		$categoryIds = $areaIds = array();
		foreach ($lists as $list) {
			$categoryIds[] = $list['categoryid'];
			$areaIds[] = $list['areaid'];
		}
		$categoriesService = $this->getCategoriesService();
		$areasService = $this->getAreasService();
		$categories = $categoriesService->linkCategories($categoryIds);
		$areas = $areasService->getAreasByIds($areaIds);
		$tmp = array();
		foreach ($lists as $list) {
			$category = ($categories[$list['categoryid']]) ? $categories[$list['categoryid']] : '';
			$list['parent'] = $category ? $category['parent'] : 'ĩҵ';
			$list['child'] = $category ? $category['child'] : 'ĩ';
			$list['area'] = isset($areas[$list['areaid']]) ? $areas[$list['areaid']] : 'ĩ';
			$tmp[] = $list;
		}
		return $tmp;
	}
	
	/**
	 *  ɾ
	 * @param int $doing
	 * @param array $dianpuIds
	 * @return boolean;
	 */
	function batchVerify($doing, $dianpuIds) {
		if (!$doing) return $this->_addError('Ƿ');
		if (!$dianpuIds) return $this->_addError('ѡҪĵ̣');
		if ($doing == 'open') {
			if (!$this->checkDianpu($dianpuIds, 1)) return $this->_addError('˲ʧܣ');
		} elseif ($doing == 'delete') {
			if (!$this->deleteDianpus($dianpuIds)) return $this->_addError('ɾʧܣ');
		}
		return true;
	}
	
	/**
	 * ɾ
	 * @param array $dianpuIds
	 * @return boolean
	 */
	function deleteDianpus($dianpuIds) {
		if (!S::isArray($dianpuIds)) return $this->_addError('ѡɾĵ̣');
		$this->_sendCheckDianpuMessages($dianpuIds, false);
		$service = $this->getDianpuService();
		if (!$service->deleteDianpuMulit($dianpuIds)) return $this->_addError('ɾʧܣ');
		return true;
	}
	
	/**
	 * ̼ID̼Ϣ
	 * @param int $shangjiaid
	 * @return array
	 */
	function getShangjia($shangjiaid) {
		if (!$shangjiaid) return array();
		$_dianpuService = $this->getDianpuService();
		$_tmp = $_dianpuService->getShangjia($shangjiaid);
		return $_tmp;
	}
	
	/**
	 * ܾͨ
	 * @param array $ids
	 * @param int $ifcheck (0/1)
	 * @return boolean
	 */
	function checkDianpu($ids, $ifcheck) {
		if (empty($ids)) return $this->_addError('ѡҪĵ̣');
		if (!is_array($ids)) $ids = array($ids);
		$result = $this->getDianpuService()->checkDianpuMulit($ids, $ifcheck);
		if (!$result) return $this->_addError('ʧܣ');
		$this->_sendCheckDianpuMessages($ids, $ifcheck);
		return true;
	}
	
	/**
	 * Ϣ֪ͨûܾ̿ͨ
	 * @param array $dianpuIds
	 * @param boolean $isCheck
	 * @return boolean
	 */
	function _sendCheckDianpuMessages($dianpuIds, $isCheck = true) {
		$dianpuService = $this->getDianpuService();
		$dianpus = $dianpuService->getDianpuListByIds($dianpuIds);
		if (!S::isArray($dianpus)) return false;
		$userNames = array();
		foreach ($dianpus as $dianpu) {
			$dianpu['username'] && $userNames[] = $dianpu['username'];
		}
		if (!S::isArray($userNames)) return false;
		if ($isCheck) {
			$messageInfo = array('title' => 'ĵѾͨ', 
				'content' => 'ϲ㣬ĵѾͨˣͨҵĿ̼ͨҵҳɽ̨̹صĹúƷϴ⣬ϵվ');
		} else {
			$messageInfo = array('title' => 'Բĵδͨ', 
				'content' => 'ԲύĵϢʱϱվҪȷϺٴύϵվ');
		}
		return M::sendNotice($userNames, $messageInfo);
	}
	
	/**
	 * õϢ ָ֧ʽ select / txt / array
	 * @param int $gid
	 * @param string $type (txt,select,array)
	 * @return string
	 */
	function getDianpuGroups($gid = '', $type = 'select') {
		$groupservice = $this->getGroupsService();
		if ($type == 'txt' && $gid) {
			$group = $groupservice->getGroupById($gid);
			return $group['title'];
		}
		if ($type == 'array' && $gid) {return $groupservice->getGroupById($gid);}
		if ($type == 'select' && $dianpugroups = $groupservice->getGroupById()) {
			$_select = '<select class="select_wa" name="groupid" id="dianpu_groups" title=""><option value="">ѡ</option>';
			foreach ($dianpugroups as $key => $value) {
				$_selected = $gid == $key ? 'selected="selected"' : '';
				$_select .= '<option value="' . $key . '" ' . $_selected . '>' . $value['title'] . '</option>';
			}
			$_select .= '</select>';
			return $_select;
		}
		return '';
	}
	
	/**
	 * ƼȼHTML ָ֧ʽ select / txt
	 * @param int $level
	 * @param string $type (select/txt)
	 * @return string
	 */
	function getDianpuRecommendLevel($level = '', $type = 'select') {
		$dianpu_recommendLevel = L::config('dianpu_recommendLevel', 'dianpu_config');
		if ($type == 'txt' && $level) return $dianpu_recommendLevel[$level];
		if ($type == 'select') {
			$_select = '<select class="select_wa mr5" name="recommendlevel" title="Ƽ">';
			$_select .= '<option value="0"></option>';
			foreach ($dianpu_recommendLevel as $key => $value) {
				$_selected = $level == $key ? 'selected="selected"' : '';
				$_select .= '<option value="' . $key . '" ' . $_selected . '>' . $value . '</option>';
			}
			$_select .= '</select>';
			return $_select;
		}
		return '';
	}
	
	/**
	 * õ֤ʽHTML ֧ checkbox / img / txtʽ
	 * @param string $checkway
	 * @param string $type (checkbox/img/txt)
	 * @return string
	 */
	function getDianpuCheckWay($checkway, $type = 'checkbox') {
		$dianpu_checkway = L::config('dianpu_checkway', 'dianpu_config');
		if (!is_array($checkway) && $type == 'checkbox') $_result = '<ul class="list_A list_80">';
		foreach ((array) $dianpu_checkway as $key => $value) {
			$_checked = strpos(',' . $checkway . ',', ',' . $key . ',') !== false ? 'checked="checked"' : '';
			if ($type == 'checkbox') {
				$_result .= '<li><label><input type="checkbox" value="' . $key . '" name="checkway[]" ' . $_checked . '>' . $value . '</label></li>';
			} elseif ($type == 'img' && strpos(',' . $checkway . ',', ',' . $key . ',') !== false) {
				$_result .= '<span title="' . $value . '" class="B_bg ico_' . $key . ' fl">' . $value . '</span>';
			}
		}
		if ($type == 'checkbox') $_result .= '</ul>';
		return $_result;
	}
	
	/**
	 * Ϣģ
	 */
	function export() {
		$timestamp = $this->_getGlobal('timestamp');
		$filename = "application form.csv";
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $timestamp + 86400) . ' GMT');
		header('Expires: ' . gmdate('D, d M Y H:i:s', $timestamp + 86400) . ' GMT');
		header('Cache-control: max-age=86400');
		header('Content-Encoding: utf-8');
		header("Content-Disposition: attachment; filename=\"{$filename}\"");
		header("Content-type: text/csv");
		header("Content-Transfer-Encoding: binary");
		$_exportData = array('*', '*', '*̾Ӫ', '*Ӫֻ', '˾ȫ', '', '˵绰', '˾ַ', '˾', '˾绰', '˾ʱ');
		echo dataConvert(implode(',', $_exportData));
	}
	
	/**
	 * Ϣ һ֧ർ100
	 * @param int $start
	 * @param int $pernum
	 * @return array
	 */
	function import($start = 0, $pernum = 100) {
		@set_time_limit(888);
		$service = $this->getDianpuService();
		$csvservice = DP::loadClass('csvservice', 'service'); /* @var $csvservice PW_CSVService */
		$dianpuList = $csvservice->getDataList();
		$count = count($dianpuList);
		for ($i = 0; $i < ($pernum > $count ? $count : $pernum); $i++) {
			$dianpu = $this->_setDianpu($dianpuList[$i]);
			$dianpu->setCreatetime($this->_getGlobal('timestamp'));
			$dianpu->setModifytime($this->_getGlobal('timestamp'));
			$dianpu->setState('0');
			$dianpu->setIfcheck('1');
			$dianpu->setGroupid('1');
			if ($dianpu->username && count($service->search(array('username' => array($dianpu->username, 'eq')), 0, 1))) {
				$dianpuList[$i]['comments'] = 'ʧܣõѾڵ';
				continue;
			}
			if ($service->search(array('title' => array($dianpu->title, 'eq')), 0, 1)) {
				$dianpuList[$i]['comments'] = 'ʧܣĵѾڣ';
				continue;
			}
			if ($dianpu->get_error()) {
				$dianpuList[$i]['comments'] = 'ʧܣ' . implode(', ', $dianpu->getMessage());
				continue;
			}
			$did = $service->insertDianpu($dianpu);
			$dianpuList[$i]['dianpuid'] = $did;
			$dianpuList[$i]['comments'] = 'ɹ';
		}
		return $dianpuList;
	}
	
	/**
	 * ӵ˵֤
	 * ̴治/̱ⲻΪ/˵ݲΪ/Ȩ֤
	 * @param array $params
	 * @return boolean
	 */
	function _validationForDianpuContents($params) {
		if (!$params['dianpuid']) return $this->_addError('̲');
		if (!$params['atc_content']) return $this->_addError('˵ݲΪ');
		if (!$params['titles']) return $this->_addError('˵ⲻΪ');
		$service = $this->getDianpuService();
		$dianpu_old = $service->getDianpu($params['dianpuid']);
		$_maxExplain = $dianpu_old->group['configinfo']['maxexplain'];
		$_count = $dianpu_old->contentorder ? count($dianpu_old->contentorder) : 0;
		if ($_maxExplain && $_count > $_maxExplain) return $this->_addError('ڵûӵ˵' . $_maxExplain . 'ҳ');
		return $_count;
	}

}
?>