<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * û۵ֲ
 * @author xiaoxia.xuxx
 */
class PW_CommentHelper extends BaseHelper {
	
	/**
	 * 
	 * @param array $data ۵Ϣ
	 * @return array array(boolean, string) شʾĽ
	 */
	function addComment($data) {
		if (!$data) return array(false, 'Ƿ');
		if (!$data) return $this->_addError('Ƿ');
		$commentService = $this->getCommentService();
		$_result = $commentService->addComment($data);
		if (S::isArray($_result) && $_result[0] === false) return $_result;
		if ($_result) {
			return array(true, '۳ɹ');
		} else {
			return array(false, 'ʧܣ');
		}
	}
	
	/**
	 * ԱIDɾ
	 * @param integer $id ҪɾID
	 * @return array array(boolean, string)شĽǷɹϢ
	 */
	function delCommentForAdmin($id) {
		if (!$id) return array(false, 'ɾʧ');
		$commentService = $this->getCommentService();
		if (!$commentService->delCommentForAdmin($id)) {
			return array(false, 'ɾʧ');
		}
		return array(true, 'ɾɹ');
	}
	
	/**
	 * IDɾ
	 * @param integer $id ҪɾID
	 * @param integer $dianpuid ҪɾڵĵID
	 * @return array array(boolean, string) شĽ
	 */
	function deleteComment($id, $dianpuid) {
		if (!$id || !$dianpuid) return array(false, 'Ƿ');
		$commentService = $this->getCommentService();
		if (!$commentService->deleteComment($id, $dianpuid)) {
			return array(false, 'ɾʧ');
		}
		return array(true, 'ɾɹ');
	}
	
	/**
	 * Աɾ
	 * @param array $ids ҪɾIDб
	 * @return array array(boolean, string)شĽ
	 */
	function delCommentsForAdmin($ids) {
		if (!$ids) return array(false, 'Ƿ');
		$commentService = $this->getCommentService();
		if (!$commentService->delCommentsForAdmin($ids)) {
			return array(false, 'ɾʧ');
		}
		return array(true, 'ɾɹ');
	}
	
	/**
	 * IDбɾ
	 * @param array $ids ҪɾIDб
	 * @param integer $dianpuid Ҫɾ۵ĵID
	 * @return array array(boolean, string)شĽ
	 */
	function deleteComments($ids, $dianpuid) {
		if (!$ids || !$dianpuid) return array(false, 'Ƿ');
		$commentService = $this->getCommentService();
		if (!$commentService->deleteComments($ids, $dianpuid)) {
			return array(false, 'ɾʧ');
		}
		return array(true, 'ɾɹ');
	}
	
	/**
	 * ǰ̨ʾȡһб
	 * @param integer $objectid  ID
	 * @param integer $typeid  ƷID  Ϊ0ֻȡ̵ۣΪ0ȡõиƷ
	 * @param integer $page  ҵķҳҳ
	 * @param integer $perpage ÿҳʾ
	 * @return array  array(count, page, totalpage, rootList, childList) زѯϢ
	 */
	function getFrontCommentList($objectid, $typeid = 0, $page = 1, $perpage = 20) {
		require_once(R_P . 'require/showimg.php');//װغshowfacedesign
		if (!$objectid) return array();
		$commentService = $this->getCommentService();
		$count = $commentService->getFrontCount($objectid, $typeid);
		if ($count == 0) return array();
		list($start, $page, $perpage, $totalPage) = $this->_filterPage($page, $count, $perpage);
		$_rootList = $commentService->getFrontCommentList($objectid, $typeid, $start, $perpage);
		$rootIDs = array_keys($_rootList);
		$_childList = $commentService->getChildCommentList($rootIDs);
		$_replyList = $commentService->getReplyCommentList($objectid, $typeid);
		$_childList = $this->_mergeReplyToChild($_childList, $_replyList);
		return array($count,$page, $totalPage, $_rootList, $_childList);
	}
	
	
	/**
	 * ̼ҹ̨-۹
	 * @param array $params ѯ
	 * @param integer $page ҳ
	 * @param integer $perpage ÿҳʾ
	 * @return array array(count, page, totalpage, commentList) زѯϢ
	 */
	function getShangjiaCommentList($params, $page = 1, $perpage = 20) {
		$params['isanswer'] = 0;//ֻѯǵĻظ
		$commentService = $this->getCommentService();
		$count = $commentService->countTotals($params);
		list($start, $page, $perpage, $totalPage) = $this->_filterPage($page, $count, $perpage);
		$_commentList = $commentService->getSearchCommentList($params, $start, $perpage);
		return array($count, $page, $totalPage, $_commentList);
	}
	
	/**
	 * (վ̨)
	 * @param array $params 
	 * @param integer $page ѯҳ
	 * @param integer $perpage ѯ
	 * @return array array(count, page, totalpage, commentList) زѯϢ
	 */
	function getAdminCommentList($params, $page = 1, $perpage = 20) {	
	    $params['isanswer'] = 'all';
		$commentService = $this->getCommentService();
		$count = $commentService->countTotals($params);
		list($start, $page, $perpage, $totalPage) = $this->_filterPage($page, $count, $perpage);//õǰҳҳ
		$_commentList = $commentService->getSearchCommentList($params, $start, $perpage);
		return array($count, $page, $totalPage, $_commentList);
	}
	
	/**
	 * ؼ¼
	 * @param array $params ҪɸѡĲб
	 * @return integer ؼ¼
	 */
	function countTotals($params) {
		$commentService = $this->getCommentService();
		return $commentService->countTotals($params);
	}
	
	/**
	 * ˷ҳ
	 * @access private
	 * @param integer $page ǰҳ
	 * @param integer $count ܼ¼
	 * @param integer $perPage ÿҳʾ
	 * @return array (ʼλãǰҳ룬ÿҳʾļ¼ҳ)
	 */
	function _filterPage($page, $count, $perPage) {
		(empty($page) || intval($page) <1 ) ? $page = 1 : $page = intval($page);
		(empty($count) || intval($count) < 0) ? $count = 0 : $count = intval($count) ;
		(empty($perPage) || intval($perPage) < 1) ? $perPage = 1 : $perPage = intval($perPage);
		$totalPage = ceil($count/$perPage);
		if ($page > $totalPage) $page = $totalPage;
		$start = ($page - 1) * $perPage;
		$start = intval($start);
		return array($start, $page, $perPage, $totalPage);
	}
	
	/**
	 * 췵طҳurl
	 * @param array $params ҪɷҳĲб
	 * @return string عõurl
	 */
	function getPageUrl($params) {
		$_pager = '';
		if (!S::isArray($params)) return '';
		($params['isanswer']) && $_pager .= '&isanswer=' . $params['isanswer'];
		($params['content']) && $_pager .= '&content=' . urlencode(stripslashes($params['content'])); 
		($params['username']) && $_pager .= '&username=' . urlencode(stripslashes($params['username'])); 
		($params['startdate']) && $_pager .= '&startdate=' . $params['startdate'];
		($params['enddate']) && $_pager .= '&enddate=' . $params['enddate'];
		($params['state']) && $_pager .= '&state=' . $params['state'];
		return $_pager;
	}
	
	
	/**
	 * õǰûȨޣɾظۣ
	 * ĳ̵ĵIDжϵ¼ûǷжԸõ̵۽صĲ
	 * ǵȫȨޣԱ¼ȨޣǹԱ¼ۺɾȨ
	 * @param integer $dianpuUid ID
	 * @return array array'comment', 'del', 'reply') һϵеȨ
	 */
	function getRight($dianpuUid) {
		$right = array();
		$_configService = DP::loadClass("configservice", "service");//鿴Ƿ
		$_config = $_configService->getConfigInfo();
		if ($_config['cancomment'] == 0) return array('comment' => 0);//ûпԹ
		$right['comment'] = 1;
		$winduid = $this->_getGlobal('winduid');//¼ûID
		if (!$winduid) return $right;
		//õǵ¼ߵĵ̣лظɾȨ
		if ($dianpuUid == $winduid) {
			$right['reply'] = 1;
			$right['del'] = 1;
		}
		(isGM($this->_getGlobal('windid'))) && $right['del'] = 1;//жǷǹԱ¼
		return $right;
	}

	/**
	 * ݵȻǰڵȨ޼վȨ޽Ȩж
	 * ĳ̵ĵID жϵǰ¼ûǷиòȨ
	 * @param integer $dianpuUid ID
	 * @param integer $groupRight Ȩ
	 * @param string $type in_array('del', 'comment', 'reply')  
	 * @return array array(boolean, string) жϽΪfalseʲôԭ²
	 */
	function checkRight($dianpuUid, $groupRight, $type = 'all') {
		$right = $this->getRight($dianpuUid);
		if (!in_array($type, array('all', 'del', 'comment', 'reply')))  return array(false, 'Ƿ');
		if (!$right['comment']) return array(false, '۹ѹرգϵվ');
		if (!$groupRight) return array(false, 'ڵĵ鲻');
		return ($type == 'all') ? array(true, '') : ($right[$type] ? array(true, '') : array(false, 'ûвȨ'));
	}
	
	/**
	 * ɷҳhtml
	 * д˰汾еnumofpageԭΪ
	 *     1ajax÷ҳʱ򣬻Ϊҳjsк{}Ŷjsonʧܣ
	 *     2ajax÷ҳʱ ṩûҳıonkeydownĴᵼ뱻ӦΪյ޷תҳ
	 *    д˸÷ȥҳؼonkeydownӦ¼
	 * @param int $count ܼ¼
	 * @param int $page ǰҳ
	 * @param int $numofpage ҳ
	 * @param string $url ҳURL
	 * @param int $max ʾҳ
	 * @param string $ajaxurl ajax÷ҳĵַ
	 * @return string طҳ
	 */
	function NumOfPage($count, $page, $numofpage, $url, $max = null, $ajaxCallBack = '') {
		global $tablecolor;
		$total = $numofpage;
		if (!empty($max)) {
			$max = (int) $max;
			$numofpage > $max && $numofpage = $max;
		}
		if ($numofpage <= 1 || !is_numeric($page)) return '';
		$ajaxurl = $ajaxCallBack ? " onclick=\"return $ajaxCallBack(this.href);\"" : '';
		list($url, $mao) = explode('#', $url);
		$mao && $mao = '#' . $mao;
		$pages = "<div class=\"pages\"><a href=\"{$url}page=1$mao\"{$ajaxurl}>&laquo;</a>";
		for ($i = $page - 3; $i <= $page - 1; $i++) {
			if ($i < 1) continue;
			$pages .= "<a href=\"{$url}page=$i$mao\"{$ajaxurl}>$i</a>";
		}
		$pages .= "<b>$page</b>";
		if ($page < $numofpage) {
			$flag = 0;
			for ($i = $page + 1; $i <= $numofpage; $i++) {
				$pages .= "<a href=\"{$url}page=$i$mao\"{$ajaxurl}>$i</a>";
				$flag++;
				if ($flag == 4) break;
			}
		}
		$pages .= "<a href=\"{$url}page=$numofpage$mao\"{$ajaxurl}>&raquo;</a><div class=\"fl\">{$total}ҳ</div><span class=\"pagesone\"><input type=\"text\" size=\"3\"><button onclick=\"javascript: var page=(this.previousSibling.value>$total) ? $total : this.previousSibling.value; " . ($ajaxurl ? "$ajaxCallBack('{$url}page='+page);" : " location='{$url}page='+page+'{$mao}';") . " return false;\">Go</button></span></div>";
		return $pages;
	}
	
	/**
	 * ۺظУ
	 * ҪظܽŸûظĶʵظֻһ
	 * ѭ$childListԪеббеĳԪID$replyListΪֵֵ£˵лظ
	 * ظڸظĺ棬ûԭȵĺб
	 * @access private
	 * @param array $childList ۣʱ˳Ը۵IDΪڵ㣩
	 * @param array $replyList Ļظۣʱ˳Ը۵IDΪڵ㣩
	 * @return array array('rootid'=>array(),..);ѸIDΪ飬Ҹ˳ķʽ
	 */
	function _mergeReplyToChild($childList, $replyList) {
		foreach ($childList as $rootid => $child) {
			$_tmp = array();
			foreach ($child as $value) {
				$_tmp[] = $value;
				if ($replyList[$value['commentid']]) $_tmp[] = $replyList[$value['commentid']][0];
			}
			$childList[$rootid] = $_tmp;
		}
		return $childList;
	}
}