<?php
!defined('M_P') && exit('Forbidden');
/**
 * û۸DBʵ
 * @author xiaoxia.xuxx
 */
class PW_Dianpu_CommentsDB extends BaseDB {
	var $_tableName = 'pw_dianpu_comments';
	var $_primaryKey = 'commentid';
	
	/**
	 * Ϣ
	 * һϢ뵽pw_dianpu_comments
	 * @param array $fieldData Ϣ
	 * @return integer زID
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/** ̨IDɾһϢ
	 * @param array $commentid  ۵ID
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delForAdmin($commentid) {
		if (!$commentid) return false;
		return $this->_delete($commentid);
	}
	
	/**
	 * ̨ɾϢ
	 * @param array $commentid IDб
	 * @return integer ɾӰ¼
	 */
	function delsForAdmin($commentid) {
		if (!$commentid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ")");
	    return $this->_db->affected_rows();
	}

	/**
	 * ID͵IDɾһϢ
	 * @param array $commentid  ۵ID
	 * @param integer $objectid IDǶID
	 * @return integer ɾӰ쵽ļ¼
	 */
	function delete($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid =" . $this->_addSlashes($commentid) . " AND objectid=" . $this->_addSlashes($objectid));
	    return $this->_db->affected_rows();
	}
	
	/**
	 * ɾϢҪ۵ĵIDǶID
	 * @param array $commentid IDб
	 * @param integer $objectid IDǶID
	 * @return integer ɾӰ¼
	 */
	function deletes($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ") AND objectid=" . $this->_addSlashes($objectid));
	    return $this->_db->affected_rows();
	}
	
	/**
	 * IDй˳иID
	 * ɾ۵ʱ򣬸$CommentIDsɾ¼,˳ID
	 * Ϊȫɾ伶µۣҪȲҳصID
	 * ˴ΪȷбɾIDиIDб
	 * @param array $commentID Ҫɸѡ۵IDб
	 * @param array array(array('commentid'),array('commentid')...)طϵIDб
	 */
	function filterDeleteRootID($commentIDs) {
		if (!$commentIDs) return false;
		if (!S::isArray($commentIDs)) $commentIDs = array($commentIDs);
		$query = $this->_db->query("SELECT commentid FROM " . $this->_tableName . ' WHERE commentid IN (' . $this->_getImplodeString($commentIDs) . ')');
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * õpw_dianpu_commentsݿṹ
	 * @return array ݿݽṹ
	 */
	function getStruct() {
		return array('commentid', 'objectid', 'typeid', 'postdate');
	}
}
?>
	
	