var DP = {
	showMessageId : "showmessage",
	baseUrl : "",

	$ : function(id) {
		return document.getElementById(id);
	},

	/* ajax post submit */
	post : function(url, data, callback, sCallback, fCallback, isTips) {
		var _this = this;
		ajax.send(url, data, function() {
			callback ? callback() : 0;
			isTips ? _this._showMessage(ajax.request.responseText, sCallback,
					fCallback) : 0;
		});
	},

	/* private show message include success and fail */
	_showMessage : function(txt, sCallback, fCallback) {
		if (!txt || txt.indexOf('{') == '-1')
			return false;
		var r = JSONParse(txt);
		if (r.bool) {
			this.showSuccessTips(r.message);
			sCallback ? sCallback() : 0;
		} else {
			this.showFailTips(r.message);
			fCallback ? fCallback() : 0;
		}
	},

	showSuccessTips : function(message, otherid) {
		if (!message)
			return false;
		var mdiv = otherid ? this.$(otherid) : this.$(this.showMessageId);
		mdiv.innerHTML = message;
		mdiv.className = "rightTip mb10"; // ޸
		mdiv.style.display = '';
		return this;
	},

	showFailTips : function(message, otherid) {
		if (!message)
			return false;
		alert(DP.showFailTips.caller);
		var mdiv = otherid ? this.$(otherid) : this.$(this.showMessageId);
		mdiv.innerHTML = message;
		mdiv.className = "wrongTip mb10"; // ޸
		mdiv.style.display = '';
		return this;
	},

	fadeTips : function(otherid) {
		clearTimeout(this.timer);
		var mdiv = otherid ? this.$(otherid) : this.$(this.showMessageId);
		this.timer = setTimeout(function() {
			mdiv.style.display = 'none';
		}, 3000);
	},

	/* ajax get */
	get : function(url, data, id) {
		sendmsg(url, data, id);
	},

	/* show dialog */
	tips : function(type, message, autohide, callback) {
		showDialog(type, message, autohide, callback);
	},

	/* check All */
	CheckAll : function(name, self) {
		var ischeck = self.checked;
		var otherInputs = document.getElementsByName(name);
		var l = otherInputs.length;
		for ( var i = 0; i < l; i++)
			otherInputs[i].checked = ischeck;
	},

	/* ʾع */
	showManagePane : function(ifshow, pid) {
		var mObj = getObj(pid);
		if (!mObj)
			return false;
		if (ifshow == '0' || ifshow == false || ifshow == '' || ifshow == null
				|| ifshow == 'undefined') {
			mObj.style.display = 'none';
		} else {
			mObj.style.display = '';
		}
	},

	/* ıȨ״̬ */
	chengeDianpuGroups : function(value) {
		if (!value) {
			DP.tips('error', 'ѡ飡');
			return false;
		}
		var url = DP.baseUrl + value;
		DP.post(url, '', function() {
			if (ajax.request.responseText == null)
				DP.tips('error', 'ѡ飡');
			var groupinfo = JSONParse(ajax.request.responseText);
			DP.showManagePane(groupinfo['configinfo']['qq'], 'dianpu_qq');
			DP.showManagePane(groupinfo['configinfo']['wangwang'],
					'dianpu_wangwang');
			DP.showManagePane(groupinfo['configinfo']['uploadlogo'],
					'dianpu_logo');
		});
	},

	/* ע¼ */
	setDianpuGroupsEvent : function() {
		var gObj = getObj('dianpu_groups');
		if (!gObj)
			return false;
		gObj.onchange = function() {
			DP.chengeDianpuGroups(this.value)
		};
	},

	isClicked : function(form) {
		var clicks = form.getElementsByTagName('input');
		for ( var i = 0; i < clicks.length; i++) {
			if (clicks[i].type == "checkbox" && clicks[i].checked == true) {
				return true;
			}
		}
		return false;
	},

	unClick : function(form) {
		var clicks = form.getElementsByTagName('input');
		for ( var i = 0; i < clicks.length; i++) {
			if (clicks[i].type == "checkbox") {
				clicks[i].checked = false;
			}
		}
	}
};

var VALIDATOR = {
	message : "",
	result : true,

	init : function(form) {
		this.result = true;
		this._hideError(form);
	},

	init_2 : function(form, vid) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		this.result = true;
		var errorObjs = obj.parentNode.getElementsByTagName('span');
		for ( var i = 0; i < errorObjs.length; i++) {
			if (errorObjs[i].className == "wrongTip") {
				errorObjs[i].parentNode.removeChild(errorObjs[i]);
			}
		}
	},

	uploadsize : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var maxUploadSize = 2000000;
		var path = obj.value.Trim();
		var filesize = 0;
		if (obj.files) {
			if (obj.files[0])
				filesize = obj.files[0].fileSize;
		} else if (window.navigator.userAgent.indexOf("MSIE 6") > 0
				&& !window.XMLHttpRequest) {
			var img = new Image();
			img.dynsrc = path;
			filesize = img.fileSize;
		}
		if (filesize && filesize > maxUploadSize) {
			this.message = '\'' + obj.title + '\'Сܳ2000kb';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	isRequired : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		obj.value = obj.value.Trim();
		if (obj.value == null || obj.value == '' || obj.value == 'undefined') {
			this.message = 'д\'' + obj.title + '\'ύ';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* ƥĸлس֮⣩ */
	isLetter : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = new RegExp('^(.)+$');
		if (obj.value != '' && !patrn.exec(obj.value)) {
			this.message = 'дȷ\'' + obj.title + '\'ύ, ֻĸ//֣';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* ƥ۸ */
	isPrice : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = new RegExp('^[1-9]{1}[0-9]{0,10}(\.[0-9]+)*$');
		if (obj.value != '' && !patrn.exec(obj.value)) {
			this.message = 'дȷ\'' + obj.title + '\'ύ';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* ƥ䳤ȣֽΪλ */
	isLength : function(/* input id */vid, /* min */min, /* max */max,
			showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var byteLength = getByteLength(obj.value);
		if (obj.value != '' && (byteLength < min || byteLength > max)) {
			this.message = 'дȷ\'' + obj.title + '\'ύ,(' + min + '~'
					+ max + 'ֽ)';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* Ƿִֻ0-9 */
	isInt : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = new RegExp('^[0-9]+$');
		if (obj.value != '' && !patrn.exec(obj.value)) {
			this.message = 'дȷ\'' + obj.title + '\'ύ,ֻ֣';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* Уֻ ֺ + ź-  */
	isPhone : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = /^[\d\+\-]+$/;
		if (obj.value != '' && !patrn.test(obj.value)) {
			this.message = 'дȷ\'' + obj.title + '\'ύֻ/(+-)';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* checkedǷѡ */
	isCheck : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		if (!obj.checked) {
			this.message = '\'' + obj.title + '\'ύ';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	_hideError : function(form) {
		var errorObjs = form.getElementsByTagName('span');
		for ( var i = 0; i < errorObjs.length; i++) {
			if (errorObjs[i].className == "wrongTip") {
				errorObjs[i].parentNode.removeChild(errorObjs[i]);
			}
		}
	},

	_showError : function(obj, showTip) {
		this.result = false;
		if (!obj)
			return false;
		if (showTip) {
			DP.tips('error', this.message);
		} else {
			this._errorTips(obj);
		}
	},

	_errorTips : function(obj) {
		var errorObjs = obj.parentNode.getElementsByTagName('span');
		for ( var i = 0; i < errorObjs.length; i++) {
			if (errorObjs[i].className == "wrongTip")
				return false;
		}
		var error = document.createElement('span');
		error.className = "wrongTip";
		error.style.padding = "3px 10px 3px 24px";
		error.id = obj.id + "_wrongTip";
		error.innerHTML = this.message;
		if (obj) {
			obj.style.marginRight = "2px";
			obj.parentNode.appendChild(error);
			// obj.focus();
		}
	}
};

String.prototype.Trim = function() {
	return this.replace(/(^\s*)|(\s*$)/g, "");
}

/* Ĳַֽڳ */
function getByteLength(str) {
	var i, sum;
	sum = 0;
	for (i = 0; i < str.length; i++) {
		if ((str.charCodeAt(i) >= 0) && (str.charCodeAt(i) <= 255)) {
			sum = sum + 1;
		} else {
			sum = sum + 2;
		}
	}
	return sum;
}

/* жǷװQQ */
function checkQQInstall(qq) {
	var url = "http://wpa.qq.com/msgrd?v=3&uin=" + qq
			+ "&site=PHPWIND&menu=yes";
	var link = "http://im.qq.com/";
	try {
		if (window.ActiveXObject) { // IE 汾
			var xmlhttp = new ActiveXObject("TimwpDll.TimwpCheck");
			var n = xmlhttp.GetVersion();
			if (n >= 2.1) {
				window.targer = "_blank";
				window.open(url);
			} else {// ûаװQQ
				showDialog('confirm',
						"ʾ<br/>ĻûаװQQQQ汾ͣػΪ߰汾", 5,
						function() {
							window.target = "_blank";
							window.open(link);
						});
			}
		} else {
			window.targer = "_blank";
			window.open(url);
		}
	} catch (e) {
		showDialog('confirm',
				"ʾ<br/>http://im.qq.com/°QQ/TM֧߽", 5,
				function() {
					window.target = "_top";
					window.open(link);
				});
	}
}
