<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/managecontroller.php';
class dmanageController extends manageController {
	var $_dianpuHelper;
	var $_perpage = 10;
	
	function _before() {
		parent::_before();
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		$this->_viewer->dmanage = 'current';
		return true;
	}
	
	function run() {
		$this->_viewer->db_appsdb = $this->_getGlobal('db_appsdb');
		list($this->_viewer->filetype, $this->_viewer->filetypeinfo) = $this->_dianpuHelper->getUploadFileType();
		$this->_viewer->action = $this->_action;
		$toolsHelper = DP::loadClass('toolshelper', 'helper');
		$this->_viewer->parentCategorySelectHtml = $toolsHelper->createCategoryForAjax($this->_dianpu->parentid, $this->_dianpu->categoryid);
		$this->_viewer->childCategorySelectHtml = $toolsHelper->createCategoryForAjax($this->_dianpu->parentid, $this->_dianpu->categoryid, false);
		$this->_viewer->categoryid = $this->_dianpu->categoryid;
		$this->_viewer->areaSelectHtml = $toolsHelper->createAreaLink($this->_dianpu->areaid, true);
		$this->_viewer->groupsSelectHtml = $this->_dianpuHelper->getDianpuGroups($this->_dianpu->groupid);
		$this->_viewer->checkWaySelectHtml = $this->_dianpuHelper->getDianpuCheckWay($this->_dianpu->checkway);
		$this->_viewer->groupinfo = $this->_dianpu->group;
		$this->_viewer->countexplain = $this->_dianpu->contentorder ? count($this->_dianpu->contentorder) : 0;
		$this->_viewer->windid = $this->_getGlobal('windid');
	}
	
	function getgroupinfo() {
		list($gid) = $this->_gp(array('gid'));
		echo pwJsonEncode($this->_dianpuHelper->getDianpuGroups($gid, 'array'));
		ajax_footer();
	}
	
	/**
	 * ༭
	 */
	function edit() {
		list($id) = $this->_gp(array('dianpuid'));
		list($params) = $this->_gp(array('params'));
		list($params['title']) = $this->_gp(array('atc_title'));
		list($params['bulletin']) = $this->_gp(array('bulletin'), false);
		list($params['groupid'], $params['areaid'], $params['parentid'], $params['categoryid'], $params['checkway']) = $this->_gp(array(
			'groupid', 'areaid', 'categoryid', 'childid', 'checkway'));
		if (!isGM($this->_getGlobal('windid'))) {
			unset($params['checkway']);
			unset($params['groupid']);
		}
		$params['contentorder'] = $this->_dianpu->contentorder;
		if ($this->_dianpuHelper->editDianpu($params, $id)) refreshto($this->_viewer->baseUrl . '&a=run&dianpuid=' . $id . '&', '༭̳ɹ');
		Error::checkError(1);
	}
	
	/**
	 * ɾһ̷ҳ
	 */
	function deletepage() {
		list($contentid, $dianpuid) = $this->_gp(array('contentid', 'dianpuid'));
		if ($this->_dianpuHelper->deletePage($dianpuid, $contentid)) echo "success";
		ajax_footer();
	}
	
	/**
	 * ӱ༭
	 */
	function addcontent() {
		list($dianpuid, $step, $contentid) = $this->_gp(array('dianpuid', 'step', 'contentid'));
		if (empty($step)) {
			if ($contentid) $this->_viewer->dianpuContent = $this->_dianpuHelper->getDianpuContent($contentid);
		} else {
			list($params['titles']) = $this->_gp(array('titles'));
			list($params['atc_content']) = $this->_gp(array('atc_content'), false);
			$params['dianpuid'] = $dianpuid;
			$params['contentid'] = $contentid;
			$params['contentorder'] = $this->_dianpu->contentorder;
			if ($contentid) {
				if ($this->_dianpuHelper->editContents($params)) refreshto($this->_viewer->baseUrl . '&a=run&dianpuid=' . $dianpuid . '&', '༭ݳɹ');
			} else {
				if ($this->_dianpuHelper->addContents($params)) refreshto($this->_viewer->baseUrl . '&a=run&dianpuid=' . $dianpuid . '&', 'ӵݳɹ');
			}
			Error::checkError(1);
		}
	}
	
	/**
	 * ɾlogo
	 */
	function deletelogo() {
		list($id) = $this->_gp(array('dianpuid'));
		if ($this->_dianpuHelper->deleteLogo($id)) refreshto($this->_viewer->baseUrl . '&a=run&dianpuid=' . $id . '&', '༭̳ɹ');
		Error::checkError(1);
	}
	
	/**
	 * ̵ͼҳ
	 */
	function map() {
		$this->_viewer->mapkey = $this->_getGlobal('dianpu_mapkey');
		$this->_viewer->cityName = $this->_getGlobal('dianpu_mapcity');
		$this->_viewer->dianpu = $this->_dianpu;
	}
	
	/**
	 * ʾmap
	 */
	function showmap() {
		$this->_viewer->mapkey = $this->_getGlobal('dianpu_mapkey');
		$this->_viewer->cityName = $this->_getGlobal('dianpu_mapcity');
		$this->_viewer->dianpu = $this->_dianpu;
		$this->_setLayoutFile('map.layout');
		$this->_viewer->maph = '500px';
		$this->_setLayoutType('pw');
	}
	
	/**
	 * ༭ͼ޸
	 */
	function mapedit() {
		list($params['mapx'], $params['mapy'], $params['mapz'], $dianpuid) = $this->_gp(array('mapx', 'mapy', 'mapz', 
			'dianpuid'));
		if ($this->_dianpuHelper->editDianpu($params, $dianpuid)) refreshto($this->_viewer->baseUrl . '&a=map&dianpuid=' . $dianpuid, 'ͼ༭ɹ');
		Error::checkError(1);
	}
	
	/**
	 * б
	 */
	function style() {
		$groupService = DP::loadClass('groupservice', 'service'); /* @var $groupService PW_GroupService */
		$groupinfo = $groupService->getGroupInfo($this->_dianpu->groupid);
		$this->_viewer->dianpuinfo = $this->_dianpu;
		if (!empty($groupinfo['styles'])) {
			$groupHelper = DP::loadClass('groupshelper', 'helper');
			$this->_viewer->styles = $groupHelper->getGroupStyle($groupHelper->getStylesList(), $this->_dianpu->group['styles'], $this->_dianpu->tempstyle);
		}
	}
	
	/**
	 * 
	 */
	function styleedit() {
		list($params['style'], $dianpuid) = $this->_gp(array('style', 'dianpuid'));
		if ($this->_dianpuHelper->editDianpu($params, $dianpuid)) refreshto($this->_viewer->baseUrl . '&a=style&dianpuid=' . $dianpuid, '̷óɹ');
		Error::checkError(1);
	}
}
?>