<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/admincontroller.php';
class ConfigController extends AdminController {
	var $_categoriesHelper;
	var $_styleHelper;
	
	function _before() {
		parent::_before();
		$this->_viewer->baseUrl = $this->_getGlobal('basename');
		$this->_categoriesHelper = DP::loadClass('categorieshelper', 'helper');
		$this->_areasHelper = DP::loadClass('areashelper', 'helper');
		$this->_styleHelper = $this->_getStyleHelper();
		return true;
	}
	
	/**
	 * վϢʾ
	 */
	function run() {
		$_configService = DP::loadClass('configservice', 'service');
		$config = $_configService->getConfigInfo();
		$this->_viewer->canComment[$config['cancomment']] = "checked='checked'"; //Ƿ
		$this->_viewer->starRemark[$config['starremark']] = "checked='checked'"; //̵Ǽ
		$this->_viewer->mapcity = $config['mapcity'];
		$this->_viewer->mapkey = $config['mapkey'];
		$this->_viewer->listNum = $config['listnum']; //ʾ
		$this->_viewer->current['baseinfo'] = 'current';
	}
	
	/**
	 * վ
	 */
	function updateconfig() {
		$_configService = DP::loadClass('configservice', 'service');
		$config = array();
		list($p, $config['cancomment'], $config['listnum'], $config['starremark'], $config['mapcity'], $config['mapkey']) = $this->_gp(array(
			'p', 'canComment', 'listNum', 'starRemark', 'mapcity', 'mapkey'));
		if ($p != 'stepConfig' || !$this->_isPost()) Error::showError("Ƿ", $this->_getGlobal('basename') . '&action=run');
		if ($_configService->updateConfig($config)) Error::showError('վóɹ', $this->_getGlobal('basename') . '&action=run');
		Error::checkError('javascript:history.go(-1);');
	}
	
	/**
	 * ҵ-ҳ
	 */
	function managecategory() {
		list($this->_viewer->categories) = $this->_categoriesHelper->getCategoriesNoCache();
		$this->_viewer->stats = $this->_categoriesHelper->statDianpyCountByCategory();
		$this->_viewer->current['category'] = 'current';
	}
	/**
	 * ҵ-ҵ
	 */
	function addcategory() {
		list($categories, $parent, $child) = $this->_gp(array('categories', 'parent', 'child'));
		list($bool, $message) = $this->_categoriesHelper->addCategories($categories, $parent, $child);
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managecategory'));
	}
	/**
	 * ҵ-ɾҵ
	 */
	function removecategory() {
		list($categoryId) = $this->_gp(array('categoryid'));
		list($bool, $message) = $this->_categoriesHelper->deleteCategory($categoryId);
		Error::showError($message, $this->_categoriesHelper->_buildAdminURL('managecategory'));
	}
	/**
	 * ҵ-תҵ
	 */
	function movecategory() {
		list($step, $categoryId, $source, $target, $sourcechild, $targetchild) = $this->_gp(array('step', 'categoryid', 
			'source', 'target', 'sourcechild', 'targetchild'));
		if ($step == 2 && $this->_isPost()) {
			list($bool, $message) = $this->_categoriesHelper->moveCategory($source, $target, $sourcechild, $targetchild);
			Error::showError($message, $this->_categoriesHelper->_buildAdminURL('managecategory'));
		}
		$category = $this->_categoriesHelper->getCategory($categoryId);
		$defaultCategoryId = $this->_categoriesHelper->getDefaultParentCategory();
		$this->_viewer->sourceOption = $this->_categoriesHelper->getParentOption($category['parentid']);
		$this->_viewer->sorcechildOption = $this->_categoriesHelper->getChildOption($category['parentid'], $category['categoryid']);
		$this->_viewer->targetOption = $this->_categoriesHelper->getParentOption($defaultCategoryId);
		$this->_viewer->targetchildOption = $this->_categoriesHelper->getChildOption($defaultCategoryId);
		$this->_viewer->baseUrl = EncodeUrl($this->_viewer->baseUrl . '&action=movecategory');
		$this->_setLayoutType('ajax');
		$this->_setLayoutFile('ajax');
	}
	/**
	 * ҵ-
	 */
	function linkchild() {
		list($categoryId) = $this->_gp(array('categoryid'));
		echo $this->_categoriesHelper->getChildOption($categoryId);
		ajax_footer();
	}
	/**
	 * -ҳ
	 */
	function managearea() {
		$this->_viewer->areas = $this->_areasHelper->getAreasNoCache();
		$this->_viewer->current['area'] = 'current';
	}
	/**
	 * -ӵ
	 */
	function addarea() {
		list($step, $sort, $name, $presence) = $this->_gp(array('step', 'sort', 'name', 'presence'));
		if ($step == 2) {
			if ($this->_areasHelper->addAreas($presence, $sort, $name)) Error::showError('ɹ', $this->_categoriesHelper->_buildAdminURL('managearea'));
			Error::checkError($this->_categoriesHelper->_buildAdminURL('managearea'));
		}
	}
	/**
	 * -ɾ
	 */
	function deletearea() {
		list($step, $areaId) = $this->_gp(array('step', 'areaid'));
		if ($this->_areasHelper->deleteArea($areaId)) Error::showError('ɾɹ', $this->_categoriesHelper->_buildAdminURL('managearea'));
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managearea'));
	}
	/**
	 * -ҳ
	 */
	function managestyle() {
		$this->_viewer->styles = $this->_styleHelper->getStyles();
		$this->_viewer->current['style'] = 'current';
	}
	/**
	 * -ӷ
	 */
	function addstyle() {
		list($step, $newstyles, $styles) = $this->_gp(array('step', 'newstyles', 'styles'));
		if ($this->_isPost() && $step == 2) {
			$this->_styleHelper->operateStyles($newstyles, $styles);
		}
		Error::showError('ɹ', $this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	/**
	 * -ɾ
	 */
	function deletestyle() {
		list($filename) = $this->_gp(array('filename'));
		list($bool, $message) = $this->_styleHelper->deleteStyle($filename);
		Error::showError($message, $this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	
	/**
	 * -ͣ÷񣨽ĳɾ
	 */
	function stopstyle() {
		list($filename) = $this->_gp(array('filename'));
		if ($this->_styleHelper->stopStyle($filename)) Error::showError('ɹ', $this->_categoriesHelper->_buildAdminURL('managestyle'));
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	
	/**
	 *  -÷񣨽ĳӣ
	 */
	function startstyle() {
		list($filename, $title) = $this->_gp(array('filename', 'title'));
		if ($this->_styleHelper->startStyle($filename, $title)) Error::showError('ɹ', $this->_categoriesHelper->_buildAdminURL('managestyle'));
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	
	/**
	 * @return PW_StyleHelper
	 */
	function _getStyleHelper() {
		return DP::loadClass('stylehelper', 'helper');
	}

}