<?php
!defined('M_P') && exit('Forbidden');

/**
 * 数据编码转换
 * @param string $data
 * @param string $to_encoding 目标编码
 * @return string
 */
function dataConvert($data, $to_encoding = 'gbk') {
	global $db_charset;
	if ($db_charset != $to_encoding) {
		if (function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($data, $to_encoding, $db_charset);
		} else {
			L::loadClass('Chinese', 'utility/lang', false);
			$chs = new Chinese($db_charset, $to_encoding);
			return $chs->Convert($data);
		}
	}
	return $data;
}

/**
 * 设置当前样式风格
 * @param string $currentPage
 * @param string $style
 */
function setDianpuStyle($currentPage = '', $style = '') {
	$_dianpupage = array('info', 'product');
	$_managepage = array('dmanage', 'imanage', 'pmanage', 'cmanage', 'manage');
	$_dianpustyle = 'images/post/minieitor/minieitor.css';
	$_managestyle = 'mode/dianpu/images/admin/adminstyle.css';
	if (in_array($currentPage, $_dianpupage)) {
		$GLOBALS['currentstyle'] = $_dianpustyle;
	} elseif (in_array($currentPage, $_managepage)) {
		$GLOBALS['currentstyle'] = $_managestyle;
	}
	$GLOBALS['dianpustyle'] = 'default';
	if ($style && is_dir('mode/dianpu/themes/'.$style.'/')) $GLOBALS['dianpustyle'] = $style;
}

/**
 * @param string $_page 当前页面信息(list,view)
 * @param string $_definedSeo 自定义SEO配置信息
 * @param string $_fname 板块名称
 * @param string $_types 分类信息
 * @param string $_subject 帖子名称
 * @param string $_tags 标签
 * @param string $_summary 摘要
 */
function dianpuSeoSettings($_page = 'index', $_definedSeo = '', $_category = '', $_subject = '') {
	global $dianpu_sitename;
	$_default = array('title' => '{flmc} | {tzmc} - {wzmc}', 'descp' => '{wzgy} | {wzmc}', 
		'keywords' => '{flmc} , {tzmc} | {wzmc}');
	/* 网站名称，栏目名称，文章名称，标签名称，文章概要  */
	$_replace = array($dianpu_sitename, '', $_category, $_subject, '', '');
	return seoSettings($_definedSeo, $_replace, $_default, '');
}

/**
 * @param string $checkway
 * @param string $type (checkbox/img/txt)
 * @return string
 */
function getDianpuCheckWay($checkway, $type = 'checkbox') {
	$dianpu_checkway = L::config('dianpu_checkway', 'dianpu_config');
	if (!is_array($checkway) && $type == 'checkbox') $_result = '<ul class="list_A list_80">';
	foreach ((array) $dianpu_checkway as $key => $value) {
		$_checked = strpos(',' . $checkway . ',', ',' . $key . ',') !== false ? 'checked="checked"' : '';
		if ($type == 'checkbox') {
			$_result .= '<li><label><input type="checkbox" value="' . $key . '" name="checkway[]" ' . $_checked . '>' . $value . '</label></li>';
		} elseif ($type == 'img' && strpos(',' . $checkway . ',', ',' . $key . ',') !== false) {
			$_result .= '<span title="' . $value . '" class="B_ico ico_' . $key . ' fl">' . $value . '</span>';
		}
	}
	if ($type == 'checkbox') $_result .= '</ul>';
	return $_result;
}

/**
 * 含有中文的截断字符串（去除乱码版）
 * 
 * @author xiaoxia.xuxx
 * @param string $str 需要截断的数据
 * @param integer $length 需要截断的长度
 * @param boolean $isDhtmlentity 是否转义html的实体（例如&nbsp;，这些在截断的时候有影响）
 * ----后台评论内容的截断需要过滤空格，而前台店铺列表页中的公告截断不需要过滤表情和空格
 * @return string 返回截断后的字符串
 */
function substr_cut($str, $length = 30, $isDhtmlentity = false) {
	$_str = trim(htmlspecialchars_decode($str, ENT_QUOTES));
	($isDhtmlentity) && $_str = trim(preg_replace('/\[s:\w*\]|(&nbsp;)/', '', $_str));
	global $db_charset;
	if (strlen($_str) <= $length) return $_str;
	$i = 0;
	if (strtoupper($db_charset) == 'GBK') {
		for ($i = 0; $i < $length; $i++)
			if (ord($_str[$i]) > 128) $i++;
	} else {
	    for ($i = 0; $i < $length; $i++){
	        $value = ord($_str[$i]);
	        if($value > 127){
	            if ($value >= 192 && $value <= 223) $i++;
	            elseif($value >= 224 && $value <= 239) $i = $i + 2;
	            elseif($value >= 240 && $value <= 247) $i = $i + 3;
	        }
	    }
	}
	//如果截到的正好是&gt;或是&#60;这种编码中，则延长截取的线直到该编码结束符号‘;’而不是中间截取
	if (preg_match('/[0-9]|[a-z]|#|&/', $_str[$i])) {
		for ($j=$i; $j < ($i+6); $j++) {
			if ($_str[$j] === ';') {
				$i = $j;
				break;
			}
		}
	 }
	 return substr($_str, 0, $i);
}

class DP extends PW_BaseLoader {
	/**
	 * 类文件的加载入口
	 * 
	 * @param string $className 类的名称
	 * @param string $dir 目录：末尾不需要'/'
	 * @param boolean $isGetInstance 是否实例化
	 * @return mixed
	 */
	function loadClass($className, $dir = '', $isGetInstance = true) {
		return parent::_loadClass($className, 'mode/dianpu/lib/' . parent::_formatDir($dir), $isGetInstance);
	}
	
	/**
	 * 加载db类
	 * @param $className
	 */
	function loadDB($dbName, $dir = '') {
		parent::_loadBaseDB();
		return DP::loadClass($dbName . 'DB', parent::_formatDir($dir) . 'db');
	}
}
?>