<?php
!defined('P_W') && exit('Forbidden');
require_once (R_P . 'lib/base/systemdata.php');
require_once (R_P . 'require/bbscode.php');

/**
 * 店铺多数据调用实现（热门商家/最新加入/推荐商家）
 * @author qiong
 *
 */
class PW_DianpuSource extends SystemData {
	
	var $_cateService;
	var $_lang = array('category' => '分类');
	
	/**
	 * 获得数据调用结果
	 * @param array $config
	 * @param int $num
	 * @return array
	 */
	function getSourceData($config, $num) {
		$config = $this->_initConfig($config);
		$this->_cateService = DP::loadClass('categoriesservice', 'service');
		$_tmp = $this->_getData($config['dianpu'], $num);
		foreach ($_tmp as $key => $value) {
			$_tmp[$key] = $this->_cookData($value);
		}
		return $_tmp;
	}
	
	/**(non-PHPdoc)
	 * @see lib/base/SystemData#getSourceConfig()
	 */
	function getSourceConfig() {
		return array(
			'dianpu' => array('name' => '店铺数据', 'type' => 'select', 
				'value' => array('hot' => '热门商家', 'new' => '最新加入', 'recommend' => '推荐商家')));
	}
	
	/**
	 * @param string $type
	 * @param int $num
	 */
	function _getData($type, $num) {
		if (!$type) $type = 'new';
		switch ($type) {
			case 'new':
				return $this->_getNewDianpuData($num);
			case 'hot':
				return $this->_getHotDianpuData($num);
			case 'recommend':
				return $this->_getRecommendDianpuData($num);
			default:
				return array();
		}
	}
	
	/**
	 * @param array $config
	 * @return array
	 */
	function _initConfig($config) {
		$temp = array();
		$temp['dianpu'] = isset($config['dianpu']) ? $config['dianpu'] : '';
		return $temp;
	}
	
	/**
	 * 获得热门商家数据
	 */
	function _getHotDianpuData($num) {
		$_dianpuservice = $this->_getDianpuService();
		$condition = array('state' => array('1', 'eq'), 'ifcheck' => array('1', 'eq'));
		return $_dianpuservice->searchForList('', '', '', '', '', 'hit', 'DESC', 0, $num);
	}
	
	/**
	 * 获得推荐商家
	 */
	function _getRecommendDianpuData($num) {
		$_dianpuservice = $this->_getDianpuService();
		$condition = array('state' => array('1', 'eq'), 'ifcheck' => array('1', 'eq'));
		return $_dianpuservice->searchForList('', '', '', '', '', 'recommendlevel', 'DESC', 0, $num);
	}
	
	/**
	 * 获得最新店铺数据
	 */
	function _getNewDianpuData($num) {
		$_dianpuservice = $this->_getDianpuService();
		$condition = array('state' => array('1', 'eq'), 'ifcheck' => array('1', 'eq'));
		return $_dianpuservice->searchForList('', '', '', '', '', 'modifytime', 'DESC', 0, $num);
	}
	
	/**
	 * 格式化输出结果
	 * @param unknown_type $data
	 * @return unknown
	 */
	function _cookData($data) {
		global $db_bbsurl, $db_windpost;
		$data['url'] = $db_bbsurl . '/index.php?m=dianpu&c=info&id=' . $data['dianpuid'];
		$data['title'] = convert($data['title'], $db_windpost);
		$data['category'] = $this->_cateService->getCategory($data['categoryid']);
		$data['category'] = $data['category']['name'];
		$data['image'] = $data['logo'];
		return $data;
	}
	
	/**
	 * @return PW_DianpuService
	 */
	function _getDianpuService() {
		return DP::loadClass('dianpuservice', 'service');
	}

}

?>