<?php
!defined('M_P') && exit('Forbidden');

/**
 * 店铺组相关服务
 * @author yishuo
 * 
 */
class PW_GroupService {
	
	/**
	 * 添加店铺组
	 * @param array $data 需要添加的店铺组信息
	 * @return mixed boolean (false :操作失败) | integer 返回插入的ID
	 */
	function insertDianpuGroup($data) {
		if (!is_array($data) || empty($data)) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->insertGroup($data);
	}
	
	/**
	 * 直接从数据库获取根据店铺组ID获得店铺组信息
	 * @param integer $gid 店铺组的ID
	 * @return mixed boolean (false：操作失败) | array  array('字段' => '值')返回的店铺组信息
	 */
	function getGroupInfo($gid) {
		if (!$gid) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->getGroupById($gid);
	}
	
	/**
	 * 根据店铺组ID更新店铺组
	 * @param array $data 需要更新的店铺信息
	 * @param integer $id 需要更新的店铺ID
	 * @return mixed boolean (false: 操作失败) | integer 返回受影响的行数
	 */
	function updateDianpuGroup($data, $id) {
		if (empty($id)) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->updateGroup($data, $id);
	}
	
	/**
	 * 根据店铺组ID删除店铺组
	 * @param integer $gid 需要删除的店铺组ID
	 * @return mixed boolean (false:删除失败) | integer 返回删除操作影响的行数
	 */
	function deleteDianpuGroup($gid) {
		if (empty($gid)) return false;
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->deleteGroupById($gid);
	}
	
	/**
	 * 获得所有店铺组列表
	 * @param integer $start 开始搜索的位置
	 * @param integer $perpage 搜索的条数
	 * @return array array(array('字段' => '值'),...) 返回符合的结果集
	 */
	function getDianpuGroupsByPages($start = '0', $perpage = '0') {
		$_groupDB = $this->_getGroupsDB();
		$_tmp = $_groupDB->getGroupsByPages($start, $perpage);
		return $this->_buildResultList($_tmp);
	}
	
	/**
	 * 统计店铺组
	 * @return integer 返回统计结果
	 */
	function getDianpuGroupsCount() {
		$_groupDB = $this->_getGroupsDB();
		return $_groupDB->getGroupCount();
	}
	
	/**
	 * 根据店铺组ID从缓存文件中获得店铺组信息
	 * @param integer $gid 需要获得店铺组信息的店铺组ID
	 * @return array array('字段' => '值') 返回查询到的店铺组信息
	 */
	function getGroupById($gid = '') {
		if (!$groups = L::config('dianpuGroups', 'dianpu_groups')) $this->updateDianpuGroupCache();
		return $gid ? $groups[$gid] : $groups;
	}
	
	/**
	 * 获得在全站搜索页面展示的推荐店铺组列表
	 * @param string $type 搜索的类别是在全站搜索页面展示的店铺组
	 * @return array array('groupid',...) 返回推荐店铺列表组  
	 */
	function getDianpushowGroups($type = 'dianpushow') {
		$groups = L::config('dianpuGroups', 'dianpu_groups');
		$_result = array();
		foreach ($groups as $key => $value) {
			if (array_key_exists($type, $value['configinfo']) && $value['configinfo'][$type]) $_result[] = $key;
		}
		return $_result;
	}
	
	/**
	 * 更新店铺组缓存
	 * @return void
	 */
	function updateDianpuGroupCache() {
		$_groupDB = $this->_getGroupsDB();
		$_data = $_groupDB->getGroupsByPages();
		$this->_updateCache($this->_buildResultList($_data));
	}
	
	/**
	 * 更新店铺组缓存
	 * @access private
	 * @param array $data array(array('字段' => '值'),...) 根据输入的店铺组信息更新店铺组缓存文件
	 * @return void
	 */
	function _updateCache($data) {
		$_cachefile = D_P . "data/bbscache/dianpu_groups.php";
		writeover($_cachefile, "<?php\r\n\$dianpuGroups=" . pw_var_export($data) . "\r\n?>");
	}
	
	/**
	 * 构造返回的结果集列表
	 * @access private
	 * @param array $result array(array('字段' => '值'),...) 需要构造的结果集
	 * @return mixed boolean (false:操作失败) | array(array('字段' => '值'),...)
	 */
	function _buildResultList($result) {
		if (!is_array($result) || empty($result)) return false;
		$_tmp = array();
		foreach ($result as $key => $value) {
			if ($value['createtime']) $value['createtime'] = get_date($value['createtime'], 'Y-m-d');
			$_tmp[$key] = $value;
		}
		return $_tmp;
	}
	
	/**
	 * 获得店铺组DAO
	 * @access private
	 * @return PW_Dianpu_GroupsDB 
	 */
	function _getGroupsDB() {
		return DP::loadDB('dianpu_groups');
	}
}
?>