<?php
!defined('M_P') && exit('Forbidden');

/**
 * 站点核心设置服务层
 * @author xiaoxiao.xuxx
 */
class PW_ConfigService {
    
	/**
	 * 获得站点设置信息
	 * @return array array('cancomment' => '1', //店铺是否开启留言功能（1为开启）<br/>
	 * 						'listnum' => '15', //店铺首页显示的条数(默认15条)<br/>
	 * 						'starremark' => '1',//店铺的星级点评，1为开启<br/>
	 * 						'mapcity' => '', //店铺地区<br/>
	 * 						'mapkey' => '', //店铺地域mapkey)
	 */
	function getConfigInfo() {
		$dpConfig = array();
		$temp = L::config(NULL, 'dianpu_config');
		$dpConfig['cancomment'] = $this->_isValid($temp['dianpu_cancomment']); 
		$dpConfig['listnum'] = (!$temp['dianpu_listnum']) ? 15 : $temp['dianpu_listnum'];
		$dpConfig['starremark'] = $this->_isValid($temp['dianpu_starremark']);
		$dpConfig['mapcity'] = trim($temp['dianpu_mapcity']);
		$dpConfig['mapkey'] = trim($temp['dianpu_mapkey']);
		return $dpConfig;
	}
	
	/**
	 * 更新站点配置信息
	 * 
	 * @param array $param 配置信息的数组
	 *  (CanComment in array(0,1) 是否设置可以留言，
	 *   starrate 星级点评
	 *   ListNum 设置店铺的显示条数）
	 * @return boolean 更新站点是否成功
	 */
	function updateConfig($param) {
		$param = $this->_clearSiteConfig($param);
		if(!S::isArray($param)) return false;
		foreach ($param as $key => $value) {
			setConfig('dianpu_'.trim($key), $value, NULL, true);//更新hack插件数据库表信息
		}
		updatecache_conf('dianpu', true);//更新date/bbcache/dianpu_config.php
		return true;
	}

	/**
	 * 过滤站点配置信息
	 * @access private
	 * @param array $config 需要过滤的配置信息组
	 * @return mixed boolean (false:操作失败) | array 返回过滤后的数组信息
	 */
	function _clearSiteConfig($config){
		if (!S::isArray($config)) {
			Error::addError('非法操作'); 
			return false;
		}
		$clear = array();
		$clear['cancomment'] = $this->_isValid($config['cancomment']);
		$_tmp = (intval($config['listnum']) == 0) ? 15 : intval($config['listnum']);
	    if (!preg_match('/^[1-9]{1}\d*$/', $_tmp)) {
	    	Error::addError('列表页显示的店铺数必须是正整数！'); 
	    	return false;
	    }
		$clear['listnum'] = $_tmp;
		$clear['starremark'] = $this->_isValid($config['starremark']);
		$clear['mapcity'] = trim($config['mapcity']);
		$clear['mapkey'] = trim($config['mapkey']);
		return $clear;
	}

	/**
	 * 判断是否是有效的数据
	 * @access private
	 * @param integer $var 判断是否是有效的
	 * @return integer 返回判断结果(0 or 1)
	 */
	function _isValid($var) {
		if(!in_array($var, array('0', '1'))) {
			return 1;
		}else{
			return trim($var);
		}
	}
}
?>