<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basemodule.php';
/**
 * 店铺商品业务模型实现
 * @author yishuo
 */
class PW_ProductModule extends BaseModule {
	
	var $productid = null;
	var $objectid = null;
	var $title = null;
	var $description = null;
	var $recommend = null;
	var $market_price = null;
	var $member_price = null;
	var $shelf = null;
	var $photoid = null;
	var $modifiedtime = null;
	var $createdtime = null;
	var $attach = array();
	
	/**
	 * 获得商品的附件
	 * @return void 
	 */
	function setAttach() {
		global $db_allowupload, $_G;
		DP::loadClass('productupload', '', false);
		$uploaddb = array();
		if ($db_allowupload && (PwUpload::getUploadNum()) && (PwUpload::getUploadNum() < 6)) {
			$dianpupload = new PW_ProductUpload();
			$uploaddb = PwUpload::upload($dianpupload, false);
		}
		$this->attach = (array) $uploaddb;
	}

	/**
	 * 设置商品ID
	 * @param integer $productid 商品ID
	 * @return void 
	 */
	function setProductId($productid) {
		$objectId = intval($objectId);
		if ($objectId < 1) $this->_addError('请选择商品ID');
		$this->productid = $productid;
	}
	
	/**
	 * 设置店铺（或者对象）ID
	 * @param integer $objectId 店铺ID
	 * @return void 
	 */
	function setObjectId($objectId) {
		$objectId = intval($objectId);
		if ($objectId < 1)  $this->_addError('请选择店铺ID');
		$this->objectid = $objectId;
	}
	
	/**
	 * 设置商品名称
	 * @param string $title 商品名称
	 * @return void 
	 */
	function setTitle($title) {
		$title = trim($title);
		if ($title == '') $this->_addError('商品名称不能为空');
		$this->_validationFieldLenght($title, 0, 200, '商品名称长度不能大于200个字节');
		$this->_filterWordsfb($title, '商品名称');
		$this->title = $title;
	}
	
	/**
	 * 设置商品描述
	 * @param string $description 商品描述
	 * @return void 
	 */
	function setDescription($description) {
		$this->_filterWordsfb($description, '商品描述');
		$this->description = $this->_filterContent($description);
	}
	
	/**
	 * 设置商品的是否推荐
	 * @param integer $recommend 商品是否推荐
	 * @return void 
	 */
	function setRecommend($recommend) {
		$this->recommend = intval($recommend);
	}
	
	/**
	 * 设置商品市场价格
	 * @param string $marketPrice  市场价格
	 * @return void 
	 */
	function setMarketPrice($marketPrice) {
		if ($marketPrice == '') $this->_addError('商品市场价格不能为空');
		$this->_filterWordsfb($marketPrice, '商品市场价格');
		$this->market_price = $this->_formatPrice($marketPrice);
	}
	
	/**
	 * 设置商品会员价格
	 * @param string $memberPrice 会员价格
	 * @return void 
	 */
	function setMemberPrice($memberPrice) {
		if ($memberPrice == '') $this->_addError('商品会员价格不能为空');
		$this->_filterWordsfb($memberPrice, '商品会员价格');
		$this->member_price = $this->_formatPrice($memberPrice);
	}
	
	/**
	 * 设置商品是否上架下架
	 * @param integer $shelf 上下架 (默认为0：未上架，1为上架）
	 * @return void 
	 */
	function setShelf($shelf) {
		$this->shelf = (in_array($shelf, array(0, 1))) ? $shelf : 1;
	}
	
	/**
	 * 设置商品默认的图片ID
	 * @param integer $photoId 商品默认图片ID
	 * @return void 
	 */
	function setPhotoId($photoId) {
		$this->photoid = intval($photoId);
	}
	
	/**
	 * 设置商品更改的时间
	 * @param string $modifiedTime 商品更新的时间
	 * @return void 
	 */
	function setModifiedTime($modifiedTime) {
		$this->modifiedtime = $modifiedTime;
	}
	
	/**
	 * 设置商品添加时间
	 * @param string $createdtime 商品创建时间
	 * @return void 
	 */
	function setCreatedTime($createdtime) {
		$this->createdtime = $createdtime;
	}

	/**
	 * 过滤内容的函数
	 * @access private
	 * @param string $content 需要过滤的内容
	 * @return string 过滤后的内容
	 */
	function _filterContent($content) {
		$filterUitil = L::loadClass('FilterUtil', 'filter');
		$content = $filterUitil->convert($content);
		foreach (array('wmv', 'rm', 'flash') as $key => $value) {
			if (strpos(",{$GLOBALS['_G']['media']},", ",$value,") === false) {
				$content = preg_replace("/(\[$value=([0-9]{1,3}\,[0-9]{1,3}\,)?)1(\].+?\[\/$value\])/is", "\${1}0\\3", $content);
			}
		}
		$content = preg_replace(array("/<script.*>.*<\/script>/is", "/<(([^\"']|\"[^\"]*\"|'[^']*')*?)>/eis", 
			"/javascript/i"), array("", "\$this->_jscv('\\1')", "java script"), str_replace('.', '&#46;', $content));
		return $content;
	}
}
?>